/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.jboss.dmr.ModelNode;

public final class AnalysisConfiguration {
    private final MissingClassReporting missingClassReporting;
    private final Set<String> useReportingCodes;
    private final Set<File> oldApiBootstrapClasspath;
    private final Set<File> newApiBootstrapClasspath;
    private final boolean ignoreMissingAnnotations;
    private final boolean deepUseChainAnalysis;

    public AnalysisConfiguration(MissingClassReporting missingClassReporting, Set<String> useReportingCodes, Set<File> oldApiBootstrapClasspath, Set<File> newApiBootstrapClasspath, boolean ignoreMissingAnnotations, boolean deepUseChainAnalysis) {
        this.missingClassReporting = missingClassReporting;
        this.useReportingCodes = useReportingCodes;
        this.oldApiBootstrapClasspath = oldApiBootstrapClasspath;
        this.newApiBootstrapClasspath = newApiBootstrapClasspath;
        this.ignoreMissingAnnotations = ignoreMissingAnnotations;
        this.deepUseChainAnalysis = deepUseChainAnalysis;
    }

    public static AnalysisConfiguration fromModel(ModelNode node) {
        MissingClassReporting reporting = AnalysisConfiguration.readMissingClassReporting(node);
        Set<String> useReportingCodes = AnalysisConfiguration.readUseReportingCodes(node);
        Set<File> oldApiBootstrapClasspath = AnalysisConfiguration.readBootstrapClasspath(node, "old");
        Set<File> newApiBootstrapClasspath = AnalysisConfiguration.readBootstrapClasspath(node, "new");
        boolean ignoreMissingAnnotations = AnalysisConfiguration.readIgnoreMissingAnnotations(node);
        boolean deepUseChainAnalysis = AnalysisConfiguration.readDeepUseChainAnalysis(node);
        return new AnalysisConfiguration(reporting, useReportingCodes, oldApiBootstrapClasspath, newApiBootstrapClasspath, ignoreMissingAnnotations, deepUseChainAnalysis);
    }

    public MissingClassReporting getMissingClassReporting() {
        return this.missingClassReporting;
    }

    public Set<String> getUseReportingCodes() {
        return this.useReportingCodes;
    }

    public Set<File> getOldApiBootstrapClasspath() {
        return this.oldApiBootstrapClasspath;
    }

    public Set<File> getNewApiBootstrapClasspath() {
        return this.newApiBootstrapClasspath;
    }

    public boolean isIgnoreMissingAnnotations() {
        return this.ignoreMissingAnnotations;
    }

    public boolean isDeepUseChainAnalysis() {
        return this.deepUseChainAnalysis;
    }

    private static MissingClassReporting readMissingClassReporting(ModelNode analysisConfig) {
        ModelNode config = analysisConfig.get("revapi", "java", "missing-classes", "behavior");
        if (config.isDefined()) {
            switch (config.asString()) {
                case "report": {
                    return MissingClassReporting.REPORT;
                }
                case "ignore": {
                    return MissingClassReporting.IGNORE;
                }
                case "error": {
                    return MissingClassReporting.ERROR;
                }
            }
            throw new IllegalArgumentException("Unsupported value of revapi.java.missing-classes.behavior: '" + config.asString() + "'. Only 'report', 'ignore' and 'error' are recognized.");
        }
        return MissingClassReporting.REPORT;
    }

    private static boolean readIgnoreMissingAnnotations(ModelNode analysisConfig) {
        ModelNode config = analysisConfig.get("revapi", "java", "missing-classes", "ignoreMissingAnnotations");
        if (config.isDefined()) {
            return config.asBoolean();
        }
        return false;
    }

    private static Set<String> readUseReportingCodes(ModelNode analysisConfig) {
        HashSet<String> ret = new HashSet<String>();
        ModelNode config = analysisConfig.get("revapi", "java", "reportUsesFor");
        if (config.isDefined()) {
            for (ModelNode code : config.asList()) {
                ret.add(code.asString());
            }
        } else {
            ret.add("java.missing.oldClass");
            ret.add("java.missing.newClass");
            ret.add("java.class.nonPublicPartOfAPI");
            ret.add("java.class.externalClassExposedInAPI");
            ret.add("java.class.externalClassNoLongerExposedInAPI");
        }
        return ret;
    }

    private static Set<File> readBootstrapClasspath(ModelNode analysisConfig, String api) {
        HashSet<File> ret = new HashSet<File>();
        ModelNode config = analysisConfig.get("revapi", "java", "bootstrap-classpath", api);
        String javaHome = AnalysisConfiguration.getJavaHome(config);
        if (config.isDefined()) {
            ModelNode jars = config.get("jars");
            if (jars.isDefined()) {
                for (ModelNode jar : jars.asList()) {
                    File f = new File(javaHome, jar.asString());
                    if (!f.exists() || !f.canRead()) continue;
                    ret.add(f);
                }
            } else {
                AnalysisConfiguration.addDefaultBootstrapJars(ret, javaHome);
            }
        } else {
            AnalysisConfiguration.addDefaultBootstrapJars(ret, javaHome);
        }
        return ret;
    }

    private static void addDefaultBootstrapJars(Set<File> result, String javaHome) {
        AnalysisConfiguration.addBootstrapJar(result, javaHome, "resources.jar");
        AnalysisConfiguration.addBootstrapJar(result, javaHome, "rt.jar");
        AnalysisConfiguration.addBootstrapJar(result, javaHome, "sunrsasign.jar");
        AnalysisConfiguration.addBootstrapJar(result, javaHome, "jsse.jar");
        AnalysisConfiguration.addBootstrapJar(result, javaHome, "jce.jar");
        AnalysisConfiguration.addBootstrapJar(result, javaHome, "charsets.jar");
        AnalysisConfiguration.addBootstrapJar(result, javaHome, "jfr.jar");
    }

    private static void addBootstrapJar(Set<File> result, String javaHome, String jar) {
        File f = new File(javaHome, jar);
        if (f.exists() && f.canRead()) {
            result.add(f);
        }
    }

    private static String getJavaHome(ModelNode bootstrapClasspathConfiguration) {
        ModelNode javaHomeNode = bootstrapClasspathConfiguration.isDefined() ? bootstrapClasspathConfiguration.get("java-home") : null;
        String javaHome = javaHomeNode != null && javaHomeNode.isDefined() ? javaHomeNode.asString() : System.getProperty("java.home");
        javaHome = javaHome + File.separator + File.separator + "lib";
        return javaHome;
    }

    private static boolean readDeepUseChainAnalysis(ModelNode analysisConfig) {
        ModelNode config = analysisConfig.get("revapi", "java", "deepUseChainAnalysis");
        return config.isDefined() && config.asBoolean();
    }

    public static enum MissingClassReporting {
        IGNORE,
        ERROR,
        REPORT;

    }
}

