/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.classes;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.lang.model.element.TypeElement;
import org.revapi.Difference;
import org.revapi.java.checks.ConfigurationAwareCheckBase;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.Util;

public final class NonPublicClassPartOfAPI
extends ConfigurationAwareCheckBase {
    @Override
    public EnumSet<Check.Type> getInterest() {
        return this.isSkipUseTracking() ? EnumSet.noneOf(Check.Type.class) : EnumSet.of(Check.Type.CLASS);
    }

    @Override
    protected void doVisitClass(TypeElement oldType, TypeElement newType) {
        if (newType == null) {
            return;
        }
        if (!this.isAccessible(newType) && this.isAccessibleOrInAPI(newType, this.getNewTypeEnvironment())) {
            this.pushActive(oldType, newType, new Object[0]);
        }
    }

    @Override
    protected List<Difference> doEnd() {
        CheckBase.ActiveElements types = this.popIfActive();
        if (types == null) {
            return null;
        }
        return Collections.singletonList(this.createDifference(Code.CLASS_NON_PUBLIC_PART_OF_API, new Object[]{types.newElement}, new Object[]{Util.toHumanReadableString(types.newElement)}));
    }
}

