/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.methods;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleElementVisitor7;
import javax.lang.model.util.SimpleTypeVisitor7;
import org.revapi.CoIterator;
import org.revapi.Difference;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.Util;

public class ExceptionsThrownChanged
extends CheckBase {
    private static final SimpleTypeVisitor7<TypeElement, Void> CONVERT_TO_ELEMENT = new SimpleTypeVisitor7<TypeElement, Void>(){

        @Override
        public TypeElement visitDeclared(DeclaredType t, Void ignored) {
            return t.asElement().accept(new SimpleElementVisitor7<TypeElement, Void>(){

                @Override
                public TypeElement visitType(TypeElement e, Void aVoid) {
                    return e;
                }
            }, null);
        }
    };

    @Override
    public EnumSet<Check.Type> getInterest() {
        return EnumSet.of(Check.Type.METHOD);
    }

    @Override
    protected void doVisitMethod(@Nullable ExecutableElement oldMethod, @Nullable ExecutableElement newMethod) {
        Set newExceptionClassNames;
        if (oldMethod == null || newMethod == null) {
            return;
        }
        List<? extends TypeMirror> oldExceptions = oldMethod.getThrownTypes();
        List<? extends TypeMirror> newExceptions = newMethod.getThrownTypes();
        Set oldExceptionClassNames = oldExceptions.isEmpty() ? Collections.emptySet() : oldExceptions.stream().map(Util::toUniqueString).collect(Collectors.toSet());
        Set set = newExceptionClassNames = newExceptions.isEmpty() ? Collections.emptySet() : newExceptions.stream().map(Util::toUniqueString).collect(Collectors.toSet());
        if (!(oldExceptions.isEmpty() && newExceptions.isEmpty() || oldExceptionClassNames.equals(newExceptionClassNames))) {
            this.pushActive(oldMethod, newMethod, new Object[0]);
        }
    }

    @Override
    @Nullable
    protected List<Difference> doEnd() {
        CheckBase.ActiveElements methods = this.popIfActive();
        if (methods == null) {
            return null;
        }
        ArrayList<? extends TypeMirror> oldExceptions = new ArrayList<TypeMirror>(((ExecutableElement)methods.oldElement).getThrownTypes());
        ArrayList<? extends TypeMirror> newExceptions = new ArrayList<TypeMirror>(((ExecutableElement)methods.newElement).getThrownTypes());
        Comparator byClassName = (a, b) -> Util.toUniqueString(a).compareTo(Util.toUniqueString(b));
        Collections.sort(oldExceptions, byClassName);
        Collections.sort(newExceptions, byClassName);
        CoIterator it = new CoIterator(oldExceptions.iterator(), newExceptions.iterator(), byClassName);
        ArrayList<String> removedRuntimeExceptions = new ArrayList<String>();
        ArrayList<String> addedRuntimeExceptions = new ArrayList<String>();
        ArrayList<String> removedCheckedExceptions = new ArrayList<String>();
        ArrayList<String> addedCheckedExceptions = new ArrayList<String>();
        boolean reportSomething = false;
        while (it.hasNext()) {
            TypeElement newException;
            it.next();
            TypeMirror oldType = (TypeMirror)it.getLeft();
            TypeMirror newType = (TypeMirror)it.getRight();
            if (oldType != null && newType != null) continue;
            reportSomething = true;
            TypeElement oldException = oldType == null ? null : oldType.accept(CONVERT_TO_ELEMENT, null);
            TypeElement typeElement = newException = newType == null ? null : newType.accept(CONVERT_TO_ELEMENT, null);
            if (oldException != null) {
                if (this.isRuntimeException(oldException)) {
                    removedRuntimeExceptions.add(oldException.getQualifiedName().toString());
                    continue;
                }
                removedCheckedExceptions.add(oldException.getQualifiedName().toString());
                continue;
            }
            if (newException == null) continue;
            if (this.isRuntimeException(newException)) {
                addedRuntimeExceptions.add(newException.getQualifiedName().toString());
                continue;
            }
            addedCheckedExceptions.add(newException.getQualifiedName().toString());
        }
        if (!reportSomething) {
            return null;
        }
        ArrayList<Difference> ret = new ArrayList<Difference>();
        if (!removedRuntimeExceptions.isEmpty()) {
            ret.add(this.createDifference(Code.METHOD_RUNTIME_EXCEPTION_REMOVED, removedRuntimeExceptions));
        }
        if (!addedRuntimeExceptions.isEmpty()) {
            ret.add(this.createDifference(Code.METHOD_RUNTIME_EXCEPTION_ADDED, addedRuntimeExceptions));
        }
        if (!addedCheckedExceptions.isEmpty()) {
            ret.add(this.createDifference(Code.METHOD_CHECKED_EXCEPTION_ADDED, addedCheckedExceptions));
        }
        if (!removedCheckedExceptions.isEmpty()) {
            ret.add(this.createDifference(Code.METHOD_CHECKED_EXCEPTION_REMOVED, removedCheckedExceptions));
        }
        return ret;
    }

    private boolean isRuntimeException(TypeElement exception) {
        while (exception != null) {
            Name fqn = exception.getQualifiedName();
            if (fqn.contentEquals("java.lang.RuntimeException")) {
                return true;
            }
            if (fqn.contentEquals("java.lang.Error")) {
                return true;
            }
            if (fqn.contentEquals("java.lang.Exception")) {
                return false;
            }
            if (fqn.contentEquals("java.lang.Throwable")) {
                return false;
            }
            exception = exception.getSuperclass().accept(CONVERT_TO_ELEMENT, null);
        }
        return false;
    }
}

