/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.filters;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.SimpleElementVisitor8;
import org.revapi.API;
import org.revapi.Archive;
import org.revapi.Element;
import org.revapi.java.filters.AbstractIncludeExcludeFilter;
import org.revapi.java.spi.JavaModelElement;
import org.revapi.java.spi.TypeEnvironment;
import org.revapi.query.Filter;

public class PackageFilter
extends AbstractIncludeExcludeFilter {
    private final Map<String, JavaPackageElement> packageElements = new HashMap<String, JavaPackageElement>();

    public PackageFilter() {
        super("revapi.java.filter.packages", "/META-INF/package-filter-schema.json");
    }

    @Override
    protected boolean canBeReIncluded(JavaModelElement element) {
        return false;
    }

    @Override
    protected Stream<String> getTestedElementRepresentations(JavaModelElement element) {
        return Stream.of(this.getPackageOf(element.getModelElement()).getQualifiedName().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean applies(@Nullable Element element) {
        JavaPackageElement pkgE;
        if (this.doNothing || !(element instanceof JavaModelElement)) {
            return true;
        }
        PackageElement pkg = this.getPackageOf(((JavaModelElement)element).getModelElement());
        if (pkg == null) {
            return true;
        }
        String packageName = pkg.getQualifiedName().toString();
        Map<String, JavaPackageElement> map = this.packageElements;
        synchronized (map) {
            pkgE = this.packageElements.get(packageName);
            if (pkgE == null) {
                pkgE = new JavaPackageElement(pkg);
                this.packageElements.put(packageName, pkgE);
            }
        }
        return super.applies(pkgE);
    }

    private PackageElement getPackageOf(javax.lang.model.element.Element element) {
        return element.accept(new SimpleElementVisitor8<PackageElement, Void>(){

            @Override
            public PackageElement visitVariable(VariableElement e, Void ignored) {
                return e.getEnclosingElement().accept(this, null);
            }

            @Override
            public PackageElement visitExecutable(ExecutableElement e, Void ignored) {
                return e.getEnclosingElement().accept(this, null);
            }

            @Override
            public PackageElement visitType(TypeElement e, Void ignored) {
                return e.getEnclosingElement().accept(this, null);
            }

            @Override
            public PackageElement visitPackage(PackageElement e, Void ignored) {
                return e;
            }

            @Override
            public PackageElement visitTypeParameter(TypeParameterElement e, Void aVoid) {
                return e.getEnclosingElement().accept(this, null);
            }
        }, null);
    }

    private static final class JavaPackageElement
    implements JavaModelElement {
        private final String name;
        private final PackageElement pkg;

        public JavaPackageElement(PackageElement pkg) {
            this.name = "package " + pkg.getQualifiedName().toString();
            this.pkg = pkg;
        }

        @Override
        @Nonnull
        public PackageElement getModelElement() {
            return this.pkg;
        }

        @Override
        @Nonnull
        public TypeEnvironment getTypeEnvironment() {
            return null;
        }

        @Nonnull
        public API getApi() {
            return null;
        }

        @Nullable
        public Archive getArchive() {
            return null;
        }

        @Nullable
        public Element getParent() {
            return null;
        }

        public void setParent(@Nullable Element parent) {
        }

        @Nonnull
        public SortedSet<? extends Element> getChildren() {
            return Collections.emptyNavigableSet();
        }

        @Nonnull
        public String getFullHumanReadableString() {
            return this.name;
        }

        @Nonnull
        public <T extends Element> List<T> searchChildren(@Nonnull Class<T> resultType, boolean recurse, @Nullable Filter<? super T> filter) {
            return Collections.emptyList();
        }

        public <T extends Element> void searchChildren(@Nonnull List<T> results, @Nonnull Class<T> resultType, boolean recurse, @Nullable Filter<? super T> filter) {
        }

        @Nonnull
        public <T extends Element> Iterator<T> iterateOverChildren(@Nonnull Class<T> resultType, boolean recurse, @Nullable Filter<? super T> filter) {
            return Collections.emptyIterator();
        }

        public int compareTo(Element o) {
            return 0;
        }

        public String toString() {
            return this.name;
        }
    }
}

