/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.model;

import javax.annotation.Nonnull;
import javax.lang.model.AnnotatedConstruct;
import org.revapi.Archive;
import org.revapi.Element;
import org.revapi.java.compilation.ProbingEnvironment;
import org.revapi.java.model.JavaElementBase;
import org.revapi.java.model.JavaElementFactory;
import org.revapi.java.spi.JavaTypeElement;
import org.revapi.java.spi.Util;

public class TypeElement
extends JavaElementBase<javax.lang.model.element.TypeElement>
implements JavaTypeElement {
    private final String binaryName;
    private final String canonicalName;

    public TypeElement(ProbingEnvironment env, Archive archive, String binaryName, String canonicalName) {
        super(env, archive, null);
        this.binaryName = binaryName;
        this.canonicalName = canonicalName;
    }

    public TypeElement(ProbingEnvironment env, Archive archive, javax.lang.model.element.TypeElement element) {
        super(env, archive, element);
        this.binaryName = env.getElementUtils().getBinaryName(element).toString();
        this.canonicalName = element.getQualifiedName().toString();
    }

    public boolean isInnerClass() {
        int dotPos = -1;
        do {
            if ((dotPos = this.canonicalName.indexOf(46, dotPos + 1)) < 0 || this.binaryName.charAt(dotPos) != '$') continue;
            return true;
        } while (dotPos >= 0);
        return false;
    }

    @Override
    @Nonnull
    protected String getHumanReadableElementType() {
        return "class";
    }

    @Override
    @Nonnull
    public javax.lang.model.element.TypeElement getModelElement() {
        if (this.element == null && this.environment.hasProcessingEnvironment()) {
            this.element = this.environment.getElementUtils().getTypeElement(this.canonicalName);
        }
        return (javax.lang.model.element.TypeElement)this.element;
    }

    public String getBinaryName() {
        return this.binaryName;
    }

    public String getCanonicalName() {
        return this.canonicalName;
    }

    @Override
    public int compareTo(@Nonnull Element o) {
        if (!o.getClass().equals(TypeElement.class)) {
            return JavaElementFactory.compareByType((Element)this, o);
        }
        return this.binaryName.compareTo(((TypeElement)o).binaryName);
    }

    @Override
    @Nonnull
    public String getFullHumanReadableString() {
        javax.lang.model.element.TypeElement el = this.getModelElement();
        return this.getHumanReadableElementType() + " " + (el == null ? this.canonicalName : Util.toHumanReadableString((AnnotatedConstruct)el));
    }

    @Override
    protected String createComparableSignature() {
        return null;
    }
}

