/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.methods;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.revapi.Difference;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.Util;

public final class ParameterTypeChanged
extends CheckBase {
    private boolean skip;

    public EnumSet<Check.Type> getInterest() {
        return EnumSet.of(Check.Type.METHOD, Check.Type.METHOD_PARAMETER);
    }

    protected void doVisitMethod(@Nullable ExecutableElement oldMethod, @Nullable ExecutableElement newMethod) {
        this.skip = oldMethod == null || newMethod == null || oldMethod.getParameters().size() != newMethod.getParameters().size();
    }

    protected void doVisitMethodParameter(@Nullable VariableElement oldParameter, @Nullable VariableElement newParameter) {
        String newType;
        if (this.skip || oldParameter == null || newParameter == null) {
            return;
        }
        if (this.isBothPrivate(oldParameter.getEnclosingElement(), newParameter.getEnclosingElement())) {
            return;
        }
        String oldType = Util.toUniqueString((TypeMirror)oldParameter.asType());
        if (!oldType.equals(newType = Util.toUniqueString((TypeMirror)newParameter.asType()))) {
            this.pushActive(oldParameter, newParameter, new Object[0]);
        }
    }

    @Nullable
    protected List<Difference> doEnd() {
        CheckBase.ActiveElements params = this.popIfActive();
        if (params == null) {
            return null;
        }
        String oldType = Util.toHumanReadableString((AnnotatedConstruct)((VariableElement)params.oldElement).asType());
        String newType = Util.toHumanReadableString((AnnotatedConstruct)((VariableElement)params.newElement).asType());
        return Collections.singletonList(this.createDifference(Code.METHOD_PARAMETER_TYPE_CHANGED, new Object[]{oldType, newType}));
    }
}

