/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.transforms.methods;

import java.io.Reader;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import org.revapi.AnalysisContext;
import org.revapi.Difference;
import org.revapi.DifferenceTransform;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.JavaModelElement;

public final class AnnotationTypeAttributeAdded
implements DifferenceTransform<JavaModelElement> {
    private Locale locale;
    private final Pattern[] codes = new Pattern[]{Pattern.compile("^" + Pattern.quote(Code.METHOD_ABSTRACT_METHOD_ADDED.code()) + "$")};

    @Nonnull
    public Pattern[] getDifferenceCodePatterns() {
        return this.codes;
    }

    @Nullable
    public String[] getConfigurationRootPaths() {
        return null;
    }

    @Nullable
    public Reader getJSONSchema(@Nonnull String configurationRootPath) {
        return null;
    }

    public void initialize(@Nonnull AnalysisContext analysisContext) {
        this.locale = analysisContext.getLocale();
    }

    @Nullable
    public Difference transform(@Nullable JavaModelElement oldElement, @Nullable JavaModelElement newElement, @Nonnull Difference difference) {
        ExecutableElement method = (ExecutableElement)newElement.getModelElement();
        if (method.getEnclosingElement().getKind() == ElementKind.ANNOTATION_TYPE) {
            AnnotationValue defaultValue = method.getDefaultValue();
            if (defaultValue == null) {
                return Code.METHOD_ATTRIBUTE_WITH_NO_DEFAULT_ADDED_TO_ANNOTATION_TYPE.createDifference(this.locale);
            }
            return Code.METHOD_ATTRIBUTE_WITH_DEFAULT_ADDED_TO_ANNOTATION_TYPE.createDifference(this.locale);
        }
        return difference;
    }

    public void close() {
    }
}

