/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.junitbenchmarks;

import com.carrotsearch.junitbenchmarks.BenchmarkOptionsSystemProperties;
import com.carrotsearch.junitbenchmarks.BenchmarkStatement;
import com.carrotsearch.junitbenchmarks.IResultsConsumer;
import java.lang.reflect.Field;
import org.junit.internal.runners.statements.ExpectException;
import org.junit.internal.runners.statements.FailOnTimeout;
import org.junit.internal.runners.statements.RunAfters;
import org.junit.internal.runners.statements.RunBefores;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public final class BenchmarkRule
implements TestRule {
    private final IResultsConsumer[] consumers;

    public BenchmarkRule() {
        this(BenchmarkOptionsSystemProperties.getDefaultConsumers());
    }

    public BenchmarkRule(IResultsConsumer ... consumers) {
        if (consumers == null || consumers.length == 0) {
            throw new IllegalArgumentException("There needs to be at least one consumer.");
        }
        this.consumers = consumers;
    }

    public Statement apply(Statement base, Description description) {
        try {
            if (this.workAroundWrappedStatements(base, description)) {
                return base;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new BenchmarkStatement(base, description, this.consumers);
    }

    private boolean workAroundWrappedStatements(Statement statement, Description description) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = null;
        Statement object = null;
        if (statement instanceof RunAfters) {
            object = statement;
            field = object.getClass().getDeclaredField("fNext");
            field.setAccessible(true);
            statement = (Statement)field.get(object);
        }
        if (statement instanceof RunBefores) {
            object = statement;
            field = object.getClass().getDeclaredField("fNext");
            field.setAccessible(true);
            statement = (Statement)field.get(object);
        }
        if (statement instanceof FailOnTimeout) {
            object = statement;
            field = object.getClass().getDeclaredField("fOriginalStatement");
            field.setAccessible(true);
            statement = (Statement)field.get(object);
        }
        if (statement instanceof ExpectException) {
            object = statement;
            field = object.getClass().getDeclaredField("fNext");
            field.setAccessible(true);
            statement = (Statement)field.get(object);
        }
        if (field == null) {
            return false;
        }
        field.set(object, (Object)new BenchmarkStatement(statement, description, this.consumers));
        return true;
    }
}

