/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.script;

import java.io.File;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.script.ScriptService;
import org.scijava.util.AppUtils;

public class ScriptServiceTest {
    @Test
    public void testSystemProperty() {
        String slash = File.separator;
        String sep = File.pathSeparator;
        String root = new File(slash).getAbsolutePath();
        String dir1 = root + "foo" + slash + "bar";
        String dir2 = root + "to" + slash + "the" + slash + "moon";
        System.setProperty("scijava.scripts.path", dir1 + sep + dir2);
        Context context = new Context(new Class[]{ScriptService.class});
        ScriptService scriptService = (ScriptService)context.service(ScriptService.class);
        List scriptDirs = scriptService.getScriptDirectories();
        Assert.assertEquals((long)3L, (long)scriptDirs.size());
        File baseDir = AppUtils.getBaseDirectory(ScriptService.class);
        String dir0 = baseDir.getPath() + slash + "scripts";
        Assert.assertEquals((Object)dir0, (Object)((File)scriptDirs.get(0)).getAbsolutePath());
        Assert.assertEquals((Object)dir1, (Object)((File)scriptDirs.get(1)).getAbsolutePath());
        Assert.assertEquals((Object)dir2, (Object)((File)scriptDirs.get(2)).getAbsolutePath());
    }
}

