/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.menu;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.MenuPath;
import org.scijava.menu.ShadowMenu;
import org.scijava.menu.ShadowMenuIterator;
import org.scijava.module.DefaultMutableModuleInfo;
import org.scijava.module.ModuleInfo;

public class ShadowMenuTest {
    @Test
    public void testStructure() {
        ShadowMenu root = this.createShadowMenu();
        this.checkStructure(root);
    }

    @Test
    public void testIterator() {
        ShadowMenu root = this.createShadowMenu();
        ShadowMenuIterator iter = root.iterator();
        this.checkIter(iter, "Copy");
        this.checkIter(iter, "Cut");
        this.checkIter(iter, "Paste");
        this.checkIter(iter, "Exit");
        this.checkIter(iter, "Image");
        this.checkIter(iter, "Text Window");
        this.checkIter(iter, "Open");
        this.checkIter(iter, "Save");
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testAdd() {
        ShadowMenu root = this.createShadowMenu();
        root.add(this.createModuleInfo("Edit>Clear"));
        ShadowMenu edit = (ShadowMenu)root.getChildren().get(0);
        ShadowMenu editClear = (ShadowMenu)edit.getChildren().get(0);
        this.checkNode(editClear, "Clear", 1, 1, 0);
    }

    @Test
    public void testRemove() {
        ShadowMenu root = this.createShadowMenu();
        ModuleInfo createDoc = this.createModuleInfo("File>New>Document");
        root.add(createDoc);
        root.remove((Object)createDoc);
        this.checkStructure(root);
        ModuleInfo importData = this.createModuleInfo("File>Import>Data");
        root.add(importData);
        root.remove((Object)importData);
        this.checkStructure(root);
    }

    @Test
    public void testGetMenu() {
        ShadowMenu root = this.createShadowMenu();
        ShadowMenu eFile = (ShadowMenu)root.getChildren().get(1);
        ShadowMenu aFile = root.getMenu(new MenuPath("File"));
        Assert.assertEquals((Object)eFile, (Object)aFile);
        ShadowMenu eFileNew = (ShadowMenu)eFile.getChildren().get(1);
        ShadowMenu aFileNew1 = root.getMenu(new MenuPath("File>New"));
        Assert.assertEquals((Object)eFileNew, (Object)aFileNew1);
        ShadowMenu aFileNew2 = eFile.getMenu(new MenuPath("New"));
        Assert.assertEquals((Object)eFileNew, (Object)aFileNew2);
        ShadowMenu eFileNewImage = (ShadowMenu)eFileNew.getChildren().get(0);
        ShadowMenu aFileNewImage1 = root.getMenu(new MenuPath("File>New>Image"));
        Assert.assertEquals((Object)eFileNewImage, (Object)aFileNewImage1);
        ShadowMenu aFileNewImage2 = aFile.getMenu(new MenuPath("New>Image"));
        Assert.assertEquals((Object)eFileNewImage, (Object)aFileNewImage2);
        ShadowMenu aFileNewImage3 = eFileNew.getMenu(new MenuPath("Image"));
        Assert.assertEquals((Object)eFileNewImage, (Object)aFileNewImage3);
    }

    private ShadowMenu createShadowMenu() {
        Context context = new Context(true);
        ArrayList<ModuleInfo> modules = new ArrayList<ModuleInfo>();
        modules.add(this.createModuleInfo("Edit>Copy"));
        modules.add(this.createModuleInfo("Edit>Cut"));
        modules.add(this.createModuleInfo("Edit>Paste"));
        modules.add(this.createModuleInfo("File>Exit"));
        modules.add(this.createModuleInfo("File>New>Image"));
        modules.add(this.createModuleInfo("File>New>Text Window"));
        modules.add(this.createModuleInfo("File>Open"));
        modules.add(this.createModuleInfo("File>Save"));
        return new ShadowMenu(context, modules);
    }

    private ModuleInfo createModuleInfo(String path) {
        DefaultMutableModuleInfo info = new DefaultMutableModuleInfo();
        info.setMenuPath(new MenuPath(path));
        return info;
    }

    private void checkStructure(ShadowMenu root) {
        Assert.assertNull((Object)root.getParent());
        List<ShadowMenu> rootChildren = this.checkNode(root, null, 8, -1, 2);
        ShadowMenu edit = rootChildren.get(0);
        List<ShadowMenu> editChildren = this.checkNode(edit, "Edit", 3, 0, 3);
        ShadowMenu file = rootChildren.get(1);
        List<ShadowMenu> fileChildren = this.checkNode(file, "File", 5, 0, 4);
        ShadowMenu editCopy = editChildren.get(0);
        this.checkNode(editCopy, "Copy", 1, 1, 0);
        ShadowMenu editCut = editChildren.get(1);
        this.checkNode(editCut, "Cut", 1, 1, 0);
        ShadowMenu editPaste = editChildren.get(2);
        this.checkNode(editPaste, "Paste", 1, 1, 0);
        ShadowMenu fileExit = fileChildren.get(0);
        this.checkNode(fileExit, "Exit", 1, 1, 0);
        ShadowMenu fileNew = fileChildren.get(1);
        List<ShadowMenu> fileNewChildren = this.checkNode(fileNew, "New", 2, 1, 2);
        ShadowMenu fileNewImage = fileNewChildren.get(0);
        this.checkNode(fileNewImage, "Image", 1, 2, 0);
        ShadowMenu fileNewTextWindow = fileNewChildren.get(1);
        this.checkNode(fileNewTextWindow, "Text Window", 1, 2, 0);
        ShadowMenu fileOpen = fileChildren.get(2);
        this.checkNode(fileOpen, "Open", 1, 1, 0);
        ShadowMenu fileSave = fileChildren.get(3);
        this.checkNode(fileSave, "Save", 1, 1, 0);
    }

    private List<ShadowMenu> checkNode(ShadowMenu node, String name, int size, int depth, int childCount) {
        if (name == null) {
            Assert.assertNull((Object)node.getMenuEntry());
        } else {
            Assert.assertEquals((Object)name, (Object)node.getMenuEntry().getName());
        }
        Assert.assertEquals((long)size, (long)node.size());
        Assert.assertEquals((long)depth, (long)node.getMenuDepth());
        List children = node.getChildren();
        Assert.assertNotNull((Object)children);
        Assert.assertEquals((long)childCount, (long)children.size());
        boolean leaf = children.isEmpty();
        Assert.assertEquals((Object)leaf, (Object)node.isLeaf());
        if (leaf) {
            Assert.assertNotNull((Object)node.getModuleInfo());
        } else {
            Assert.assertNull((Object)node.getModuleInfo());
        }
        for (ShadowMenu child : children) {
            Assert.assertEquals((Object)node, (Object)child.getParent());
        }
        return children;
    }

    private void checkIter(ShadowMenuIterator iter, String name) {
        Assert.assertTrue((boolean)iter.hasNext());
        ModuleInfo info = iter.next();
        Assert.assertEquals((Object)name, (Object)info.getMenuPath().getLeaf().getName());
    }
}

