/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.scijava.command.Command;
import org.scijava.command.CommandInfo;
import org.scijava.command.CommandModule;
import org.scijava.command.CommandService;
import org.scijava.event.EventHandler;
import org.scijava.event.EventService;
import org.scijava.log.LogService;
import org.scijava.module.ModuleService;
import org.scijava.plugin.AbstractPTService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.plugin.PluginInfo;
import org.scijava.plugin.PluginService;
import org.scijava.plugin.SciJavaPlugin;
import org.scijava.plugin.event.PluginsAddedEvent;
import org.scijava.plugin.event.PluginsRemovedEvent;
import org.scijava.service.Service;
import org.scijava.util.ListUtils;

@Plugin(type=Service.class)
public class DefaultCommandService
extends AbstractPTService<Command>
implements CommandService {
    @Parameter
    private LogService log;
    @Parameter
    private EventService eventService;
    @Parameter
    private PluginService pluginService;
    @Parameter
    private ModuleService moduleService;
    private HashMap<PluginInfo<?>, CommandInfo> commandMap;

    @Override
    public EventService getEventService() {
        return this.eventService;
    }

    @Override
    public PluginService getPluginService() {
        return this.pluginService;
    }

    @Override
    public ModuleService getModuleService() {
        return this.moduleService;
    }

    @Override
    public List<CommandInfo> getCommands() {
        return this.getCommandsOfType(Command.class);
    }

    @Override
    public <CT extends Command> List<CommandInfo> getCommands(List<PluginInfo<CT>> plugins) {
        List<CommandInfo> commands = this.getCommandsUnknown(this.downcast(plugins));
        return commands;
    }

    @Override
    public <CT extends Command> List<CommandInfo> getCommandsOfType(Class<CT> type) {
        return this.getCommands(this.pluginService.getPluginsOfType(type));
    }

    @Override
    public <C extends Command> CommandInfo getCommand(Class<C> commandClass) {
        return ListUtils.first(this.getCommandsOfClass(commandClass));
    }

    @Override
    public CommandInfo getCommand(String className) {
        return ListUtils.first(this.getCommandsOfClass(className));
    }

    @Override
    public <C extends Command> List<CommandInfo> getCommandsOfClass(Class<C> commandClass) {
        List plugins = this.pluginService.getPluginsOfClass(commandClass, Command.class);
        List<CommandInfo> commands = this.getCommands(plugins);
        return commands;
    }

    @Override
    public List<CommandInfo> getCommandsOfClass(String className) {
        List plugins = this.pluginService.getPluginsOfClass(className);
        List<CommandInfo> commands = this.getCommandsUnknown(this.downcast(plugins));
        return commands;
    }

    @Override
    public Future<CommandModule> run(String className, boolean process, Object ... inputs) {
        return this.run(this.getOrCreate(className), process, inputs);
    }

    @Override
    public Future<CommandModule> run(String className, boolean process, Map<String, Object> inputMap) {
        return this.run(this.getOrCreate(className), process, inputMap);
    }

    @Override
    public <C extends Command> Future<CommandModule> run(Class<C> commandClass, boolean process, Object ... inputs) {
        return this.run(this.getOrCreate(commandClass), process, inputs);
    }

    @Override
    public <C extends Command> Future<CommandModule> run(Class<C> commandClass, boolean process, Map<String, Object> inputMap) {
        return this.run(this.getOrCreate(commandClass), process, inputMap);
    }

    @Override
    public Future<CommandModule> run(CommandInfo info, boolean process, Object ... inputs) {
        Future<CommandInfo> future = this.moduleService.run(info, process, inputs);
        return future;
    }

    @Override
    public Future<CommandModule> run(CommandInfo info, boolean process, Map<String, Object> inputMap) {
        Future<CommandInfo> future = this.moduleService.run(info, process, inputMap);
        return future;
    }

    @Override
    public Class<Command> getPluginType() {
        return Command.class;
    }

    @Override
    public void initialize() {
        this.commandMap = new HashMap();
        List<PluginInfo<Command>> plugins = this.pluginService.getPluginsOfType(Command.class);
        this.addCommands(plugins);
    }

    @EventHandler
    protected void onEvent(PluginsRemovedEvent event) {
        this.removeCommands(event.getItems());
    }

    @EventHandler
    protected void onEvent(PluginsAddedEvent event) {
        ArrayList<PluginInfo<Command>> commands = new ArrayList<PluginInfo<Command>>();
        this.findCommandPlugins(event.getItems(), commands);
        this.addCommands(commands);
    }

    private CommandInfo getOrCreate(String className) {
        CommandInfo command = this.getCommand(className);
        if (command != null) {
            return command;
        }
        return new CommandInfo(className);
    }

    private <C extends Command> CommandInfo getOrCreate(Class<C> commandClass) {
        CommandInfo command = this.getCommand(commandClass);
        if (command != null) {
            return command;
        }
        return new CommandInfo(commandClass);
    }

    private void addCommands(List<PluginInfo<Command>> plugins) {
        ArrayList<CommandInfo> commands = new ArrayList<CommandInfo>();
        for (PluginInfo<Command> info : plugins) {
            CommandInfo commandInfo = this.wrapAsCommand(info);
            commands.add(commandInfo);
            this.commandMap.put(info, commandInfo);
        }
        this.moduleService.addModules(commands);
    }

    private void removeCommands(List<PluginInfo<?>> plugins) {
        List<CommandInfo> commands = this.getCommandsUnknown(plugins);
        for (CommandInfo info : commands) {
            this.commandMap.remove(info);
        }
        this.moduleService.removeModules(commands);
    }

    private List<CommandInfo> getCommandsUnknown(List<PluginInfo<?>> plugins) {
        ArrayList<CommandInfo> commands = new ArrayList<CommandInfo>();
        for (PluginInfo<?> info : plugins) {
            CommandInfo commandInfo = this.commandMap.get(info);
            if (commandInfo == null) continue;
            commands.add(commandInfo);
        }
        return commands;
    }

    private void findCommandPlugins(List<? extends PluginInfo<?>> srcList, List<PluginInfo<Command>> destList) {
        for (PluginInfo<?> info : srcList) {
            if (!this.isCommand(info)) continue;
            PluginInfo<?> match = info;
            destList.add(match);
        }
    }

    private boolean isCommand(PluginInfo<?> info) {
        return Command.class.isAssignableFrom(info.getPluginType());
    }

    private CommandInfo wrapAsCommand(PluginInfo<Command> pluginInfo) {
        if (pluginInfo instanceof CommandInfo) {
            return (CommandInfo)pluginInfo;
        }
        return new CommandInfo(pluginInfo);
    }

    private <PT extends SciJavaPlugin> List<PluginInfo<?>> downcast(List<PluginInfo<PT>> plugins) {
        List<PluginInfo<?>> typedPlugins = plugins;
        return typedPlugins;
    }
}

