/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.object;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.scijava.object.ObjectIndex;

public class SortedObjectIndex<E extends Comparable<? super E>>
extends ObjectIndex<E> {
    public SortedObjectIndex(Class<E> baseClass) {
        super(baseClass);
    }

    @Override
    public boolean contains(Object o) {
        int index = this.findInList(o, this.getAll());
        return index < 0;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (c.size() > 1) {
            this.mergeAfterSorting(c);
            return c.size() > 0;
        }
        if (c.size() == 1) {
            return this.add(c.iterator().next());
        }
        boolean changed = super.addAll(c);
        if (changed) {
            this.sort();
        }
        return changed;
    }

    private void mergeAfterSorting(Collection<? extends E> c) {
        ArrayList<E> listToMerge = new ArrayList<E>(c);
        Collections.sort(listToMerge);
        HashMap map = new HashMap();
        for (Comparable comparable : listToMerge) {
            for (Class<?> clazz : SortedObjectIndex.getTypes(this.getType(comparable))) {
                ArrayList list = this.retrieveList(clazz);
                List list2 = (List)map.get(clazz);
                if (list2 == null) {
                    list2 = list.size() == 0 ? list : new ArrayList();
                    map.put(clazz, list2);
                }
                list2.add(comparable);
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            List sorted;
            Class clazz = (Class)entry.getKey();
            List into = this.retrieveList(clazz);
            if (into == (sorted = (List)map.get(clazz))) continue;
            this.mergeInto(sorted, into);
        }
    }

    private void mergeInto(List<? extends E> sorted, List<E> into) {
        if (sorted == into) {
            return;
        }
        int count = sorted.size();
        if (count == 0) {
            return;
        }
        if (into.size() == 0) {
            into.addAll(sorted);
            return;
        }
        int index1 = into.size() - 1;
        int index2 = sorted.size() - 1;
        for (int i = 0; i < count; ++i) {
            into.add(null);
        }
        int writeIndex = into.size() - 1;
        Comparable e1 = (Comparable)into.get(index1);
        Comparable e2 = (Comparable)sorted.get(index2);
        while (writeIndex > index1) {
            if (e1.compareTo(e2) < 0) {
                into.set(writeIndex--, e2);
                if (--index2 < 0) break;
                e2 = (Comparable)sorted.get(index2);
                continue;
            }
            into.set(writeIndex--, e1);
            if (--index1 < 0) break;
            e1 = (Comparable)into.get(index1);
        }
        while (index2 >= 0) {
            into.set(writeIndex--, sorted.get(index2--));
        }
    }

    @Override
    protected boolean addToList(E obj, List<E> list, boolean batch) {
        if (batch) {
            return super.addToList(obj, list, batch);
        }
        int result = Collections.binarySearch(list, obj);
        int index = result < 0 ? -result - 1 : result;
        list.add(index, obj);
        return true;
    }

    private void sort() {
        for (List list : this.hoard.values()) {
            Collections.sort(list);
        }
    }

    private int findInList(Object o, List<E> list) {
        if (!this.getBaseClass().isAssignableFrom(o.getClass())) {
            return list.size();
        }
        Comparable typedObj = (Comparable)o;
        return Collections.binarySearch(list, typedObj);
    }
}

