/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.menu;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.scijava.event.EventHandler;
import org.scijava.event.EventService;
import org.scijava.menu.MenuCreator;
import org.scijava.menu.MenuService;
import org.scijava.menu.ShadowMenu;
import org.scijava.module.ModuleInfo;
import org.scijava.module.ModuleService;
import org.scijava.module.event.ModulesAddedEvent;
import org.scijava.module.event.ModulesRemovedEvent;
import org.scijava.module.event.ModulesUpdatedEvent;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;

@Plugin(type=Service.class)
public class DefaultMenuService
extends AbstractService
implements MenuService {
    @Parameter
    private EventService eventService;
    @Parameter
    private ModuleService moduleService;
    private HashMap<String, ShadowMenu> rootMenus;

    @Override
    public ShadowMenu getMenu() {
        return this.getMenu("app");
    }

    @Override
    public ShadowMenu getMenu(String menuRoot) {
        return this.rootMenus().get(menuRoot);
    }

    @Override
    public <T> T createMenus(MenuCreator<T> creator, T menu) {
        return this.createMenus("app", creator, menu);
    }

    @Override
    public <T> T createMenus(String menuRoot, MenuCreator<T> creator, T menu) {
        creator.createMenus(this.getMenu(menuRoot), menu);
        return menu;
    }

    @EventHandler
    protected void onEvent(ModulesAddedEvent event) {
        if (this.rootMenus == null) {
            this.rootMenus();
            return;
        }
        this.addModules(event.getItems());
    }

    @EventHandler
    protected void onEvent(ModulesRemovedEvent event) {
        for (ShadowMenu menu : this.rootMenus().values()) {
            menu.removeAll(event.getItems());
        }
    }

    @EventHandler
    protected void onEvent(ModulesUpdatedEvent event) {
        for (ShadowMenu menu : this.rootMenus().values()) {
            menu.updateAll(event.getItems());
        }
    }

    private synchronized void addModules(Collection<ModuleInfo> items) {
        HashMap<String, ArrayList<ModuleInfo>> modulesByMenuRoot = new HashMap<String, ArrayList<ModuleInfo>>();
        for (ModuleInfo info : items) {
            String menuRoot = info.getMenuRoot();
            ArrayList<ModuleInfo> modules = (ArrayList<ModuleInfo>)modulesByMenuRoot.get(menuRoot);
            if (modules == null) {
                modules = new ArrayList<ModuleInfo>();
                modulesByMenuRoot.put(menuRoot, modules);
            }
            modules.add(info);
        }
        for (String menuRoot : modulesByMenuRoot.keySet()) {
            ArrayList modules = (ArrayList)modulesByMenuRoot.get(menuRoot);
            ShadowMenu menu = this.rootMenus().get(menuRoot);
            if (menu == null) {
                menu = new ShadowMenu(this.getContext(), modules);
                this.rootMenus().put(menuRoot, menu);
                continue;
            }
            menu.addAll(modules);
        }
    }

    private HashMap<String, ShadowMenu> rootMenus() {
        if (this.rootMenus == null) {
            this.initRootMenus();
        }
        return this.rootMenus;
    }

    private synchronized void initRootMenus() {
        if (this.rootMenus != null) {
            return;
        }
        HashMap map = new HashMap();
        List<ModuleInfo> allModules = this.moduleService.getModules();
        this.addModules(allModules);
        this.rootMenus = map;
    }
}

