/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import org.junit.Assert;
import org.junit.Test;
import org.scijava.util.DigestUtils;

public class DigestUtilsTest {
    private static final byte[] CAFEBABE_SHA1 = new byte[]{20, 101, -38, -47, 38, -45, 43, -9, -86, 93, 59, -107, -91, -57, -61, 49, -51, -1, 52, -33};
    private static final byte[] CAFEBABE_MD5 = new byte[]{45, 27, -67, -30, -84, -84, 10, -3, 7, 100, 109, -104, 21, 79, 64, 46};
    private static final byte[] HELLO_WORLD_SHA1 = new byte[]{123, 80, 44, 58, 31, 72, -56, 96, -102, -30, 18, -51, -5, 99, -99, -18, 57, 103, 63, 94};
    private static final String HELLO_WORLD_SHA1_HEX = "7b502c3a1f48c8609ae212cdfb639dee39673f5e";
    private static final String CAFEBABE_SHA1_HEX = "1465dad126d32bf7aa5d3b95a5c7c331cdff34df";
    private static final String HELLO_WORLD_SHA1_BASE64 = "e1AsOh9IyGCa4hLN+2Od7jlnP14=";
    private static final String CAFEBABE_SHA1_BASE64 = "FGXa0SbTK/eqXTuVpcfDMc3/NN8=";

    @Test
    public void testBytesString() {
        String s = "Hello world";
        byte[] bytes = DigestUtils.bytes((String)"Hello world");
        byte[] expected = new byte[]{72, 101, 108, 108, 111, 32, 119, 111, 114, 108, 100};
        Assert.assertArrayEquals((byte[])expected, (byte[])bytes);
    }

    @Test
    public void testBytesInt() {
        byte[] bytes = DigestUtils.bytes((int)-889275714);
        byte[] expected = new byte[]{-54, -2, -70, -66};
        Assert.assertArrayEquals((byte[])expected, (byte[])bytes);
    }

    @Test
    public void testHex() {
        Assert.assertEquals((Object)"cafebabe", (Object)DigestUtils.hex((byte[])DigestUtils.bytes((int)-889275714)));
        Assert.assertEquals((Object)"deadbeef", (Object)DigestUtils.hex((byte[])DigestUtils.bytes((int)-559038737)));
        Assert.assertEquals((Object)"00000000", (Object)DigestUtils.hex((byte[])DigestUtils.bytes((int)0)));
        Assert.assertEquals((Object)"ffffffff", (Object)DigestUtils.hex((byte[])DigestUtils.bytes((int)-1)));
    }

    @Test
    public void testBase64() {
        Assert.assertEquals((Object)"yv66vg==", (Object)DigestUtils.base64((byte[])DigestUtils.bytes((int)-889275714)));
        Assert.assertEquals((Object)"3q2+7w==", (Object)DigestUtils.base64((byte[])DigestUtils.bytes((int)-559038737)));
        Assert.assertEquals((Object)"AAAAAA==", (Object)DigestUtils.base64((byte[])DigestUtils.bytes((int)0)));
        Assert.assertEquals((Object)"/////w==", (Object)DigestUtils.base64((byte[])DigestUtils.bytes((int)-1)));
    }

    @Test
    public void testHashString() {
        byte[] hash = DigestUtils.hash((String)"Hello world");
        byte[] expected = new byte[]{-50, 89, -118, -92};
        Assert.assertArrayEquals((byte[])expected, (byte[])hash);
    }

    @Test
    public void testHashBytes() {
        byte[] bytes = DigestUtils.bytes((String)"Hello world");
        byte[] hash = DigestUtils.hash((byte[])bytes);
        byte[] expected = new byte[]{-50, 89, -118, -92};
        Assert.assertArrayEquals((byte[])expected, (byte[])hash);
    }

    @Test
    public void testSHA1() {
        byte[] bytes = DigestUtils.bytes((int)-889275714);
        byte[] sha1 = DigestUtils.sha1((byte[])bytes);
        Assert.assertArrayEquals((byte[])CAFEBABE_SHA1, (byte[])sha1);
    }

    @Test
    public void testMD5() {
        byte[] bytes = DigestUtils.bytes((int)-889275714);
        byte[] md5 = DigestUtils.md5((byte[])bytes);
        Assert.assertArrayEquals((byte[])CAFEBABE_MD5, (byte[])md5);
    }

    @Test
    public void testDigest() {
        byte[] bytes = DigestUtils.bytes((int)-889275714);
        byte[] sha1 = DigestUtils.digest((String)"SHA-1", (byte[])bytes);
        byte[] expectedSHA1 = DigestUtils.sha1((byte[])bytes);
        Assert.assertArrayEquals((byte[])expectedSHA1, (byte[])sha1);
        byte[] md5 = DigestUtils.digest((String)"MD5", (byte[])bytes);
        byte[] expectedMD5 = DigestUtils.md5((byte[])bytes);
        Assert.assertArrayEquals((byte[])expectedMD5, (byte[])md5);
    }

    @Test
    public void testBestString() {
        byte[] best = DigestUtils.best((String)"Hello world");
        Assert.assertArrayEquals((byte[])HELLO_WORLD_SHA1, (byte[])best);
    }

    @Test
    public void testBestBytes() {
        byte[] bytes = DigestUtils.bytes((int)-889275714);
        byte[] best = DigestUtils.best((byte[])bytes);
        Assert.assertArrayEquals((byte[])CAFEBABE_SHA1, (byte[])best);
    }

    @Test
    public void testBestHexString() {
        Assert.assertEquals((Object)HELLO_WORLD_SHA1_HEX, (Object)DigestUtils.bestHex((String)"Hello world"));
    }

    @Test
    public void testBestHexBytes() {
        byte[] bytes = DigestUtils.bytes((int)-889275714);
        Assert.assertEquals((Object)CAFEBABE_SHA1_HEX, (Object)DigestUtils.bestHex((byte[])bytes));
    }

    @Test
    public void testBestBase64String() {
        Assert.assertEquals((Object)HELLO_WORLD_SHA1_BASE64, (Object)DigestUtils.bestBase64((String)"Hello world"));
    }

    @Test
    public void testBestBase64Bytes() {
        byte[] bytes = DigestUtils.bytes((int)-889275714);
        Assert.assertEquals((Object)CAFEBABE_SHA1_BASE64, (Object)DigestUtils.bestBase64((byte[])bytes));
    }
}

