/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.console;

import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.scijava.console.AbstractConsoleArgument;
import org.scijava.console.ConsoleArgument;
import org.scijava.plugin.Plugin;

@Plugin(type=ConsoleArgument.class)
public class SystemPropertyArgument
extends AbstractConsoleArgument {
    private static final String SYS_PROP_REGEX = "-D([\\w\\._-]+)(=(.*))?";
    private static final Pattern SYS_PROP_PAT = Pattern.compile("-D([\\w\\._-]+)(=(.*))?");

    @Override
    public void handle(LinkedList<String> args) {
        if (!this.supports(args)) {
            return;
        }
        String arg = args.removeFirst();
        Matcher m = SYS_PROP_PAT.matcher(arg);
        if (!m.matches()) {
            throw new IllegalArgumentException("Invalid argument: " + arg);
        }
        String key = m.group(1);
        String value = m.group(3);
        System.setProperty(key, value == null ? "" : value);
    }

    @Override
    public boolean supports(LinkedList<String> args) {
        if (args == null || args.isEmpty()) {
            return false;
        }
        String arg = args.getFirst();
        if (!arg.startsWith("-D")) {
            return false;
        }
        return SYS_PROP_PAT.matcher(arg).matches();
    }
}

