/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.util.ArrayList;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.util.ObjectArray;
import org.scijava.util.PrimitiveArray;
import org.scijava.util.PrimitiveArrayTest;

public class ObjectArrayTest
extends PrimitiveArrayTest {
    @Test
    public void testConstructorNoArgs() {
        ObjectArray array = new ObjectArray(Integer.class);
        Assert.assertEquals((long)0L, (long)array.size());
        Assert.assertEquals((long)0L, (long)((Integer[])array.copyArray()).length);
    }

    @Test
    public void testConstructorSize() {
        int size = 24;
        ObjectArray array = new ObjectArray(Integer.class, 24);
        Assert.assertEquals((long)24L, (long)array.size());
        Assert.assertEquals((long)24L, (long)((Integer[])array.copyArray()).length);
    }

    @Test
    public void testConstructorArray() {
        Object[] raw = new Integer[]{3, 5, 8, 13, 21};
        ObjectArray array = new ObjectArray(raw);
        Assert.assertSame((Object)raw, (Object)array.getArray());
        Assert.assertEquals((long)raw.length, (long)array.size());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (Object)raw[i], (Object)array.getValue(i));
        }
        Assert.assertArrayEquals((Object[])raw, (Object[])((Object[])array.copyArray()));
    }

    @Test
    public void testAddValue() {
        Integer[] raw = new Integer[]{3, 5, 8, 13, 21};
        ObjectArray array = new ObjectArray((Object[])raw.clone());
        Integer e6 = 1;
        Integer e7 = 2;
        array.addValue((Object)e6);
        array.addValue((Object)e7);
        Assert.assertEquals((long)(raw.length + 2), (long)array.size());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (Object)raw[i], (Object)array.getValue(i));
        }
        Assert.assertEquals((Object)e6, (Object)array.getValue(5));
        Assert.assertEquals((Object)e7, (Object)array.getValue(6));
    }

    public void testRemoveValue() {
        Integer[] raw = new Integer[]{3, 5, 8, 13, 21};
        ObjectArray array = new ObjectArray((Object[])raw.clone());
        Assert.assertEquals((long)raw.length, (long)array.size());
        array.removeValue((Object)raw[0]);
        Assert.assertEquals((long)(raw.length - 1), (long)array.size());
        array.removeValue((Object)raw[2]);
        Assert.assertEquals((long)(raw.length - 2), (long)array.size());
        array.removeValue((Object)raw[4]);
        Assert.assertEquals((long)(raw.length - 3), (long)array.size());
        Assert.assertEquals((Object)raw[1], (Object)array.getValue(0));
        Assert.assertEquals((Object)raw[3], (Object)array.getValue(1));
    }

    public void testGetValue() {
        Integer[] raw = new Integer[]{3, 5, 8, 13, 21};
        ObjectArray array = new ObjectArray((Object[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (Object)raw[i], (Object)array.getValue(i));
        }
    }

    @Test
    public void testSetValue() {
        Integer[] raw = new Integer[]{3, 5, 8, 13, 21};
        ObjectArray array = new ObjectArray((Object[])raw.clone());
        Integer e0 = 7;
        Integer e2 = 1;
        Integer e4 = 2;
        array.setValue(0, (Object)e0);
        array.setValue(2, (Object)e2);
        array.setValue(4, (Object)e4);
        Assert.assertEquals((long)raw.length, (long)array.size());
        Assert.assertEquals((Object)e0, (Object)array.getValue(0));
        Assert.assertEquals((Object)raw[1], (Object)array.getValue(1));
        Assert.assertEquals((Object)e2, (Object)array.getValue(2));
        Assert.assertEquals((Object)raw[3], (Object)array.getValue(3));
        Assert.assertEquals((Object)e4, (Object)array.getValue(4));
    }

    @Test
    public void testAddValueIndex() {
        Integer[] raw = new Integer[]{3, 5, 8, 13, 21};
        ObjectArray array = new ObjectArray((Object[])raw.clone());
        Integer e0 = 7;
        Integer e4 = 1;
        Integer e7 = 2;
        array.addValue(0, (Object)e0);
        array.addValue(4, (Object)e4);
        array.addValue(7, (Object)e7);
        Assert.assertEquals((long)(raw.length + 3), (long)array.size());
        Assert.assertEquals((Object)e0, (Object)array.getValue(0));
        Assert.assertEquals((Object)raw[0], (Object)array.getValue(1));
        Assert.assertEquals((Object)raw[1], (Object)array.getValue(2));
        Assert.assertEquals((Object)raw[2], (Object)array.getValue(3));
        Assert.assertEquals((Object)e4, (Object)array.getValue(4));
        Assert.assertEquals((Object)raw[3], (Object)array.getValue(5));
        Assert.assertEquals((Object)raw[4], (Object)array.getValue(6));
        Assert.assertEquals((Object)e7, (Object)array.getValue(7));
    }

    public void testRemoveIndex() {
        Integer[] raw = new Integer[]{3, 5, 8, 13, 21};
        ObjectArray array = new ObjectArray((Object[])raw.clone());
        Assert.assertEquals((long)raw.length, (long)array.size());
        array.remove(0);
        Assert.assertEquals((long)(raw.length - 1), (long)array.size());
        array.remove(2);
        Assert.assertEquals((long)(raw.length - 2), (long)array.size());
        array.remove(4);
        Assert.assertEquals((long)(raw.length - 3), (long)array.size());
        Assert.assertEquals((Object)raw[1], (Object)array.getValue(0));
        Assert.assertEquals((Object)raw[3], (Object)array.getValue(1));
    }

    @Test
    public void testIndexOf() {
        Integer[] raw = new Integer[]{3, 5, 8, 13, 21};
        ObjectArray array = new ObjectArray((Object[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)i, (long)array.indexOf((Object)raw[i]));
        }
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)-1));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)0));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)1));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)Integer.MAX_VALUE));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)Integer.MIN_VALUE));
    }

    @Test
    public void testLastIndexOf() {
        Integer[] raw = new Integer[]{3, 5, 8, 13, 21};
        ObjectArray array = new ObjectArray((Object[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)i, (long)array.lastIndexOf((Object)raw[i]));
        }
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)-1));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)0));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)1));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)Integer.MAX_VALUE));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)Integer.MIN_VALUE));
    }

    @Test
    public void testContains() {
        Integer[] raw = new Integer[]{3, 5, 8, 13, 21};
        ObjectArray array = new ObjectArray((Object[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertTrue((String)("@" + i), (boolean)array.contains((Object)raw[i]));
        }
        Assert.assertFalse((boolean)array.contains((Object)-1));
        Assert.assertFalse((boolean)array.contains((Object)0));
        Assert.assertFalse((boolean)array.contains((Object)1));
        Assert.assertFalse((boolean)array.contains((Object)Integer.MAX_VALUE));
        Assert.assertFalse((boolean)array.contains((Object)Integer.MIN_VALUE));
    }

    @Test
    public void testSetArray() {
        ObjectArray array = new ObjectArray(Integer.class);
        Object[] raw = new Integer[]{1, 2, 3, 5, 8, 13, 21};
        array.setArray(raw);
        Assert.assertSame((Object)raw, (Object)array.getArray());
    }

    @Test
    public void testInsert() {
        Object[] raw = new Integer[]{3, 5, 8, 13, 21};
        this.testInsert((PrimitiveArray<?, ?>)new ObjectArray(raw));
    }

    @Test
    public void testDelete() {
        Object[] raw = new Integer[]{3, 5, 8, 13, 21};
        this.testDelete((PrimitiveArray<?, ?>)new ObjectArray(raw));
    }

    @Test
    public void testGet() {
        Integer[] raw = new Integer[]{3, 5, 8, 13, 21};
        ObjectArray array = new ObjectArray((Object[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)raw[i].intValue(), (long)((Integer)array.get(i)).intValue());
        }
    }

    @Test
    public void testSet() {
        Integer[] raw = new Integer[]{3, 5, 8, 13, 21};
        ObjectArray array = new ObjectArray((Object[])raw.clone());
        Integer e0 = 7;
        Integer e2 = 1;
        Integer e4 = 2;
        array.set(0, (Object)e0);
        array.set(2, (Object)e2);
        array.set(4, (Object)e4);
        Assert.assertEquals((long)raw.length, (long)array.size());
        Assert.assertEquals((Object)e0, (Object)array.get(0));
        Assert.assertEquals((Object)raw[1], (Object)array.getValue(1));
        Assert.assertEquals((Object)e2, (Object)array.get(2));
        Assert.assertEquals((Object)raw[3], (Object)array.getValue(3));
        Assert.assertEquals((Object)e4, (Object)array.get(4));
    }

    @Test
    public void testAdd() {
        Integer[] raw = new Integer[]{3, 5, 8, 13, 21};
        ObjectArray array = new ObjectArray((Object[])raw.clone());
        Integer e6 = 1;
        Integer e7 = 2;
        array.add((Object)e6);
        array.add((Object)e7);
        Assert.assertEquals((long)(raw.length + 2), (long)array.size());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (Object)raw[i], (Object)array.getValue(i));
        }
        Assert.assertEquals((Object)e6, (Object)array.get(5));
        Assert.assertEquals((Object)e7, (Object)array.get(6));
    }

    @Test
    public void testIndexOfBoxed() {
        Integer[] raw = new Integer[]{3, 5, 8, 13, 21};
        ObjectArray array = new ObjectArray((Object[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)i, (long)array.indexOf((Object)new Integer(raw[i])));
        }
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)new Integer(-1)));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)new Integer(0)));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)new Integer(1)));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)new Integer(Integer.MAX_VALUE)));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)new Integer(Integer.MIN_VALUE)));
        Assert.assertEquals((long)-1L, (long)array.indexOf(null));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)"Not an int"));
    }

    @Test
    public void testLastIndexOfBoxed() {
        Integer[] raw = new Integer[]{3, 5, 8, 13, 21};
        ObjectArray array = new ObjectArray((Object[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)i, (long)array.lastIndexOf((Object)new Integer(raw[i])));
        }
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)new Integer(-1)));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)new Integer(0)));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)new Integer(1)));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)new Integer(Integer.MAX_VALUE)));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)new Integer(Integer.MIN_VALUE)));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf(null));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)"Not an int"));
    }

    @Test
    public void testContainsBoxed() {
        Integer[] raw = new Integer[]{3, 5, 8, 13, 21};
        ObjectArray array = new ObjectArray((Object[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertTrue((String)("@" + i), (boolean)array.contains((Object)new Integer(raw[i])));
        }
        Assert.assertFalse((boolean)array.contains((Object)new Integer(-1)));
        Assert.assertFalse((boolean)array.contains((Object)new Integer(0)));
        Assert.assertFalse((boolean)array.contains((Object)new Integer(1)));
        Assert.assertFalse((boolean)array.contains((Object)new Integer(Integer.MAX_VALUE)));
        Assert.assertFalse((boolean)array.contains((Object)new Integer(Integer.MIN_VALUE)));
        Assert.assertFalse((boolean)array.contains(null));
        Assert.assertFalse((boolean)array.contains((Object)"Not an int"));
    }

    @Test
    public void testRemove() {
        Integer[] raw = new Integer[]{3, 5, 8, 13, 21};
        ObjectArray array = new ObjectArray((Object[])raw.clone());
        Assert.assertEquals((long)raw.length, (long)array.size());
        array.remove((Object)new Integer(raw[0]));
        Assert.assertEquals((long)(raw.length - 1), (long)array.size());
        array.remove((Object)new Integer(raw[2]));
        Assert.assertEquals((long)(raw.length - 2), (long)array.size());
        array.remove((Object)new Integer(raw[4]));
        Assert.assertEquals((long)(raw.length - 3), (long)array.size());
        Assert.assertEquals((Object)raw[1], (Object)array.getValue(0));
        Assert.assertEquals((Object)raw[3], (Object)array.getValue(1));
    }

    @Test
    public void testContainsAll() {
        Integer[] raw = new Integer[]{3, 5, 8, 13, 21};
        ObjectArray array = new ObjectArray((Object[])raw.clone());
        ArrayList<Integer> list = new ArrayList<Integer>();
        Assert.assertTrue((boolean)array.containsAll(list));
        list.add(13);
        Assert.assertTrue((boolean)array.containsAll(list));
        list.add(1);
        Assert.assertFalse((boolean)array.containsAll(list));
        ObjectArray yes = new ObjectArray((Object[])new Integer[]{3, 8, 21});
        Assert.assertTrue((boolean)array.containsAll((Collection)yes));
        ObjectArray no = new ObjectArray((Object[])new Integer[]{5, 13, 1});
        Assert.assertFalse((boolean)array.containsAll((Collection)no));
    }

    @Test
    public void testAddAll() {
        int i;
        Integer[] raw = new Integer[]{3, 5, 8, 13, 21};
        ObjectArray array = new ObjectArray((Object[])raw.clone());
        Integer[] add = new Integer[]{1, 7};
        ObjectArray toAdd = new ObjectArray((Object[])add.clone());
        int index = 3;
        array.addAll(3, (Collection)toAdd);
        for (i = 0; i < 3; ++i) {
            Assert.assertEquals((Object)raw[i], (Object)array.getValue(i));
        }
        for (i = 3; i < 3 + add.length; ++i) {
            Assert.assertEquals((Object)add[i - 3], (Object)array.getValue(i));
        }
        for (i = 3 + add.length; i < raw.length + add.length; ++i) {
            Assert.assertEquals((Object)raw[i - add.length], (Object)array.getValue(i));
        }
    }

    @Test
    public void testRemoveAll() {
        Integer[] raw = new Integer[]{3, 5, 8, 13, 21};
        ObjectArray array = new ObjectArray((Object[])raw.clone());
        ObjectArray toRemove = new ObjectArray((Object[])new Integer[]{3, 8, 21});
        Assert.assertEquals((long)raw.length, (long)array.size());
        array.removeAll((Collection)toRemove);
        Assert.assertEquals((long)(raw.length - 3), (long)array.size());
        Assert.assertEquals((Object)raw[1], (Object)array.getValue(0));
        Assert.assertEquals((Object)raw[3], (Object)array.getValue(1));
    }
}

