/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.scijava.util.ClassUtils;
import org.scijava.util.ConversionUtils;

public final class NumberUtils {
    private NumberUtils() {
    }

    public static Number toNumber(Object value, Class<?> type) {
        Object num = ConversionUtils.convert(value, type);
        return num == null ? (Number)null : (Number)ConversionUtils.cast(num, Number.class);
    }

    public static BigDecimal asBigDecimal(Number n) {
        if (BigInteger.class.isInstance(n)) {
            return new BigDecimal((BigInteger)n);
        }
        if (Long.class.isInstance(n)) {
            return new BigDecimal(n.longValue());
        }
        return new BigDecimal(n.doubleValue());
    }

    public static BigInteger asBigInteger(Number n) {
        return BigInteger.valueOf(n.longValue());
    }

    public static Number getMinimumNumber(Class<?> type) {
        if (ClassUtils.isByte(type)) {
            return (byte)-128;
        }
        if (ClassUtils.isShort(type)) {
            return (short)Short.MIN_VALUE;
        }
        if (ClassUtils.isInteger(type)) {
            return Integer.MIN_VALUE;
        }
        if (ClassUtils.isLong(type)) {
            return Long.MIN_VALUE;
        }
        if (ClassUtils.isFloat(type)) {
            return Float.valueOf(-3.4028235E38f);
        }
        if (ClassUtils.isDouble(type)) {
            return -1.7976931348623157E308;
        }
        return null;
    }

    public static Number getMaximumNumber(Class<?> type) {
        if (ClassUtils.isByte(type)) {
            return (byte)127;
        }
        if (ClassUtils.isShort(type)) {
            return (short)Short.MAX_VALUE;
        }
        if (ClassUtils.isInteger(type)) {
            return Integer.MAX_VALUE;
        }
        if (ClassUtils.isLong(type)) {
            return Long.MAX_VALUE;
        }
        if (ClassUtils.isFloat(type)) {
            return Float.valueOf(Float.MAX_VALUE);
        }
        if (ClassUtils.isDouble(type)) {
            return Double.MAX_VALUE;
        }
        return null;
    }

    public static Number getDefaultValue(Number min, Number max, Class<?> type) {
        if (min != null) {
            return min;
        }
        if (max != null) {
            return max;
        }
        return NumberUtils.toNumber("0", type);
    }

    public static Number clampToRange(Class<?> type, Number value, Number min, Number max) {
        if (value == null) {
            return NumberUtils.getDefaultValue(min, max, type);
        }
        if (Comparable.class.isAssignableFrom(type)) {
            Comparable cValue = (Comparable)((Object)value);
            if (min != null && cValue.compareTo(min) < 0) {
                return min;
            }
            if (max != null && cValue.compareTo(max) > 0) {
                return max;
            }
        }
        return value;
    }
}

