/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.script;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.scijava.Context;
import org.scijava.Contextual;
import org.scijava.NullContextException;
import org.scijava.log.LogService;
import org.scijava.module.AbstractModuleInfo;
import org.scijava.module.ModuleException;
import org.scijava.module.ModuleItem;
import org.scijava.plugin.Parameter;
import org.scijava.script.ScriptLanguage;
import org.scijava.script.ScriptModule;
import org.scijava.script.ScriptService;
import org.scijava.script.process.ScriptCallback;
import org.scijava.script.process.ScriptProcessorService;
import org.scijava.util.DigestUtils;
import org.scijava.util.FileUtils;

public class ScriptInfo
extends AbstractModuleInfo
implements Contextual {
    private static final int PARAM_CHAR_MAX = 655360;
    private final URL url;
    private final String path;
    private final String script;
    @Parameter
    private Context context;
    @Parameter
    private LogService log;
    @Parameter
    private ScriptService scriptService;
    @Parameter
    private ScriptProcessorService scriptProcessorService;
    private String processedScript;
    private boolean appendReturnValue;
    private ScriptLanguage scriptLanguage;
    private ArrayList<ScriptCallback> callbacks;

    public ScriptInfo(Context context, File file) {
        this(context, null, file.getPath(), null);
    }

    public ScriptInfo(Context context, String path) {
        this(context, null, path, null);
    }

    public ScriptInfo(Context context, URL url, String path) throws IOException {
        this(context, url, path, new InputStreamReader(url.openStream()));
    }

    public ScriptInfo(Context context, String path, Reader reader) {
        this(context, null, path, reader);
    }

    private ScriptInfo(Context context, URL url, String path, Reader reader) {
        this.setContext(context);
        this.url = this.url(url, path);
        this.path = this.path(url, path);
        String contents = null;
        if (reader != null) {
            try {
                contents = ScriptInfo.getReaderContentsAsString(reader);
            }
            catch (IOException exc) {
                this.log.error("Error reading script: " + path, exc);
            }
        }
        this.script = contents;
    }

    public URL getURL() {
        return this.url;
    }

    public String getPath() {
        return this.path;
    }

    public BufferedReader getReader() {
        if (this.script == null) {
            return null;
        }
        return new BufferedReader(new StringReader(this.script), 655360);
    }

    public String getProcessedScript() {
        return this.processedScript;
    }

    public ScriptLanguage getLanguage() {
        if (this.scriptLanguage == null) {
            String scriptPath = this.getPath();
            if (scriptPath != null) {
                String extension = FileUtils.getExtension(scriptPath);
                this.scriptLanguage = this.scriptService.getLanguageByExtension(extension);
            } else {
                List<ScriptLanguage> langs = this.scriptService.getLanguages();
                if (langs != null && !langs.isEmpty()) {
                    this.scriptLanguage = langs.get(0);
                }
            }
        }
        return this.scriptLanguage;
    }

    public void setLanguage(ScriptLanguage scriptLanguage) {
        this.scriptLanguage = scriptLanguage;
    }

    public boolean isReturnValueAppended() {
        return this.appendReturnValue;
    }

    public void setReturnValueAppended(boolean appendReturnValue) {
        this.appendReturnValue = appendReturnValue;
    }

    public List<ScriptCallback> callbacks() {
        if (this.callbacks == null) {
            this.callbacks = new ArrayList();
        }
        return this.callbacks;
    }

    @Override
    public void parseParameters() {
        this.clearParameters();
        try {
            this.processedScript = this.scriptProcessorService.process(this);
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
    }

    @Override
    public void clearParameters() {
        super.clearParameters();
    }

    @Override
    public void registerInput(ModuleItem<?> input) {
        super.registerInput(input);
    }

    @Override
    public void registerOutput(ModuleItem<?> output) {
        super.registerOutput(output);
    }

    @Override
    public String getDelegateClassName() {
        return ScriptModule.class.getName();
    }

    @Override
    public Class<?> loadDelegateClass() {
        return ScriptModule.class;
    }

    @Override
    public ScriptModule createModule() throws ModuleException {
        return new ScriptModule(this);
    }

    @Override
    public Context context() {
        if (this.context == null) {
            throw new NullContextException();
        }
        return this.context;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public void setContext(Context context) {
        context.inject(this);
    }

    @Override
    public String getIdentifier() {
        return "script:" + (this.path == null ? "<inline>" : this.path);
    }

    @Override
    public String getLocation() {
        return new File(this.path).toURI().normalize().toString();
    }

    @Override
    public String getVersion() {
        File file = new File(this.path);
        if (!file.exists()) {
            return null;
        }
        try {
            return DigestUtils.bestHex(FileUtils.readFile(file));
        }
        catch (IOException exc) {
            this.log.error(exc);
            Date lastModified = FileUtils.getModifiedTime(file);
            String datestamp = new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss").format(lastModified);
            return datestamp;
        }
    }

    private URL url(URL u, String p) {
        if (u != null) {
            return u;
        }
        if (p == null) {
            return null;
        }
        try {
            return new File(p).toURI().toURL();
        }
        catch (MalformedURLException exc) {
            this.log.debug("Cannot glean URL from path: " + p, exc);
            return null;
        }
    }

    private String path(URL u, String p) {
        if (p != null) {
            return p;
        }
        return u == null ? null : u.getPath();
    }

    private static String getReaderContentsAsString(Reader reader) throws IOException, NullPointerException {
        int read;
        char[] buffer = new char[8192];
        StringBuilder builder = new StringBuilder();
        while ((read = reader.read(buffer)) != -1) {
            builder.append(buffer, 0, read);
        }
        return builder.toString();
    }

    @Deprecated
    public boolean isReturnValueDeclared() {
        return !this.isReturnValueAppended();
    }
}

