/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io.handle;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.handle.DataHandleService;
import org.scijava.io.location.Location;
import org.scijava.util.Bytes;

public abstract class DataHandleTest {
    protected static final byte[] BYTES = new byte[]{72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0, 0, -128, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 125, 127, -127, -125, -3, -2, -1};

    @Test
    public void testDataHandle() throws IOException {
        Context context = new Context(new Class[]{DataHandleService.class});
        DataHandleService dataHandleService = (DataHandleService)context.service(DataHandleService.class);
        Location loc = this.createLocation();
        try (DataHandle handle = (DataHandle)dataHandleService.create((Object)loc);){
            Assert.assertEquals(this.getExpectedHandleType(), handle.getClass());
            this.checkReads(handle);
            this.checkWrites(handle);
        }
    }

    public abstract Class<? extends DataHandle<?>> getExpectedHandleType();

    public abstract Location createLocation() throws IOException;

    protected void populateData(OutputStream out) throws IOException {
        out.write(BYTES);
        out.close();
    }

    protected <L extends Location> void checkReads(DataHandle<L> handle) throws IOException {
        int i;
        Assert.assertEquals((long)0L, (long)handle.offset());
        Assert.assertEquals((long)BYTES.length, (long)handle.length());
        Assert.assertEquals((Object)"UTF-8", (Object)handle.getEncoding());
        Assert.assertEquals((Object)DataHandle.ByteOrder.BIG_ENDIAN, (Object)handle.getOrder());
        Assert.assertEquals((Object)false, (Object)handle.isLittleEndian());
        for (int i2 = 0; i2 < BYTES.length; ++i2) {
            Assert.assertEquals((String)this.msg(i2), (long)(0xFF & BYTES[i2]), (long)handle.read());
        }
        Assert.assertEquals((long)-1L, (long)handle.read());
        handle.seek(10L);
        Assert.assertEquals((long)10L, (long)handle.offset());
        Assert.assertEquals((long)BYTES[10], (long)handle.read());
        byte[] buf = new byte[10];
        handle.seek(1L);
        this.assertBytesMatch(1, handle.read(buf), buf);
        handle.seek(0L);
        for (i = 0; i < BYTES.length; ++i) {
            Assert.assertEquals((String)this.msg(i), (long)BYTES[i], (long)handle.readByte());
        }
        handle.seek(0L);
        for (i = 0; i < BYTES.length / 2; i += 2) {
            Assert.assertEquals((String)this.msg(i), (long)Bytes.toShort((byte[])BYTES, (int)i, (boolean)false), (long)handle.readShort());
        }
        handle.seek(0L);
        for (i = 0; i < BYTES.length / 4; i += 4) {
            Assert.assertEquals((String)this.msg(i), (long)Bytes.toInt((byte[])BYTES, (int)i, (boolean)false), (long)handle.readInt());
        }
        handle.seek(0L);
        for (i = 0; i < BYTES.length / 8; i += 8) {
            Assert.assertEquals((String)this.msg(i), (long)Bytes.toLong((byte[])BYTES, (int)i, (boolean)false), (long)handle.readLong());
        }
        handle.seek(0L);
        for (i = 0; i < BYTES.length / 4; i += 4) {
            Assert.assertEquals((String)this.msg(i), (float)Bytes.toFloat((byte[])BYTES, (int)i, (boolean)false), (float)handle.readFloat(), (float)0.0f);
        }
        handle.seek(0L);
        for (i = 0; i < BYTES.length / 8; i += 8) {
            Assert.assertEquals((String)this.msg(i), (double)Bytes.toDouble((byte[])BYTES, (int)i, (boolean)false), (double)handle.readDouble(), (double)0.0);
        }
        handle.seek(0L);
        for (i = 0; i < BYTES.length; ++i) {
            Assert.assertEquals((String)this.msg(i), (Object)(BYTES[i] != 0 ? 1 : 0), (Object)handle.readBoolean());
        }
        handle.seek(0L);
        for (i = 0; i < BYTES.length / 2; i += 2) {
            Assert.assertEquals((String)this.msg(i), (long)((char)Bytes.toInt((byte[])BYTES, (int)i, (int)2, (boolean)false)), (long)handle.readChar());
        }
        Arrays.fill(buf, (byte)0);
        handle.seek(3L);
        handle.readFully(buf);
        this.assertBytesMatch(3, buf.length, buf);
        handle.seek(16L);
        this.assertBytesMatch(16, 7, handle.readCString().getBytes());
        handle.seek(7L);
        this.assertBytesMatch(7, 5, handle.readLine().getBytes());
        handle.seek(7L);
        this.assertBytesMatch(7, 5, handle.readString("abcdefg").getBytes());
        handle.seek(1L);
        this.assertBytesMatch(1, 11, handle.findString(new String[]{"world"}).getBytes());
    }

    protected <L extends Location> void checkWrites(DataHandle<L> handle) throws IOException {
        int i;
        byte[] copy = (byte[])BYTES.clone();
        handle.seek(7L);
        String splice = "there";
        for (i = 0; i < "there".length(); ++i) {
            char c = "there".charAt(i);
            handle.write((int)c);
            copy[7 + i] = (byte)c;
        }
        handle.seek(0L);
        for (i = 0; i < copy.length; ++i) {
            Assert.assertEquals((String)this.msg(i), (long)(0xFF & copy[i]), (long)handle.read());
        }
    }

    protected void assertBytesMatch(int offset, int length, byte[] b) {
        Assert.assertEquals((long)length, (long)b.length);
        for (int i = 0; i < length; ++i) {
            Assert.assertEquals((String)this.msg(i), (long)BYTES[i + offset], (long)b[i]);
        }
    }

    protected String msg(int i) {
        return "[" + i + "]:";
    }
}

