/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io.handle;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.handle.DataHandleService;
import org.scijava.io.handle.DataHandleTest;
import org.scijava.io.handle.ReadBufferDataHandle;
import org.scijava.io.location.BytesLocation;
import org.scijava.io.location.Location;

public class ReadBufferDataHandleTest
extends DataHandleTest {
    private Context context;
    private DataHandleService dataHandleService;

    @Override
    @Test
    public void testDataHandle() throws IOException {
        Location loc = this.createLocation();
        try (DataHandle handle = (DataHandle)this.dataHandleService.create((Object)loc);
             ReadBufferDataHandle bufferedHandle = new ReadBufferDataHandle(handle);){
            this.checkReads(bufferedHandle);
        }
    }

    @Test
    public void testSmallBuffer() throws IOException {
        Location loc = this.createLocation();
        try (DataHandle handle = (DataHandle)this.dataHandleService.create((Object)loc);
             ReadBufferDataHandle bufferedHandle = new ReadBufferDataHandle(handle, 5);){
            this.checkReads(bufferedHandle);
        }
    }

    @Test
    public void testLargeRead() throws Exception {
        int size = 1000;
        byte[] bytes = new byte[1000];
        Random r = new Random(42L);
        r.nextBytes(bytes);
        BytesLocation loc = new BytesLocation(bytes);
        try (DataHandle handle = (DataHandle)this.dataHandleService.create((Object)loc);
             ReadBufferDataHandle bufferedHandle = new ReadBufferDataHandle(handle, 12, 3);){
            byte[] actual = new byte[1000];
            int slices = 60;
            int range = (1000 + slices - 1) / slices;
            ArrayList<AbstractMap.SimpleEntry<Integer, Integer>> ranges = new ArrayList<AbstractMap.SimpleEntry<Integer, Integer>>();
            for (int i = 0; i < slices; ++i) {
                int n = range * i;
                int end = range * (i + 1);
                ranges.add(new AbstractMap.SimpleEntry<Integer, Integer>(n, end));
            }
            Collections.shuffle(ranges, r);
            for (AbstractMap.SimpleEntry simpleEntry : ranges) {
                bufferedHandle.seek((long)((Integer)simpleEntry.getKey()).intValue());
                bufferedHandle.read(actual, ((Integer)simpleEntry.getKey()).intValue(), (Integer)simpleEntry.getValue() - (Integer)simpleEntry.getKey());
            }
            Assert.assertArrayEquals((byte[])bytes, (byte[])actual);
        }
    }

    @Before
    public void setup() {
        this.context = new Context(new Class[]{DataHandleService.class});
        this.dataHandleService = (DataHandleService)this.context.service(DataHandleService.class);
    }

    @Override
    public Class<? extends DataHandle<?>> getExpectedHandleType() {
        return null;
    }

    @Override
    public Location createLocation() throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            this.populateData(out);
            BytesLocation bytesLocation = new BytesLocation(out.toByteArray());
            return bytesLocation;
        }
    }
}

