/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.util.List;

public final class ListUtils {
    private ListUtils() {
    }

    public static <T> T first(List<T> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public static String string(List<?> list) {
        return ListUtils.string(list, true);
    }

    public static String string(List<?> list, boolean encloseSingletons) {
        return ListUtils.string(list, "[", "]", ", ", encloseSingletons);
    }

    public static String string(List<?> list, String lDelimiter, String rDelimiter, String separator, boolean encloseSingletons) {
        boolean delimit = encloseSingletons || list.size() != 1;
        StringBuilder sb = new StringBuilder();
        if (delimit) {
            sb.append(lDelimiter);
        }
        boolean first = true;
        for (Object e : list) {
            if (first) {
                first = false;
            } else {
                sb.append(separator);
            }
            sb.append(e);
        }
        if (delimit) {
            sb.append(rDelimiter);
        }
        return sb.toString();
    }
}

