/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.command;

import java.lang.reflect.Field;
import org.scijava.Cancelable;
import org.scijava.Context;
import org.scijava.Contextual;
import org.scijava.NullContextException;
import org.scijava.command.Command;
import org.scijava.command.CommandInfo;
import org.scijava.command.CommandService;
import org.scijava.command.DynamicCommandInfo;
import org.scijava.module.DefaultMutableModule;
import org.scijava.module.ModuleService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.PluginService;
import org.scijava.util.ClassUtils;

public abstract class DynamicCommand
extends DefaultMutableModule
implements Cancelable,
Command,
Contextual {
    @Parameter
    private Context context;
    @Parameter
    private CommandService commandService;
    @Parameter
    private PluginService pluginService;
    @Parameter
    protected ModuleService moduleService;
    private DynamicCommandInfo info;
    private String cancelReason;

    @Override
    public DynamicCommandInfo getInfo() {
        if (this.info == null) {
            CommandInfo commandInfo = this.commandService.getCommand(this.getClass());
            this.info = new DynamicCommandInfo(commandInfo, this.getClass());
        }
        return this.info;
    }

    @Override
    public Object getInput(String name) {
        Field field = this.getInfo().getInputField(name);
        if (field == null) {
            return super.getInput(name);
        }
        return ClassUtils.getValue(field, this);
    }

    @Override
    public Object getOutput(String name) {
        Field field = this.getInfo().getOutputField(name);
        if (field == null) {
            return super.getInput(name);
        }
        return ClassUtils.getValue(field, this);
    }

    @Override
    public void setInput(String name, Object value) {
        Field field = this.getInfo().getInputField(name);
        if (field == null) {
            super.setInput(name, value);
        } else {
            ClassUtils.setValue(field, this, value);
        }
    }

    @Override
    public void setOutput(String name, Object value) {
        Field field = this.getInfo().getOutputField(name);
        if (field == null) {
            super.setOutput(name, value);
        } else {
            ClassUtils.setValue(field, this, value);
        }
    }

    @Override
    public Context context() {
        if (this.context == null) {
            throw new NullContextException();
        }
        return this.context;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public void setContext(Context context) {
        context.inject(this);
    }

    @Override
    public boolean isCanceled() {
        return this.cancelReason != null;
    }

    @Override
    public void cancel(String reason) {
        this.cancelReason = reason == null ? "" : reason;
    }

    @Override
    public String getCancelReason() {
        return this.cancelReason;
    }

    public void uncancel() {
        this.cancelReason = null;
    }

    protected void saveInputs() {
        this.moduleService.saveInputs(this);
    }
}

