/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.script.process;

import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.script.ScriptInfo;
import org.scijava.script.ScriptLanguage;
import org.scijava.script.ScriptService;
import org.scijava.script.process.ScriptProcessor;

@Plugin(type=ScriptProcessor.class)
public class ShebangScriptProcessor
implements ScriptProcessor {
    @Parameter
    private ScriptService scriptService;
    @Parameter
    private LogService log;
    private ScriptInfo info;
    private boolean first = true;

    @Override
    public void begin(ScriptInfo scriptInfo) {
        this.info = scriptInfo;
    }

    @Override
    public String process(String line) {
        if (!this.first) {
            return line;
        }
        this.first = false;
        if (line.startsWith("#!")) {
            String langName = line.substring(2);
            ScriptLanguage lang = this.scriptService.getLanguageByName(langName);
            if (lang != null) {
                this.info.setLanguage(lang);
            } else {
                this.log.warn("Unknown script language: " + langName);
            }
            return "";
        }
        return line;
    }
}

