/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.log;

import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.log.LogSource;

public class LogSourceTest {
    @Test
    public void testRoot() {
        LogSource root = LogSource.newRoot();
        Assert.assertEquals(Collections.emptyList(), (Object)root.path());
        Assert.assertTrue((boolean)root.isRoot());
    }

    @Test
    public void testIsRoot() {
        LogSource source = LogSource.newRoot().subSource("sub");
        Assert.assertFalse((boolean)source.isRoot());
    }

    @Test
    public void testChildIsUnique() {
        String name = "foo";
        LogSource root = LogSource.newRoot();
        LogSource a = root.subSource(name);
        LogSource b = root.subSource(name);
        Assert.assertSame((Object)a, (Object)b);
    }

    @Test
    public void testLogSourceParse() {
        LogSource foo = LogSource.newRoot().subSource("foo");
        LogSource result = foo.subSource("Hello:World");
        LogSource expected = foo.subSource("Hello").subSource("World");
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testToString() {
        LogSource source = LogSource.newRoot().subSource("Hello").subSource("World");
        String result = source.toString();
        Assert.assertEquals((Object)"Hello:World", (Object)result);
    }

    @Test
    public void testRootToString() {
        LogSource source = LogSource.newRoot();
        String result = source.toString();
        Assert.assertEquals((Object)"", (Object)result);
    }

    @Test
    public void testName() {
        LogSource source = LogSource.newRoot().subSource("Hello").subSource("World");
        Assert.assertEquals((Object)"World", (Object)source.name());
    }

    @Test
    public void testParent() {
        LogSource root = LogSource.newRoot();
        LogSource source = root.subSource("sub");
        Assert.assertSame((Object)root, (Object)source.parent());
    }

    @Test
    public void testUnsetLogLevel() {
        LogSource source = LogSource.newRoot();
        Assert.assertFalse((boolean)source.hasLogLevel());
    }

    @Test
    public void testSetLogLevel() {
        LogSource source = LogSource.newRoot();
        source.setLogLevel(3);
        Assert.assertTrue((boolean)source.hasLogLevel());
        Assert.assertEquals((long)3L, (long)source.logLevel());
    }
}

