/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.viewer;

import org.scijava.Disposable;
import org.scijava.display.Display;
import org.scijava.display.event.DisplayActivatedEvent;
import org.scijava.display.event.DisplayDeletedEvent;
import org.scijava.display.event.DisplayUpdatedEvent;
import org.scijava.plugin.RichPlugin;
import org.scijava.ui.UserInterface;
import org.scijava.ui.viewer.DisplayPanel;
import org.scijava.ui.viewer.DisplayWindow;

public interface DisplayViewer<T>
extends RichPlugin,
Disposable {
    public boolean isCompatible(UserInterface var1);

    public boolean canView(Display<?> var1);

    default public void view(UserInterface ui, Display<?> d) {
        DisplayWindow w = ui.createDisplayWindow(d);
        w.setTitle(d.getName());
        this.view(w, d);
        w.showDisplay(true);
        d.update();
    }

    public void view(DisplayWindow var1, Display<?> var2);

    public Display<T> getDisplay();

    public DisplayWindow getWindow();

    public void setPanel(DisplayPanel var1);

    public DisplayPanel getPanel();

    default public void onDisplayUpdatedEvent(DisplayUpdatedEvent e) {
        if (this.getPanel() == null) {
            return;
        }
        if (e.getLevel() == DisplayUpdatedEvent.DisplayUpdateLevel.REBUILD) {
            this.getPanel().redoLayout();
        }
        this.getPanel().redraw();
    }

    default public void onDisplayDeletedEvent(DisplayDeletedEvent e) {
        if (this.getPanel() == null || this.getPanel().getWindow() == null) {
            return;
        }
        this.getPanel().getWindow().close();
    }

    default public void onDisplayActivatedEvent(DisplayActivatedEvent e) {
        if (this.getPanel() == null || this.getPanel().getWindow() == null) {
            return;
        }
        this.getPanel().getWindow().requestFocus();
    }

    @Override
    default public void dispose() {
        DisplayWindow w = this.getWindow();
        if (w != null) {
            w.close();
        }
    }
}

