/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.convert;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.scijava.convert.AbstractConverter;
import org.scijava.convert.Converter;
import org.scijava.plugin.Plugin;
import org.scijava.util.ArrayUtils;
import org.scijava.util.ConversionUtils;
import org.scijava.util.Types;

@Plugin(type=Converter.class, priority=-1000000.0)
public class DefaultConverter
extends AbstractConverter<Object, Object> {
    @Override
    public Object convert(Object src, Type dest) {
        Type componentType = Types.component(dest);
        if (componentType != null) {
            return this.convertToArray(src, Types.raw(componentType));
        }
        if (dest instanceof ParameterizedType && this.isCollection(dest)) {
            return this.convertToCollection(src, (ParameterizedType)dest);
        }
        return this.convert(src, Types.raw(dest));
    }

    @Override
    public <T> T convert(Object src, Class<T> dest) {
        String result;
        Class<T> saneDest = Types.box(dest);
        if (this.isArray(dest)) {
            Object array = this.convertToArray(src, Types.raw(Types.component(dest)));
            return (T)array;
        }
        if (src instanceof Number) {
            Number number = (Number)src;
            if (saneDest == Byte.class) {
                Byte result2;
                Byte typedResult = result2 = Byte.valueOf(number.byteValue());
                return (T)typedResult;
            }
            if (saneDest == Double.class) {
                Double result3;
                Double typedResult = result3 = Double.valueOf(number.doubleValue());
                return (T)typedResult;
            }
            if (saneDest == Float.class) {
                Float result4;
                Float typedResult = result4 = Float.valueOf(number.floatValue());
                return (T)typedResult;
            }
            if (saneDest == Integer.class) {
                Integer result5;
                Integer typedResult = result5 = Integer.valueOf(number.intValue());
                return (T)typedResult;
            }
            if (saneDest == Long.class) {
                Long result6;
                Long typedResult = result6 = Long.valueOf(number.longValue());
                return (T)typedResult;
            }
            if (saneDest == Short.class) {
                Short result7;
                Short typedResult = result7 = Short.valueOf(number.shortValue());
                return (T)typedResult;
            }
        }
        if (src instanceof String) {
            String s = (String)src;
            if (s.isEmpty()) {
                return Types.nullValue(dest);
            }
            if (saneDest == Character.class) {
                Character c;
                Character result8 = c = new Character(s.charAt(0));
                return (T)result8;
            }
            if (dest.isEnum() && (result = ConversionUtils.convertToEnum(s, dest)) != null) {
                return (T)result;
            }
        }
        if (saneDest == String.class) {
            String sValue;
            result = sValue = src.toString();
            return (T)result;
        }
        try {
            Constructor<?> ctor = this.getConstructor(saneDest, src.getClass());
            if (ctor == null) {
                return null;
            }
            Object instance = ctor.newInstance(src);
            return (T)instance;
        }
        catch (Exception exc) {
            return Types.nullValue(dest);
        }
    }

    @Override
    public Class<Object> getOutputType() {
        return Object.class;
    }

    @Override
    public Class<Object> getInputType() {
        return Object.class;
    }

    private Constructor<?> getConstructor(Class<?> type, Class<?> argType) {
        for (Constructor<?> ctor : type.getConstructors()) {
            Class<?>[] params = ctor.getParameterTypes();
            if (params.length != 1 || !Types.isAssignable(Types.box(argType), Types.box(params[0]))) continue;
            return ctor;
        }
        return null;
    }

    private boolean isArray(Type type) {
        return Types.component(type) != null;
    }

    private boolean isCollection(Type type) {
        return Types.isAssignable(Types.raw(type), Collection.class);
    }

    private Object convertToArray(Object value, Class<?> componentType) {
        Collection<?> items = ArrayUtils.toCollection(value);
        Object array = Array.newInstance(componentType, items.size());
        int index = 0;
        for (Object item : items) {
            Array.set(array, index++, this.convert(item, componentType));
        }
        return array;
    }

    private Object convertToCollection(Object value, ParameterizedType pType) {
        Collection<Object> collection = this.createCollection(Types.raw(pType));
        if (collection == null) {
            return null;
        }
        Collection<?> items = ArrayUtils.toCollection(value);
        Type collectionType = pType.getActualTypeArguments()[0];
        for (Object item : items) {
            collection.add(this.convert(item, collectionType));
        }
        return collection;
    }

    private Collection<Object> createCollection(Class<?> type) {
        if (type.isInterface() || Modifier.isAbstract(type.getModifiers())) {
            if (Types.isAssignable(type, List.class)) {
                return new ArrayList<Object>();
            }
            if (Types.isAssignable(type, Set.class)) {
                return new HashSet<Object>();
            }
            return null;
        }
        try {
            Collection c = (Collection)type.newInstance();
            return c;
        }
        catch (InstantiationException exc) {
            return null;
        }
        catch (IllegalAccessException exc) {
            return null;
        }
    }

    @Override
    @Deprecated
    public boolean canConvert(Class<?> src, Type dest) {
        if (this.isArray(dest)) {
            if (Collection.class.isAssignableFrom(src)) {
                return true;
            }
            if (src.isArray()) {
                return true;
            }
            return Types.isAssignable(src, Types.component(dest));
        }
        if (dest instanceof ParameterizedType && this.isCollection(dest) && this.createCollection(Types.raw(dest)) != null) {
            return true;
        }
        return super.canConvert(src, dest);
    }

    @Override
    @Deprecated
    public boolean canConvert(Class<?> src, Class<?> dest) {
        Class<?> saneDest = Types.box(dest);
        if (Types.isAssignable(Types.box(src), Number.class) && (Types.isByte(dest) || Types.isDouble(dest) || Types.isFloat(dest) || Types.isInteger(dest) || Types.isLong(dest) || Types.isShort(dest))) {
            return true;
        }
        if (saneDest == String.class) {
            return true;
        }
        if (Types.isAssignable(src, String.class)) {
            if (saneDest == Character.class) {
                return true;
            }
            if (dest.isEnum()) {
                return true;
            }
        }
        try {
            return this.getConstructor(saneDest, src) != null;
        }
        catch (Exception exc) {
            return false;
        }
    }
}

