/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.script.process;

import java.io.Reader;
import java.io.StringReader;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.script.ScriptInfo;

public class ParameterScriptProcessorTest {
    private Context context;

    @Before
    public void setUp() {
        this.context = new Context();
    }

    @After
    public void tearDown() {
        this.context.dispose();
    }

    @Test
    public void testScriptParameterParsing() {
        String script = "% @String legacyStyleParameter\n% #@ String commentedHeaderParameter\n% ############## Some Comment ###########\n#@ String implicitInputParameter\n#@input String explicitInputParameter\n\n% @String legacyStyleBodyParameter\n% #@ String commentedBodyParameter\n\n#@output implicitlyTypedOutputParameter\n#@output String explicitlyTypedOutputParameter\n";
        ScriptInfo info = new ScriptInfo(this.context, ".bsizes", (Reader)new StringReader(script));
        Assert.assertEquals((Object)"legacyStyleParameter", (Object)info.getInput("legacyStyleParameter").getName());
        Assert.assertEquals((Object)"implicitInputParameter", (Object)info.getInput("implicitInputParameter").getName());
        Assert.assertEquals((Object)"explicitInputParameter", (Object)info.getInput("explicitInputParameter").getName());
        Assert.assertEquals((Object)"implicitlyTypedOutputParameter", (Object)info.getOutput("implicitlyTypedOutputParameter").getName());
        Assert.assertEquals((Object)"explicitlyTypedOutputParameter", (Object)info.getOutput("explicitlyTypedOutputParameter").getName());
        Assert.assertNull((Object)info.getInput("commentedHeaderParameter"));
        Assert.assertNull((Object)info.getInput("legacyStyleBodyParameter"));
        Assert.assertNull((Object)info.getInput("commentedBodyParameter"));
    }
}

