/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.main.run;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.main.run.MainCodeRunner;

public class MainCodeRunnerTest {
    private MainCodeRunner runner;

    @Before
    public void setUp() {
        this.runner = new MainCodeRunner();
    }

    @Test
    public void testRunList() throws InvocationTargetException {
        this.runner.run(Counter.class, new Object[0]);
        Assert.assertEquals((long)Counter.counter, (long)0L);
        this.runner.run(Counter.class, new Object[]{"a"});
        Assert.assertEquals((long)Counter.counter, (long)1L);
        this.runner.run(Counter.class, new Object[]{"b", "c"});
        Assert.assertEquals((long)Counter.counter, (long)3L);
        this.runner.run(Counter.class, new Object[]{"d", "e", "f"});
        Assert.assertEquals((long)Counter.counter, (long)6L);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRunMap() throws InvocationTargetException {
        this.runner.run(Counter.class, new HashMap());
    }

    @Test
    public void testSupports() {
        Assert.assertTrue((boolean)this.runner.supports(Counter.class));
        Assert.assertTrue((boolean)this.runner.supports((Object)Counter.class.getName()));
        Assert.assertFalse((boolean)this.runner.supports(this.getClass()));
        Assert.assertFalse((boolean)this.runner.supports((Object)"Not an actual class"));
        Assert.assertFalse((boolean)this.runner.supports((Object)0));
    }

    public static class Counter {
        public static int counter;

        public static void main(String[] args) {
            counter += args.length;
        }
    }
}

