/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.script;

import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.scijava.Context;
import org.scijava.log.LogService;
import org.scijava.module.Module;
import org.scijava.script.ScriptLanguage;
import org.scijava.script.ScriptModule;
import org.scijava.script.ScriptService;

public class ScriptCLI {
    private static final String USAGE = "Usage: " + ScriptCLI.class.getSimpleName() + " [-d] [-h] [-l language] [-o] [-r] /path/to/script [script-args]\n\nOptions:\n  -d, --debug              : enable debug-level log output\n  -h, --help               : display this help message\n  -l, --language           : specify language of script to execute\n                             otherwise, inferred from script extension\n  -o, --print-outputs      : print output values\n  -r, --print-return-value : print return value\n\nTo read from stdin, use a dash (-) symbol for the script path.\n\nFor script-args, give space-separated key=value pairs,\nwhile will be passed in as SciJava script arguments.";

    public static void main(String ... args) throws Exception {
        HashMap<String, Object> inputs = new HashMap<String, Object>();
        File file = null;
        String language = null;
        boolean printOutputs = false;
        boolean printReturnValue = false;
        boolean parsingOptions = true;
        try (Context context = new Context();){
            Module m;
            if (args.length == 0) {
                args = new String[]{"-h"};
            }
            for (int i = 0; i < args.length; ++i) {
                if (parsingOptions) {
                    if (args[i].equals("-d") || args[i].equals("--debug")) {
                        LogService log = context.getService(LogService.class);
                        if (log == null) continue;
                        log.setLevel(4);
                        continue;
                    }
                    if (args[i].equals("-h") || args[i].equals("--help")) {
                        System.err.println(USAGE);
                        System.exit(1);
                        continue;
                    }
                    if (i < args.length - 1 && args[i].equals("-l") || args[i].equals("--language")) {
                        language = args[++i];
                        continue;
                    }
                    if (args[i].equals("-o") || args[i].equals("--print-outputs")) {
                        printOutputs = true;
                        continue;
                    }
                    if (args[i].equals("-r") || args[i].equals("--print-return-value")) {
                        printReturnValue = true;
                        continue;
                    }
                    if (args[i].equals("-")) {
                        parsingOptions = false;
                        continue;
                    }
                    if (i < args.length - 1 && args[i].equals("--")) {
                        file = new File(args[++i]);
                        parsingOptions = false;
                        continue;
                    }
                    if (new File(args[i]).exists()) {
                        file = new File(args[i]);
                        parsingOptions = false;
                        continue;
                    }
                    System.err.println("Invalid argument: " + args[i]);
                    System.exit(2);
                    continue;
                }
                int equals = args[i].indexOf("=");
                if (equals < 0) {
                    System.err.println("Invalid argument: " + args[i]);
                    System.exit(3);
                }
                String key = args[i].substring(0, equals);
                String val = args[i].substring(equals + 1);
                inputs.put(key, val);
            }
            ScriptService ss = context.getService(ScriptService.class);
            if (ss == null) {
                System.err.println("Error: No script service available.");
                System.exit(4);
            }
            if (file == null && language == null) {
                System.err.println("Error: Must specify language when using stdin.");
                System.exit(5);
            }
            if (language == null) {
                m = ss.run(file, true, inputs).get();
            } else {
                ScriptLanguage lang = ss.getLanguageByName(language);
                if (lang == null) {
                    lang = ss.getLanguageByExtension(language);
                }
                if (lang == null) {
                    System.err.println("Error: Unsupported language: " + language);
                    System.exit(6);
                }
                InputStreamReader reader = file == null ? new InputStreamReader(System.in) : new FileReader(file);
                m = ss.run("." + language, (Reader)reader, true, inputs).get();
            }
            if (printOutputs) {
                for (Map.Entry<String, Object> output : m.getOutputs().entrySet()) {
                    System.out.println(output.getKey() + " = " + output.getValue());
                }
            }
            if (printReturnValue && m instanceof ScriptModule) {
                System.out.println(((ScriptModule)m).getReturnValue());
            }
        }
        System.exit(0);
    }
}

