/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.common3;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.common3.Types;

public class CommonSuperTypeTest {
    @Test
    public void testDouble() {
        Class<Double> t1 = Double.class;
        Class<Double> t2 = Double.class;
        Type superType = Types.commonSuperTypeOf((Type[])new Type[]{t1, t2});
        Assertions.assertEquals(Double.class, (Object)superType);
    }

    @Test
    public void testNumber() {
        Class<Double> t1 = Double.class;
        Class<Long> t2 = Long.class;
        Type superType = Types.commonSuperTypeOf((Type[])new Type[]{t1, t2});
        Assertions.assertEquals(Number.class, (Object)superType);
    }

    @Test
    public void testObject() {
        Class<Double> t1 = Double.class;
        Class<String> t2 = String.class;
        Type superType = Types.commonSuperTypeOf((Type[])new Type[]{t1, t2});
        ParameterizedType expected = Types.parameterize(Comparable.class, (Type[])new Type[]{Types.wildcard((Type[])new Type[0])});
        Assertions.assertEquals((Object)expected, (Object)superType);
    }

    @Test
    public void testListOfSame() {
        ParameterizedType listOfDouble = Types.parameterize(List.class, (Type[])new Type[]{Double.class});
        Type superType = Types.commonSuperTypeOf((Type[])new Type[]{listOfDouble, listOfDouble});
        Assertions.assertEquals((Object)listOfDouble, (Object)superType);
        ParameterizedType listOfObject = Types.parameterize(List.class, (Type[])new Type[]{Object.class});
        Assertions.assertNotEquals((Object)listOfObject, (Object)superType, (String)"Class Double should take precedence over Object");
        ParameterizedType listOfQ = Types.parameterize(List.class, (Type[])new Type[]{Types.wildcard((Type[])new Type[0])});
        Assertions.assertNotEquals((Object)listOfQ, (Object)superType, (String)"Class Double should be discernable over wildcard");
        Assertions.assertNotEquals(List.class, (Object)superType, (String)"Class Double should be discernable, rawtype should not be returned");
    }

    @Test
    public void testListOfDifferent() {
        ParameterizedType t1 = Types.parameterize(List.class, (Type[])new Type[]{Double.class});
        ParameterizedType t2 = Types.parameterize(List.class, (Type[])new Type[]{String.class});
        Type superType = Types.commonSuperTypeOf((Type[])new Type[]{t1, t2});
        ParameterizedType comparableQ = Types.parameterize(Comparable.class, (Type[])new Type[]{Types.wildcard((Type[])new Type[0])});
        WildcardType expectedListType = Types.wildcard((Type[])new Type[]{comparableQ});
        ParameterizedType expected = Types.parameterize(List.class, (Type[])new Type[]{expectedListType});
        Assertions.assertEquals((Object)expected, (Object)superType);
    }

    @Test
    public void testListOfListOfDifferent() {
        ParameterizedType listDouble = Types.parameterize(List.class, (Type[])new Type[]{Double.class});
        ParameterizedType listString = Types.parameterize(List.class, (Type[])new Type[]{String.class});
        ParameterizedType t1 = Types.parameterize(List.class, (Type[])new Type[]{listDouble});
        ParameterizedType t2 = Types.parameterize(List.class, (Type[])new Type[]{listString});
        Type superType = Types.commonSuperTypeOf((Type[])new Type[]{t1, t2});
        ParameterizedType comparableQ = Types.parameterize(Comparable.class, (Type[])new Type[]{Types.wildcard((Type[])new Type[0])});
        WildcardType expectedType = Types.wildcard((Type[])new Type[]{comparableQ});
        ParameterizedType expectedList = Types.parameterize(List.class, (Type[])new Type[]{expectedType});
        WildcardType expectedListType = Types.wildcard((Type[])new Type[]{expectedList});
        ParameterizedType expected = Types.parameterize(List.class, (Type[])new Type[]{expectedListType});
        Assertions.assertEquals((Object)expected, (Object)superType);
    }

    @Test
    public void testArrayListAndList() {
        ParameterizedType t1 = Types.parameterize(List.class, (Type[])new Type[]{Double.class});
        ParameterizedType t2 = Types.parameterize(ArrayList.class, (Type[])new Type[]{Double.class});
        Type superType = Types.commonSuperTypeOf((Type[])new Type[]{t1, t2});
        Assertions.assertEquals((Object)t1, (Object)superType);
        Type superType2 = Types.commonSuperTypeOf((Type[])new Type[]{t2, t1});
        Assertions.assertEquals((Object)t1, (Object)superType2);
    }

    @Test
    public void testNThingQThing() {
        Class<NThing> t3 = NThing.class;
        Class<QThing> t4 = QThing.class;
        Type superType = Types.commonSuperTypeOf((Type[])new Type[]{t3, t4});
        WildcardType expected = Types.wildcard((Type[])new Type[]{Thing.class, Stuff.class});
        Assertions.assertEquals((Object)expected, (Object)superType);
    }

    @Test
    public void testNThingYThing() {
        Class<NThing> t3 = NThing.class;
        Class<YThing> t4 = YThing.class;
        Type superType = Types.commonSuperTypeOf((Type[])new Type[]{t3, t4});
        WildcardType expected = Types.wildcard((Type[])new Type[]{Thing.class});
        Assertions.assertNotEquals((Object)expected, (Object)superType, (String)"Greatest common type should not be a wildcard");
        Assertions.assertEquals(Thing.class, (Object)superType);
    }

    @Test
    public void testNThingXThing() {
        Class<NThing> t3 = NThing.class;
        Class<XThing> t4 = XThing.class;
        Type superType = Types.commonSuperTypeOf((Type[])new Type[]{t3, t4});
        Assertions.assertEquals(Base.class, (Object)superType);
        Assertions.assertNotEquals(Thing.class, (Object)superType, (String)"Non-Object classes should take precedence over interfaces");
    }

    @Test
    public void testRecursiveClass() {
        Class<StrangeThing> t1 = StrangeThing.class;
        Class<WeirdThing> t2 = WeirdThing.class;
        Type superType = Types.commonSuperTypeOf((Type[])new Type[]{t1, t2});
        ParameterizedType expected = Types.parameterize(RecursiveThing.class, (Type[])new Type[]{Types.wildcard((Type[])new Type[0])});
        Assertions.assertEquals((Object)expected, (Object)superType);
    }

    @Test
    public void testTypeVar() {
        class C<T extends Base> {
            C() {
            }
        }
        TypeVariable t1 = C.class.getTypeParameters()[0];
        Class<NThing> t2 = NThing.class;
        Type superType = Types.commonSuperTypeOf((Type[])new Type[]{t1, t2});
        Assertions.assertEquals(Base.class, (Object)superType);
    }

    @Test
    public void testWildcardType() {
        WildcardType qNThing = Types.wildcard((Type[])new Type[]{NThing.class});
        ParameterizedType typeWithWildcard = Types.parameterize(List.class, (Type[])new Type[]{qNThing});
        Type t1 = typeWithWildcard.getActualTypeArguments()[0];
        Class<XThing> t2 = XThing.class;
        Type superType = Types.commonSuperTypeOf((Type[])new Type[]{t1, t2});
        Assertions.assertEquals(Base.class, (Object)superType);
    }

    static class WeirdThing
    extends RecursiveThing<WeirdThing> {
        WeirdThing() {
        }
    }

    static class StrangeThing
    extends RecursiveThing<StrangeThing> {
        StrangeThing() {
        }
    }

    static abstract class RecursiveThing<T extends RecursiveThing<T>> {
        RecursiveThing() {
        }
    }

    static class YThing
    implements Thing {
        YThing() {
        }
    }

    static class QThing
    extends YThing
    implements Stuff {
        QThing() {
        }
    }

    static class NThing
    extends Base
    implements Thing,
    Stuff {
        NThing() {
        }
    }

    static class Base {
        Base() {
        }
    }

    static class XThing
    extends Base
    implements Thing {
        XThing() {
        }
    }

    static interface Stuff {
    }

    static interface Thing {
    }
}

