/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.common3;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.common3.Classes;
import org.scijava.common3.Types;
import org.scijava.testutil.ExampleTypes;

public class TypesTest {
    @Test
    public void testName() {
        Assertions.assertEquals((Object)"boolean", (Object)Types.name(Boolean.TYPE));
        Assertions.assertEquals((Object)"java.lang.String", (Object)Types.name(String.class));
        class Struct {
            private List<String> list;

            Struct() {
            }
        }
        Assertions.assertEquals((Object)"java.util.List<java.lang.String>", (Object)Types.name((Type)this.type(Struct.class, "list")));
    }

    @Test
    public void testRaw() {
        class Struct {
            private int[] intArray;
            private double d;
            private String[][] strings;
            private Void v;
            private List<String> list;
            private HashMap<Integer, Float> map;

            Struct() {
            }
        }
        Assertions.assertSame(int[].class, this.raw(Struct.class, "intArray"));
        Assertions.assertSame(Double.TYPE, this.raw(Struct.class, "d"));
        Assertions.assertSame(String[][].class, this.raw(Struct.class, "strings"));
        Assertions.assertSame(Void.class, this.raw(Struct.class, "v"));
        Assertions.assertSame(List.class, this.raw(Struct.class, "list"));
        Assertions.assertSame(HashMap.class, this.raw(Struct.class, "map"));
    }

    @Test
    public void testRaws() {
        Field field = Classes.field(ExampleTypes.Thing.class, (String)"thing");
        this.assertAllTheSame(Types.raws((Type)Types.typeOf((Field)field, ExampleTypes.Thing.class)), Object.class);
        this.assertAllTheSame(Types.raws((Type)Types.typeOf((Field)field, ExampleTypes.NumberThing.class)), Number.class);
        this.assertAllTheSame(Types.raws((Type)Types.typeOf((Field)field, ExampleTypes.IntegerThing.class)), Integer.class);
        this.assertAllTheSame(Types.raws((Type)Types.typeOf((Field)field, ExampleTypes.ComplexThing.class)), Serializable.class, Cloneable.class);
    }

    @Test
    public void testComponent() {
        class Struct {
            private int[] intArray;
            private double d;
            private String[][] strings;
            private Void v;
            private List<String>[] list;
            private HashMap<Integer, Float> map;

            Struct() {
            }
        }
        Assertions.assertSame(Integer.TYPE, this.componentType(Struct.class, "intArray"));
        Assertions.assertNull(this.componentType(Struct.class, "d"));
        Assertions.assertSame(String[].class, this.componentType(Struct.class, "strings"));
        Assertions.assertSame(null, this.componentType(Struct.class, "v"));
        Assertions.assertSame(List.class, this.componentType(Struct.class, "list"));
        Assertions.assertSame(null, this.componentType(Struct.class, "map"));
    }

    @Test
    public void testTypeOf() {
        Field field = Classes.field(ExampleTypes.Thing.class, (String)"thing");
        Type tType = Types.typeOf((Field)field, ExampleTypes.Thing.class);
        Assertions.assertEquals((Object)"T", (Object)tType.toString());
        Type nType = Types.typeOf((Field)field, ExampleTypes.NumberThing.class);
        Assertions.assertEquals((Object)"N", (Object)nType.toString());
        Type iType = Types.typeOf((Field)field, ExampleTypes.IntegerThing.class);
        Assertions.assertSame(Integer.class, (Object)iType);
    }

    @Test
    public void testTypeParams() {
        Type[] argTypesRaw = Types.typeParamsOf(ExampleTypes.IntegerThing.class, ExampleTypes.Thing.class);
        Assertions.assertEquals((int)1, (int)argTypesRaw.length);
        Assertions.assertSame(Integer.class, (Object)argTypesRaw[0]);
        class C<U extends ExampleTypes.IntegerThing> {
            C() {
            }
        }
        TypeVariable arg = C.class.getTypeParameters()[0];
        Assertions.assertEquals((Object)"U", (Object)arg.getTypeName());
        Type[] argTypes = Types.typeParamsOf(arg, ExampleTypes.Thing.class);
        Assertions.assertNotNull((Object)argTypes);
        Assertions.assertEquals((int)1, (int)argTypes.length);
        Assertions.assertSame(Integer.class, (Object)argTypes[0]);
    }

    @Test
    public void testIsAssignable() {
        Assertions.assertTrue((boolean)Types.isAssignable(String.class, Object.class));
        Assertions.assertTrue((boolean)Types.isAssignable(ArrayList.class, Collection.class));
        Assertions.assertFalse((boolean)Types.isAssignable(Double.TYPE, Float.TYPE));
        Assertions.assertFalse((boolean)Types.isAssignable(Float.TYPE, Double.TYPE));
        Assertions.assertTrue((boolean)Types.isAssignable(Integer.TYPE, Number.class));
        Assertions.assertTrue((boolean)Types.isAssignable(null, Object.class));
        Assertions.assertTrue((boolean)Types.isAssignable(null, int[].class));
    }

    @Test
    public void testIsAssignableNullToNull() {
        Assertions.assertThrows(NullPointerException.class, () -> Types.isAssignable(null, null));
    }

    @Test
    public void testIsAssignableClassToNull() {
        Assertions.assertThrows(NullPointerException.class, () -> Types.isAssignable(Object.class, null));
    }

    @Test
    public void testIsAssignableT() {
        class C<T extends Number> {
            C() {
            }
        }
        TypeVariable t = C.class.getTypeParameters()[0];
        Class<List> listRaw = List.class;
        ParameterizedType listT = Types.parameterize(List.class, (Type[])new Type[]{t});
        ParameterizedType listNumber = Types.parameterize(List.class, (Type[])new Type[]{Number.class});
        ParameterizedType listInteger = Types.parameterize(List.class, (Type[])new Type[]{Integer.class});
        ParameterizedType listExtendsNumber = Types.parameterize(List.class, (Type[])new Type[]{Types.wildcard((Type[])new Type[]{Number.class})});
        ParameterizedType listListRaw = Types.parameterize(List.class, (Type[])new Type[]{List.class});
        ParameterizedType listListInteger = Types.parameterize(List.class, (Type[])new Type[]{listInteger});
        Assertions.assertTrue((boolean)Types.isAssignable(t, t));
        Assertions.assertTrue((boolean)Types.isAssignable(listRaw, listRaw));
        Assertions.assertTrue((boolean)Types.isAssignable((Type)listT, (Type)listT));
        Assertions.assertTrue((boolean)Types.isAssignable((Type)listNumber, (Type)listNumber));
        Assertions.assertTrue((boolean)Types.isAssignable((Type)listInteger, (Type)listInteger));
        Assertions.assertTrue((boolean)Types.isAssignable((Type)listExtendsNumber, (Type)listExtendsNumber));
        Assertions.assertTrue((boolean)Types.isAssignable(listRaw, (Type)listExtendsNumber));
        Assertions.assertTrue((boolean)Types.isAssignable((Type)listT, (Type)listExtendsNumber));
        Assertions.assertTrue((boolean)Types.isAssignable((Type)listNumber, (Type)listExtendsNumber));
        Assertions.assertTrue((boolean)Types.isAssignable((Type)listInteger, (Type)listExtendsNumber));
        Assertions.assertTrue((boolean)Types.isAssignable(listRaw, (Type)listT));
        Assertions.assertTrue((boolean)Types.isAssignable((Type)listNumber, (Type)listT));
        Assertions.assertTrue((boolean)Types.isAssignable((Type)listInteger, (Type)listT));
        Assertions.assertTrue((boolean)Types.isAssignable((Type)listExtendsNumber, (Type)listT));
        Assertions.assertTrue((boolean)Types.isAssignable((Type)listExtendsNumber, (Type)listNumber));
        Assertions.assertTrue((boolean)Types.isAssignable((Type)listT, listRaw));
        Assertions.assertTrue((boolean)Types.isAssignable((Type)listNumber, listRaw));
        Assertions.assertTrue((boolean)Types.isAssignable((Type)listInteger, listRaw));
        Assertions.assertTrue((boolean)Types.isAssignable((Type)listExtendsNumber, listRaw));
        Assertions.assertTrue((boolean)Types.isAssignable((Type)listListRaw, listRaw));
        Assertions.assertTrue((boolean)Types.isAssignable((Type)listListInteger, listRaw));
        Assertions.assertFalse((boolean)Types.isAssignable((Type)listListInteger, (Type)listListRaw));
        Assertions.assertTrue((boolean)Types.isAssignable((Type)listListRaw, (Type)listListRaw));
    }

    @Test
    public void testIsAssignableParameterizedT() {
        class C<N extends Number, S extends String, T extends List<N>> {
            C() {
            }
        }
        TypeVariable n = C.class.getTypeParameters()[0];
        TypeVariable s = C.class.getTypeParameters()[1];
        TypeVariable t = C.class.getTypeParameters()[2];
        ParameterizedType listN = Types.parameterize(List.class, (Type[])new Type[]{n});
        ParameterizedType listS = Types.parameterize(List.class, (Type[])new Type[]{s});
        ParameterizedType listNumber = Types.parameterize(List.class, (Type[])new Type[]{Number.class});
        ParameterizedType listInteger = Types.parameterize(List.class, (Type[])new Type[]{Integer.class});
        ParameterizedType listExtendsNumber = Types.parameterize(List.class, (Type[])new Type[]{Types.wildcard((Type[])new Type[]{Number.class})});
        Assertions.assertTrue((boolean)Types.isAssignable((Type)listN, t));
        Assertions.assertTrue((boolean)Types.isAssignable((Type)listNumber, t));
        Assertions.assertTrue((boolean)Types.isAssignable((Type)listInteger, t));
        Assertions.assertTrue((boolean)Types.isAssignable((Type)listExtendsNumber, t));
        Assertions.assertFalse((boolean)Types.isAssignable((Type)listS, t));
    }

    @Test
    public void testIsAssignableObject() {
        class C<T extends Number> {
            C() {
            }
        }
        TypeVariable t = C.class.getTypeParameters()[0];
        ParameterizedType iterableT = Types.parameterize(Iterable.class, (Type[])new Type[]{t});
        Assertions.assertTrue((boolean)Types.isAssignable((Type)iterableT, Object.class));
    }

    @Test
    public void testIsInstance() {
        Object nullObject = null;
        Assertions.assertTrue((boolean)Types.isInstance(nullObject, Object.class));
        Assertions.assertTrue((boolean)Types.isInstance(nullObject, int[].class));
        Assertions.assertFalse((boolean)Types.isInstance(nullObject, null));
        Assertions.assertFalse((boolean)Types.isInstance((Object)new Object(), null));
    }

    @Test
    public void testIsRecursive() {
        Assertions.assertFalse((boolean)Types.isRecursive((Type)Types.parameterize(ArrayList.class, (Type[])new Type[0])));
        Assertions.assertTrue((boolean)Types.isRecursive((Type)Types.parameterize(RecursiveClass.class, (Type[])new Type[0])));
    }

    @Test
    public void testCast() {
        String string = "Hello";
        Object stringToObject = Types.cast((Object)"Hello", Object.class);
        Assertions.assertSame((Object)"Hello", (Object)stringToObject);
        ArrayList arrayList = new ArrayList();
        Collection arrayListToCollection = (Collection)Types.cast(arrayList, Collection.class);
        Assertions.assertSame(arrayList, (Object)arrayListToCollection);
        Float doubleToFloat = (Float)Types.cast((Object)5.1, Float.TYPE);
        Assertions.assertNull((Object)doubleToFloat);
        Double floatToDouble = (Double)Types.cast((Object)Float.valueOf(5.1f), Double.TYPE);
        Assertions.assertNull((Object)floatToDouble);
        Number intToNumber = (Number)Types.cast((Object)5, Number.class);
        Assertions.assertSame(Integer.class, intToNumber.getClass());
        Assertions.assertEquals((int)5, (int)intToNumber.intValue());
    }

    @Test
    public void testEnumValue() {
        ExampleTypes.Words foo = (ExampleTypes.Words)Types.enumValue((String)"FOO", ExampleTypes.Words.class);
        Assertions.assertSame((Object)ExampleTypes.Words.FOO, (Object)foo);
        ExampleTypes.Words bar = (ExampleTypes.Words)Types.enumValue((String)"BAR", ExampleTypes.Words.class);
        Assertions.assertSame((Object)ExampleTypes.Words.BAR, (Object)bar);
        ExampleTypes.Words fubar = (ExampleTypes.Words)Types.enumValue((String)"FUBAR", ExampleTypes.Words.class);
        Assertions.assertSame((Object)ExampleTypes.Words.FUBAR, (Object)fubar);
    }

    @Test
    public void testEnumValueNoConstant() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Types.enumValue((String)"NONE", ExampleTypes.Words.class));
    }

    @Test
    public void testEnumValueNonEnum() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Types.enumValue((String)"HOOYAH", String.class));
    }

    private Type type(Class<?> c, String fieldName) {
        return Classes.field(c, (String)fieldName).getGenericType();
    }

    private Class<?> raw(Class<?> c, String fieldName) {
        return Types.raw((Type)this.type(c, fieldName));
    }

    private Class<?> componentType(Class<?> c, String fieldName) {
        return Types.raw((Type)Types.component((Type)this.type(c, fieldName)));
    }

    private void assertAllTheSame(List<?> actual, Object ... expected) {
        Assertions.assertEquals((int)expected.length, (int)actual.size());
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertSame((Object)expected[i], actual.get(i));
        }
    }

    private static class RecursiveClass<T extends RecursiveClass<T>> {
        private RecursiveClass() {
        }
    }
}

