/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.common3;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.scijava.common3.Any;
import org.scijava.common3.Classes;

public final class Types {
    private Types() {
    }

    public static String name(Type t) {
        if (t instanceof Class) {
            Class c = (Class)t;
            return c.isArray() ? Types.name(Types.component(c)) + "[]" : c.getName();
        }
        return t.toString();
    }

    public static boolean isInstance(Object obj, Class<?> dest) {
        if (dest == null) {
            return false;
        }
        return obj == null || dest.isInstance(obj);
    }

    public static <T> T cast(Object src, Class<T> dest) {
        if (!Types.isInstance(src, dest)) {
            return null;
        }
        Object result = src;
        return (T)result;
    }

    public static <T> T enumValue(String name, Class<T> dest) {
        T result;
        if (!dest.isEnum()) {
            throw new IllegalArgumentException("Not an enum type: " + Types.name(dest));
        }
        T typedResult = result = Enum.valueOf(dest, name);
        return typedResult;
    }

    public static Class<?> raw(Type type) {
        if (type == null) {
            return null;
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        List<Class<?>> c = Types.raws(type);
        if (c.isEmpty()) {
            return null;
        }
        return c.get(0);
    }

    public static List<Class<?>> raws(Type type) {
        if (type == null) {
            return null;
        }
        return GenericTypeReflector.getUpperBoundClassAndInterfaces(type);
    }

    public static Type typeOf(Field field, Class<?> type) {
        ParameterizedType pType = Types.parameterize(type, new Type[0]);
        return GenericTypeReflector.getExactFieldType(field, pType);
    }

    public static Type[] paramTypesOf(Method m, Type type) {
        return GenericTypeReflector.getExactParameterTypes(m, type);
    }

    public static Type returnTypeOf(Method m, Type type) {
        return GenericTypeReflector.getExactReturnType(m, type);
    }

    public static boolean isAssignable(Type source, Type target) {
        if (source instanceof Class && target instanceof Class) {
            Class boxedSource = Classes.box((Class)source);
            Class boxedTarget = Classes.box((Class)target);
            return TypeUtils.isAssignable(boxedSource, boxedTarget);
        }
        return TypeUtils.isAssignable(source, target);
    }

    public static boolean isAssignable(Type type, Type toType, Map<TypeVariable<?>, Type> typeVarAssigns) {
        if (type instanceof Class && toType instanceof Class) {
            return TypeUtils.isAssignable(Classes.box((Class)type), Classes.box((Class)toType));
        }
        return TypeUtils.isAssignable(type, toType, typeVarAssigns);
    }

    public static Type superTypeOf(Type type, Class<?> searchClass) {
        return GenericTypeReflector.getExactSuperType(type, searchClass);
    }

    public static Type commonSuperTypeOf(Type ... types) {
        if ((types = (Type[])Arrays.stream(types).filter(t -> !Any.is(t)).toArray(Type[]::new)).length == 0) {
            return null;
        }
        if (types.length == 1) {
            return types[0];
        }
        for (int i = 0; i < types.length; ++i) {
            if (types[i] instanceof TypeVariable) {
                TypeVariable typeVar = (TypeVariable)types[i];
                types[i] = Types.commonSuperTypeOf(typeVar.getBounds());
            }
            if (!(types[i] instanceof WildcardType)) continue;
            WildcardType wildcard = (WildcardType)types[i];
            types[i] = Types.commonSuperTypeOf(wildcard.getUpperBounds());
        }
        Type superType = types[0];
        while (Types.raw(superType) != Object.class) {
            Type pType = Types.superTypeOf(types[0], Types.raw(superType));
            if (Types.isAssignable(types, pType) == -1) {
                return superType;
            }
            if (pType instanceof ParameterizedType && Types.isAssignable(types, Types.raw(superType)) == -1) {
                ParameterizedType[] castedTypes = new ParameterizedType[types.length];
                castedTypes[0] = (ParameterizedType)pType;
                for (int i = 1; i < castedTypes.length; ++i) {
                    Type t2 = Types.superTypeOf(types[i], Types.raw(superType));
                    if (!(t2 instanceof ParameterizedType)) continue;
                    castedTypes[i] = (ParameterizedType)t2;
                }
                Type[] resolvedTypeArgs = new Type[castedTypes[0].getActualTypeArguments().length];
                for (int i = 0; i < resolvedTypeArgs.length; ++i) {
                    Object[] typeVarsI = new Type[types.length];
                    for (int j = 0; j < typeVarsI.length; ++j) {
                        typeVarsI[j] = castedTypes[j].getActualTypeArguments()[i];
                    }
                    resolvedTypeArgs[i] = Arrays.equals(types, typeVarsI) ? Types.wildcard(new Type[0]) : Types.wildcard(Types.commonSuperTypeOf((Type[])typeVarsI));
                }
                return Types.parameterize(Types.raw(superType), resolvedTypeArgs);
            }
            if (Types.raw(superType).isInterface()) break;
            superType = Types.superTypeOf(superType, Types.raw(superType).getSuperclass());
        }
        ArrayList<Type> sharedInterfaces = new ArrayList<Type>();
        LinkedList<Type> superInterfaces = new LinkedList<Type>();
        if (Types.raw(types[0]).isInterface()) {
            superInterfaces.add(types[0]);
        } else {
            Collections.addAll(superInterfaces, Types.raw(types[0]).getGenericInterfaces());
        }
        while (!superInterfaces.isEmpty()) {
            Type type = (Type)superInterfaces.remove();
            Type pType = Types.superTypeOf(types[0], Types.raw(type));
            if (Types.isAssignable(types, pType) == -1) {
                sharedInterfaces.add(pType);
                continue;
            }
            if (pType instanceof ParameterizedType && Types.isAssignable(types, Types.raw(pType)) == -1) {
                ParameterizedType[] castedTypes = new ParameterizedType[types.length];
                castedTypes[0] = (ParameterizedType)pType;
                for (int i = 1; i < castedTypes.length; ++i) {
                    Type t3 = Types.superTypeOf(types[i], Types.raw(pType));
                    if (!(t3 instanceof ParameterizedType)) continue;
                    castedTypes[i] = (ParameterizedType)t3;
                }
                Type[] resolvedTypeArgs = new Type[castedTypes[0].getActualTypeArguments().length];
                for (int i = 0; i < resolvedTypeArgs.length; ++i) {
                    Object[] typeVarsI = new Type[types.length];
                    for (int j = 0; j < typeVarsI.length; ++j) {
                        typeVarsI[j] = castedTypes[j].getActualTypeArguments()[i];
                    }
                    resolvedTypeArgs[i] = Arrays.equals(types, typeVarsI) ? Types.wildcard(new Type[0]) : Types.commonSuperTypeOf((Type[])typeVarsI);
                }
                return Types.parameterize(Types.raw(pType), resolvedTypeArgs);
            }
            if (!sharedInterfaces.isEmpty()) continue;
            Collections.addAll(superInterfaces, Types.raw(type).getGenericInterfaces());
        }
        if (sharedInterfaces.size() == 1) {
            return (Type)sharedInterfaces.get(0);
        }
        if (!sharedInterfaces.isEmpty()) {
            return Types.wildcard(sharedInterfaces.toArray(new Type[0]));
        }
        return Object.class;
    }

    public static Type component(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getComponentType();
        }
        if (type instanceof GenericArrayType) {
            return ((GenericArrayType)type).getGenericComponentType();
        }
        return null;
    }

    public static Type[] typeParamsOf(Type src, Class<?> superclass) {
        if (!(src instanceof Class || src instanceof ParameterizedType || src instanceof TypeVariable)) {
            return new Type[0];
        }
        try {
            Type superSrc = Types.superTypeOf(src, superclass);
            if (superSrc instanceof ParameterizedType) {
                return ((ParameterizedType)superSrc).getActualTypeArguments();
            }
            return Types.typeParamsOfClass(Types.raw(src), superclass);
        }
        catch (AssertionError e) {
            return new Type[0];
        }
    }

    public static boolean containsTypeVars(Type type) {
        return TypeUtils.containsTypeVariables(type);
    }

    public static boolean isRecursive(Type type) {
        if (type instanceof ParameterizedType) {
            Type[] actualTypeArguments;
            ParameterizedType parameterizedType = (ParameterizedType)type;
            for (Type arg : actualTypeArguments = parameterizedType.getActualTypeArguments()) {
                if (!(arg instanceof TypeVariable)) continue;
                TypeVariable argVar = (TypeVariable)arg;
                for (Type bound : argVar.getBounds()) {
                    if (!bound.equals(type)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isRecursiveBound(Type refType, Type typeBound) {
        if (typeBound instanceof ParameterizedType) {
            for (Type boundArg : ((ParameterizedType)typeBound).getActualTypeArguments()) {
                if (!Objects.equals(refType, boundArg)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean varsSatisfied(Map<TypeVariable<?>, Type> typeVarAssigns) {
        return TypeUtils.typesSatisfyVariables(typeVarAssigns);
    }

    public static Type[] unroll(Type[] typesToMap, Map<TypeVariable<?>, Type> typeVarAssigns) {
        return (Type[])Arrays.stream(typesToMap).map(type -> Types.unroll(type, typeVarAssigns)).toArray(Type[]::new);
    }

    public static Type unroll(Type typeToMap, Map<TypeVariable<?>, Type> typeVarAssigns) {
        return Types.unroll(typeVarAssigns, typeToMap, false);
    }

    public static Type unroll(Map<TypeVariable<?>, Type> typeVarAssigns, Type type, boolean followTypeVars) {
        return TypeUtils.unrollVariables(typeVarAssigns, type, followTypeVars);
    }

    public static Type array(Type componentType) {
        if (componentType == null) {
            return null;
        }
        if (componentType instanceof Class) {
            return Classes.array((Class)componentType);
        }
        return new TypeUtils.GenericArrayTypeImpl(componentType);
    }

    public static ParameterizedType parameterize(Class<?> raw, Type ... typeArgs) {
        return Types.parameterizeClass(raw, raw.getDeclaringClass(), typeArgs.length == 0 ? raw.getTypeParameters() : typeArgs);
    }

    public static ParameterizedType parameterize(Class<?> raw, Map<TypeVariable<?>, Type> typeVarAssigns) {
        return TypeUtils.parameterize(raw, typeVarAssigns);
    }

    public static WildcardType wildcard(Type ... upperBounds) {
        return Types.wildcard(upperBounds, null);
    }

    public static WildcardType wildcard(Type[] upperBounds, Type[] lowerBounds) {
        return new TypeUtils.WildcardTypeImpl(upperBounds, lowerBounds);
    }

    private static int isAssignable(Type[] sources, Type target) {
        for (int i = 0; i < sources.length; ++i) {
            if (Types.isAssignable(sources[i], target)) continue;
            return i;
        }
        return -1;
    }

    private static Type[] typeParamsOfClass(Class<?> subType, Class<?> superErasure) {
        ParameterizedType pt = Types.parameterize(subType, new Type[0]);
        Type superType = Types.superTypeOf(pt, superErasure);
        if (superType instanceof ParameterizedType) {
            return ((ParameterizedType)superType).getActualTypeArguments();
        }
        return new Type[0];
    }

    private static ParameterizedType parameterizeClass(Class<?> raw, Type ownerType, Type[] typeArgs) {
        return new TypeUtils.ParameterizedTypeImpl(raw, ownerType, typeArgs);
    }

    private static class VarMap {
        private final Map<TypeVariable<?>, Type> map = new HashMap();

        VarMap() {
        }

        void add(TypeVariable<?> variable, Type value) {
            this.map.put(variable, value);
        }

        void addAll(TypeVariable<?>[] variables, Type[] values) {
            assert (variables.length == values.length);
            for (int i = 0; i < variables.length; ++i) {
                this.map.put(variables[i], values[i]);
            }
        }

        Type map(Type type) {
            if (type instanceof Class) {
                return type;
            }
            if (type instanceof TypeVariable) {
                assert (this.map.containsKey(type));
                return this.map.get(type);
            }
            if (type instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)type;
                return Types.parameterizeClass((Class)pType.getRawType(), pType.getOwnerType() == null ? pType.getOwnerType() : this.map(pType.getOwnerType()), this.map(pType.getActualTypeArguments()));
            }
            if (type instanceof WildcardType) {
                WildcardType wType = (WildcardType)type;
                return new TypeUtils.WildcardTypeImpl(this.map(wType.getUpperBounds()), this.map(wType.getLowerBounds()));
            }
            if (type instanceof GenericArrayType) {
                return Types.array(this.map(((GenericArrayType)type).getGenericComponentType()));
            }
            throw new RuntimeException("not implemented: mapping " + type.getClass() + " (" + type + ")");
        }

        Type[] map(Type[] types) {
            Type[] result = new Type[types.length];
            for (int i = 0; i < types.length; ++i) {
                result[i] = this.map(types[i]);
            }
            return result;
        }
    }

    private static class CaptureTypeImpl
    implements CaptureType {
        private final WildcardType wildcard;
        private final TypeVariable<?> variable;
        private final Type[] lowerBounds;
        private Type[] upperBounds;

        public CaptureTypeImpl(WildcardType wildcard, TypeVariable<?> variable) {
            this.wildcard = wildcard;
            this.variable = variable;
            this.lowerBounds = wildcard.getLowerBounds();
        }

        void init(VarMap varMap) {
            ArrayList<Type> upperBoundsList = new ArrayList<Type>();
            upperBoundsList.addAll(Arrays.asList(varMap.map(this.variable.getBounds())));
            List<Type> wildcardUpperBounds = Arrays.asList(this.wildcard.getUpperBounds());
            if (wildcardUpperBounds.size() > 0 && wildcardUpperBounds.get(0) == Object.class) {
                upperBoundsList.addAll(wildcardUpperBounds.subList(1, wildcardUpperBounds.size()));
            } else {
                upperBoundsList.addAll(wildcardUpperBounds);
            }
            this.upperBounds = new Type[upperBoundsList.size()];
            upperBoundsList.toArray(this.upperBounds);
        }

        @Override
        public Type[] getLowerBounds() {
            return (Type[])this.lowerBounds.clone();
        }

        @Override
        public Type[] getUpperBounds() {
            assert (this.upperBounds != null);
            return (Type[])this.upperBounds.clone();
        }

        public String toString() {
            return "capture of " + this.wildcard;
        }
    }

    private static interface CaptureType
    extends Type {
        public Type[] getUpperBounds();

        public Type[] getLowerBounds();
    }

    private static class GenericTypeReflector {
        private static final Type UNBOUND_WILDCARD = new TypeUtils.WildcardTypeImpl(new Type[]{Object.class}, new Type[0]);

        private GenericTypeReflector() {
        }

        public static Class<?> erase(Type type) {
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                return (Class)((ParameterizedType)type).getRawType();
            }
            if (type instanceof TypeVariable) {
                TypeVariable tv = (TypeVariable)type;
                if (tv.getBounds().length == 0) {
                    return Object.class;
                }
                return GenericTypeReflector.erase(tv.getBounds()[0]);
            }
            if (type instanceof GenericArrayType) {
                GenericArrayType aType = (GenericArrayType)type;
                return Classes.array(GenericTypeReflector.erase(aType.getGenericComponentType()));
            }
            throw new RuntimeException("not supported: " + type.getClass());
        }

        private static Type mapTypeParameters(Type toMapType, Type typeAndParams) {
            if (GenericTypeReflector.isMissingTypeParameters(typeAndParams)) {
                return GenericTypeReflector.erase(toMapType);
            }
            VarMap varMap = new VarMap();
            Type handlingTypeAndParams = typeAndParams;
            while (handlingTypeAndParams instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)handlingTypeAndParams;
                Class clazz = (Class)pType.getRawType();
                varMap.addAll(clazz.getTypeParameters(), pType.getActualTypeArguments());
                handlingTypeAndParams = pType.getOwnerType();
            }
            return varMap.map(toMapType);
        }

        private static boolean isMissingTypeParameters(Type type) {
            if (type instanceof Class) {
                for (Class<?> clazz = (Class<?>)type; clazz != null; clazz = clazz.getEnclosingClass()) {
                    if (clazz.getTypeParameters().length == 0) continue;
                    return true;
                }
                return false;
            }
            if (type instanceof ParameterizedType) {
                return false;
            }
            throw new AssertionError((Object)("Unexpected type " + type.getClass()));
        }

        public static Type addWildcardParameters(Class<?> clazz) {
            if (clazz.isArray()) {
                return Types.array(GenericTypeReflector.addWildcardParameters(clazz.getComponentType()));
            }
            if (GenericTypeReflector.isMissingTypeParameters(clazz)) {
                TypeVariable<Class<?>>[] vars = clazz.getTypeParameters();
                Object[] arguments = new Type[vars.length];
                Arrays.fill(arguments, UNBOUND_WILDCARD);
                Type owner = clazz.getDeclaringClass() == null ? null : GenericTypeReflector.addWildcardParameters(clazz.getDeclaringClass());
                return Types.parameterizeClass(clazz, owner, (Type[])arguments);
            }
            return clazz;
        }

        public static Type getExactSuperType(Type type, Class<?> searchClass) {
            if (type instanceof ParameterizedType || type instanceof Class || type instanceof GenericArrayType) {
                Class<?> clazz = GenericTypeReflector.erase(type);
                if (searchClass == clazz) {
                    return type;
                }
                if (!searchClass.isAssignableFrom(clazz)) {
                    return null;
                }
            }
            for (Type superType : GenericTypeReflector.getExactDirectSuperTypes(type)) {
                Type result = GenericTypeReflector.getExactSuperType(superType, searchClass);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        public static Type getTypeParameter(Type type, TypeVariable<? extends Class<?>> variable) {
            Class<?> clazz = variable.getGenericDeclaration();
            Type superType = GenericTypeReflector.getExactSuperType(type, clazz);
            if (superType instanceof ParameterizedType) {
                int index = Arrays.asList(clazz.getTypeParameters()).indexOf(variable);
                return ((ParameterizedType)superType).getActualTypeArguments()[index];
            }
            return null;
        }

        public static boolean isSuperType(Type superType, Type subType) {
            if (superType instanceof ParameterizedType || superType instanceof Class || superType instanceof GenericArrayType) {
                Class<?> superClass = GenericTypeReflector.erase(superType);
                Type mappedSubType = GenericTypeReflector.getExactSuperType(GenericTypeReflector.capture(subType), superClass);
                if (mappedSubType == null) {
                    return false;
                }
                if (superType instanceof Class) {
                    return true;
                }
                if (mappedSubType instanceof Class) {
                    return true;
                }
                if (mappedSubType instanceof GenericArrayType) {
                    Type superComponentType = GenericTypeReflector.getArrayComponentType(superType);
                    assert (superComponentType != null);
                    Type mappedSubComponentType = GenericTypeReflector.getArrayComponentType(mappedSubType);
                    assert (mappedSubComponentType != null);
                    return GenericTypeReflector.isSuperType(superComponentType, mappedSubComponentType);
                }
                assert (mappedSubType instanceof ParameterizedType);
                ParameterizedType pMappedSubType = (ParameterizedType)mappedSubType;
                assert (pMappedSubType.getRawType() == superClass);
                ParameterizedType pSuperType = (ParameterizedType)superType;
                Type[] superTypeArgs = pSuperType.getActualTypeArguments();
                Type[] subTypeArgs = pMappedSubType.getActualTypeArguments();
                assert (superTypeArgs.length == subTypeArgs.length);
                for (int i = 0; i < superTypeArgs.length; ++i) {
                    if (GenericTypeReflector.contains(superTypeArgs[i], subTypeArgs[i])) continue;
                    return false;
                }
                return pSuperType.getOwnerType() == null || GenericTypeReflector.isSuperType(pSuperType.getOwnerType(), pMappedSubType.getOwnerType());
            }
            if (superType instanceof CaptureType) {
                if (superType.equals(subType)) {
                    return true;
                }
                for (Type lowerBound : ((CaptureType)superType).getLowerBounds()) {
                    if (!GenericTypeReflector.isSuperType(lowerBound, subType)) continue;
                    return true;
                }
                return false;
            }
            if (superType instanceof GenericArrayType) {
                return GenericTypeReflector.isArraySupertype(superType, subType);
            }
            throw new RuntimeException("not implemented: " + superType.getClass());
        }

        private static boolean isArraySupertype(Type arraySuperType, Type subType) {
            Type superTypeComponent = GenericTypeReflector.getArrayComponentType(arraySuperType);
            assert (superTypeComponent != null);
            Type subTypeComponent = GenericTypeReflector.getArrayComponentType(subType);
            if (subTypeComponent == null) {
                return false;
            }
            return GenericTypeReflector.isSuperType(superTypeComponent, subTypeComponent);
        }

        public static Type getArrayComponentType(Type type) {
            if (type instanceof Class) {
                Class clazz = (Class)type;
                return clazz.getComponentType();
            }
            if (type instanceof GenericArrayType) {
                GenericArrayType aType = (GenericArrayType)type;
                return aType.getGenericComponentType();
            }
            return null;
        }

        private static boolean contains(Type containingType, Type containedType) {
            if (containingType instanceof WildcardType) {
                WildcardType wContainingType = (WildcardType)containingType;
                for (Type upperBound : wContainingType.getUpperBounds()) {
                    if (GenericTypeReflector.isSuperType(upperBound, containedType)) continue;
                    return false;
                }
                for (Type lowerBound : wContainingType.getLowerBounds()) {
                    if (GenericTypeReflector.isSuperType(containedType, lowerBound)) continue;
                    return false;
                }
                return true;
            }
            return containingType.equals(containedType);
        }

        private static Type[] getExactDirectSuperTypes(Type type) {
            if (type instanceof ParameterizedType || type instanceof Class) {
                int resultIndex;
                Type[] result;
                Class clazz;
                if (type instanceof ParameterizedType) {
                    clazz = (Class)((ParameterizedType)type).getRawType();
                } else {
                    clazz = (Class)type;
                    if (clazz.isArray()) {
                        return GenericTypeReflector.getArrayExactDirectSuperTypes(clazz);
                    }
                }
                Type[] superInterfaces = clazz.getGenericInterfaces();
                Type superClass = clazz.getGenericSuperclass();
                if (superClass == null) {
                    result = new Type[superInterfaces.length];
                    resultIndex = 0;
                } else {
                    result = new Type[superInterfaces.length + 1];
                    resultIndex = 1;
                    result[0] = superClass instanceof ParameterizedType && !(type instanceof ParameterizedType) ? superClass : GenericTypeReflector.mapTypeParameters(superClass, type);
                }
                for (Type superInterface : superInterfaces) {
                    result[resultIndex++] = GenericTypeReflector.mapTypeParameters(superInterface, type);
                }
                return result;
            }
            if (type instanceof TypeVariable) {
                TypeVariable tv = (TypeVariable)type;
                return tv.getBounds();
            }
            if (type instanceof WildcardType) {
                return ((WildcardType)type).getUpperBounds();
            }
            if (type instanceof CaptureType) {
                return ((CaptureType)type).getUpperBounds();
            }
            if (type instanceof GenericArrayType) {
                return GenericTypeReflector.getArrayExactDirectSuperTypes(type);
            }
            throw new RuntimeException("not implemented type: " + type);
        }

        private static Type[] getArrayExactDirectSuperTypes(Type arrayType) {
            Type[] result;
            int resultIndex;
            Type typeComponent = GenericTypeReflector.getArrayComponentType(arrayType);
            if (typeComponent instanceof Class && ((Class)typeComponent).isPrimitive()) {
                resultIndex = 0;
                result = new Type[3];
            } else {
                Type[] componentSupertypes = GenericTypeReflector.getExactDirectSuperTypes(typeComponent);
                result = new Type[componentSupertypes.length + 3];
                for (resultIndex = 0; resultIndex < componentSupertypes.length; ++resultIndex) {
                    result[resultIndex] = Types.array(componentSupertypes[resultIndex]);
                }
            }
            result[resultIndex++] = Object.class;
            result[resultIndex++] = Cloneable.class;
            result[resultIndex++] = Serializable.class;
            return result;
        }

        public static Type getExactReturnType(Method m, Type type) {
            Type returnType = m.getGenericReturnType();
            Type exactDeclaringType = GenericTypeReflector.getExactSuperType(GenericTypeReflector.capture(type), m.getDeclaringClass());
            if (exactDeclaringType == null) {
                throw new IllegalArgumentException("The method " + m + " is not a member of type " + type);
            }
            return GenericTypeReflector.mapTypeParameters(returnType, exactDeclaringType);
        }

        public static Type getExactFieldType(Field f, Type type) {
            Type returnType = f.getGenericType();
            Type exactDeclaringType = GenericTypeReflector.getExactSuperType(GenericTypeReflector.capture(type), f.getDeclaringClass());
            if (exactDeclaringType == null) {
                throw new IllegalArgumentException("The field " + f + " is not a member of type " + type);
            }
            return GenericTypeReflector.mapTypeParameters(returnType, exactDeclaringType);
        }

        public static Type[] getExactParameterTypes(Method m, Type type) {
            Type[] parameterTypes = m.getGenericParameterTypes();
            Type exactDeclaringType = GenericTypeReflector.getExactSuperType(GenericTypeReflector.capture(type), m.getDeclaringClass());
            if (exactDeclaringType == null) {
                throw new IllegalArgumentException("The method " + m + " is not a member of type " + type);
            }
            Type[] result = new Type[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                result[i] = GenericTypeReflector.mapTypeParameters(parameterTypes[i], exactDeclaringType);
            }
            return result;
        }

        public static Type capture(Type type) {
            VarMap varMap = new VarMap();
            ArrayList<CaptureTypeImpl> toInit = new ArrayList<CaptureTypeImpl>();
            if (type instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)type;
                Class clazz = (Class)pType.getRawType();
                Type[] arguments = pType.getActualTypeArguments();
                TypeVariable<Class<T>>[] vars = clazz.getTypeParameters();
                Type[] capturedArguments = new Type[arguments.length];
                assert (arguments.length == vars.length);
                for (int i = 0; i < arguments.length; ++i) {
                    Type argument = arguments[i];
                    if (argument instanceof WildcardType) {
                        CaptureTypeImpl captured = new CaptureTypeImpl((WildcardType)argument, vars[i]);
                        argument = captured;
                        toInit.add(captured);
                    }
                    capturedArguments[i] = argument;
                    varMap.add(vars[i], argument);
                }
                for (CaptureTypeImpl captured : toInit) {
                    captured.init(varMap);
                }
                Type ownerType = pType.getOwnerType() == null ? null : GenericTypeReflector.capture(pType.getOwnerType());
                return Types.parameterizeClass(clazz, ownerType, capturedArguments);
            }
            return type;
        }

        public static List<Class<?>> getUpperBoundClassAndInterfaces(Type type) {
            LinkedHashSet result = new LinkedHashSet();
            GenericTypeReflector.buildUpperBoundClassAndInterfaces(type, result);
            return new ArrayList(result);
        }

        private static void buildUpperBoundClassAndInterfaces(Type type, Set<Class<?>> result) {
            if (type instanceof ParameterizedType || type instanceof Class) {
                result.add(GenericTypeReflector.erase(type));
                return;
            }
            for (Type superType : GenericTypeReflector.getExactDirectSuperTypes(type)) {
                GenericTypeReflector.buildUpperBoundClassAndInterfaces(superType, result);
            }
        }
    }

    private static class TypeUtils {
        public static final WildcardType WILDCARD_ALL = TypeUtils.wildcardType().withUpperBounds(new Type[]{Object.class}).build();
        private static final String DEFAULT_IS_NULL_EX_MESSAGE = "The validated object is null";
        private static final String DEFAULT_NO_NULL_ELEMENTS_ARRAY_EX_MESSAGE = "The validated array contains null element at index: %d";
        private static final String DEFAULT_NOT_EMPTY_ARRAY_EX_MESSAGE = "The validated array is empty";

        private TypeUtils() {
        }

        public static boolean isAssignable(Type type, Type toType) {
            if (toType == null) {
                throw new NullPointerException("Destination type is null");
            }
            return TypeUtils.isAssignable(type, toType, new HashMap());
        }

        private static boolean isAssignable(Type type, Type toType, Map<TypeVariable<?>, Type> typeVarAssigns) {
            if (toType == null || toType instanceof Class) {
                return TypeUtils.isAssignable(type, (Class)toType);
            }
            if (toType instanceof ParameterizedType) {
                return TypeUtils.isAssignable(type, (ParameterizedType)toType, typeVarAssigns);
            }
            if (toType instanceof GenericArrayType) {
                return TypeUtils.isAssignable(type, (GenericArrayType)toType, typeVarAssigns);
            }
            if (toType instanceof WildcardType) {
                return TypeUtils.isAssignable(type, (WildcardType)toType, typeVarAssigns);
            }
            if (toType instanceof TypeVariable) {
                return TypeUtils.isAssignable(type, (TypeVariable)toType, typeVarAssigns);
            }
            if (Any.is(toType)) {
                return TypeUtils.isAssignable(type, (Any)toType, typeVarAssigns);
            }
            throw new IllegalStateException("found an unhandled type: " + toType);
        }

        private static boolean isAssignable(Type type, Any toType, Map<TypeVariable<?>, Type> typeVarAssigns) {
            if (type instanceof TypeVariable) {
                // empty if block
            }
            if (type instanceof ParameterizedType) {
                Type[] typeParameters;
                for (Type typeParameter : typeParameters = ((ParameterizedType)type).getActualTypeArguments()) {
                    if (!(typeParameter instanceof TypeVariable) || typeVarAssigns.containsKey(typeParameter)) continue;
                    TypeVariable typeVar = (TypeVariable)typeParameter;
                    typeVarAssigns.put(typeVar, new Any(typeVar.getBounds()));
                }
                return true;
            }
            for (Type upperBound : toType.getUpperBounds()) {
                if (TypeUtils.isAssignable(type, upperBound)) continue;
                return false;
            }
            for (Type lowerBound : toType.getLowerBounds()) {
                if (TypeUtils.isAssignable(lowerBound, type)) continue;
                return false;
            }
            return true;
        }

        private static boolean isAssignable(Type type, Class<?> toClass) {
            if (type == null) {
                return toClass == null || !toClass.isPrimitive();
            }
            if (toClass == null) {
                return false;
            }
            if (toClass.equals(type)) {
                return true;
            }
            if (type.equals(Any.class)) {
                return true;
            }
            if (type instanceof Class) {
                return type.equals(Any.class) || toClass.isAssignableFrom((Class)type);
            }
            if (type instanceof ParameterizedType) {
                return TypeUtils.isAssignable(TypeUtils.getRawType((ParameterizedType)type), toClass);
            }
            if (type instanceof TypeVariable) {
                for (Type bound : ((TypeVariable)type).getBounds()) {
                    if (!TypeUtils.isAssignable(bound, toClass)) continue;
                    return true;
                }
                return false;
            }
            if (type instanceof GenericArrayType) {
                return toClass.equals(Object.class) || toClass.isArray() && TypeUtils.isAssignable(((GenericArrayType)type).getGenericComponentType(), toClass.getComponentType());
            }
            if (type instanceof WildcardType) {
                return false;
            }
            if (Any.is(type)) {
                return true;
            }
            throw new IllegalStateException("found an unhandled type: " + type);
        }

        private static boolean isAssignable(Type type, ParameterizedType toParameterizedType, Map<TypeVariable<?>, Type> typeVarAssigns) {
            if (type == null) {
                return true;
            }
            if (toParameterizedType == null) {
                return false;
            }
            if (toParameterizedType.equals(type)) {
                return true;
            }
            if (Any.is(type)) {
                for (Type typeParameter : toParameterizedType.getActualTypeArguments()) {
                    TypeVariable typeVar;
                    if (!(typeParameter instanceof TypeVariable) || typeVarAssigns.containsKey(typeVar = (TypeVariable)typeParameter)) continue;
                    typeVarAssigns.put(typeVar, new Any(typeVar.getBounds()));
                }
                return true;
            }
            Class<?> toClass = TypeUtils.getRawType(toParameterizedType);
            Map<TypeVariable<?>, Type> fromTypeVarAssigns = TypeUtils.getTypeArguments(type, toClass, typeVarAssigns);
            if (fromTypeVarAssigns == null) {
                if (type instanceof TypeVariable) {
                    TypeVariable typeVar = (TypeVariable)type;
                    Type[] bounds = typeVar.getBounds();
                    if (typeVarAssigns.containsKey(type)) {
                        return TypeUtils.isAssignable(typeVarAssigns.get(type), toParameterizedType, typeVarAssigns);
                    }
                    if (bounds.length == 1 && Object.class.equals((Object)bounds[0])) {
                        typeVarAssigns.put((TypeVariable)type, toParameterizedType);
                        return true;
                    }
                }
                return false;
            }
            if (fromTypeVarAssigns.isEmpty()) {
                return true;
            }
            Map<TypeVariable<?>, Type> toTypeVarAssigns = TypeUtils.getTypeArguments(toParameterizedType, toClass, typeVarAssigns);
            for (TypeVariable<?> var : toTypeVarAssigns.keySet()) {
                Object unbounded;
                int n;
                Type toTypeArg = TypeUtils.unrollVariableAssignments(var, toTypeVarAssigns);
                Type fromTypeArg = TypeUtils.unrollVariableAssignments(var, fromTypeVarAssigns);
                Type toResolved = TypeUtils.resolveTypeParameters(toTypeArg, toTypeVarAssigns);
                Type fromResolved = TypeUtils.resolveTypeParameters(fromTypeArg, fromTypeVarAssigns);
                Type[] toBounds = TypeUtils.determineBounds(var, toTypeArg, toResolved, toTypeVarAssigns);
                Type[] fromBounds = TypeUtils.determineBounds(var, fromTypeArg, fromResolved, fromTypeVarAssigns);
                if (toBounds != null) {
                    Type[] typeArray = toBounds;
                    int n2 = typeArray.length;
                    for (n = 0; n < n2; ++n) {
                        Type to = typeArray[n];
                        if (fromBounds != null) {
                            for (Type from : fromBounds) {
                                if (TypeUtils.isAssignable(from, to, typeVarAssigns)) continue;
                                return false;
                            }
                            continue;
                        }
                        if (TypeUtils.isAssignable(fromResolved == null ? fromTypeArg : fromResolved, to, typeVarAssigns)) continue;
                        return false;
                    }
                    if (toTypeArg != null || toResolved != null || fromResolved == null || typeVarAssigns == null) continue;
                    unbounded = (TypeVariable)toTypeVarAssigns.get(var);
                    typeVarAssigns.put((TypeVariable<?>)unbounded, fromResolved);
                    continue;
                }
                if (fromBounds != null) {
                    unbounded = fromBounds;
                    int n3 = ((Type[])unbounded).length;
                    for (n = 0; n < n3; ++n) {
                        Type from = unbounded[n];
                        if (TypeUtils.isAssignable(from, toResolved == null ? toTypeArg : toResolved, typeVarAssigns)) continue;
                        return false;
                    }
                    continue;
                }
                if (toTypeArg == null && toResolved == null && typeVarAssigns != null) {
                    if (fromResolved != null) {
                        unbounded = (TypeVariable)toTypeVarAssigns.get(var);
                        typeVarAssigns.put((TypeVariable<?>)unbounded, fromResolved);
                        toResolved = fromResolved;
                    } else {
                        typeVarAssigns.put((TypeVariable)toTypeVarAssigns.get(var), fromTypeVarAssigns.get(var));
                    }
                }
                if (fromResolved == null || fromResolved.equals(toResolved) || Any.is(fromResolved) || Any.is(toResolved)) continue;
                if (fromResolved instanceof ParameterizedType && toResolved instanceof ParameterizedType) {
                    if (Types.raw(fromResolved) != Types.raw(toResolved)) {
                        return false;
                    }
                    Type[] fromTypes = ((ParameterizedType)fromResolved).getActualTypeArguments();
                    Type[] toTypes = ((ParameterizedType)toResolved).getActualTypeArguments();
                    for (int i = 0; i < fromTypes.length; ++i) {
                        if (toTypes[i] instanceof TypeVariable && TypeUtils.isAssignable(fromTypes[i], toTypes[i], typeVarAssigns)) {
                            typeVarAssigns.put((TypeVariable)toTypes[i], fromTypes[i]);
                            continue;
                        }
                        if (Any.is(fromTypes[i]) || Any.is(toTypes[i])) continue;
                        return false;
                    }
                    continue;
                }
                return false;
            }
            return true;
        }

        private static Type[] determineBounds(TypeVariable<?> var, Type typeArg, Type resolvedType, Map<TypeVariable<?>, Type> typeVarAssigns) {
            Type[] bounds = null;
            if (resolvedType == null && typeArg == null) {
                typeArg = TypeUtils.unrollVariableAssignments(var, typeVarAssigns, true);
                if (typeArg != null) {
                    bounds = ((TypeVariable)typeArg).getBounds();
                    HashSet<Type> nonObjects = new HashSet<Type>(bounds.length);
                    for (Type t : bounds) {
                        if (Object.class.equals((Object)t)) continue;
                        nonObjects.add(t);
                    }
                    if (nonObjects.isEmpty()) {
                        bounds = null;
                    } else if (nonObjects.size() != bounds.length) {
                        bounds = nonObjects.toArray(new Type[nonObjects.size()]);
                    }
                }
            } else {
                WildcardType wt = null;
                if (resolvedType != null && resolvedType instanceof WildcardType) {
                    wt = (WildcardType)resolvedType;
                } else if (typeArg != null && typeArg instanceof WildcardType) {
                    wt = (WildcardType)typeArg;
                }
                if (wt != null) {
                    bounds = wt.getUpperBounds();
                }
            }
            if (bounds != null) {
                HashSet<Type> actualTypes = new HashSet<Type>(bounds.length);
                HashSet<Type> parentBounds = new HashSet<Type>(Arrays.asList(bounds));
                for (Type b : bounds) {
                    if (b instanceof ParameterizedType) {
                        for (Type t : ((ParameterizedType)b).getActualTypeArguments()) {
                            if (t instanceof TypeVariable) {
                                Type[] subBounds;
                                for (Type s : subBounds = ((TypeVariable)t).getBounds()) {
                                    if (parentBounds.contains(s)) {
                                        actualTypes.add(((ParameterizedType)b).getRawType());
                                        continue;
                                    }
                                    actualTypes.add(b);
                                }
                                continue;
                            }
                            actualTypes.add(b);
                        }
                    } else {
                        actualTypes.add(b);
                    }
                    bounds = actualTypes.toArray(new Type[actualTypes.size()]);
                }
            }
            return bounds;
        }

        private static Type resolveTypeParameters(Type type, Map<TypeVariable<?>, Type> typeVarAssigns) {
            if (!Types.containsTypeVars(type)) {
                return type;
            }
            if (!(type instanceof ParameterizedType)) {
                return type;
            }
            Type[] toParameters = ((ParameterizedType)type).getActualTypeArguments();
            Type[] toParamsResolved = (Type[])Arrays.stream(toParameters).map(param -> {
                Type resolved = param;
                while (resolved instanceof TypeVariable && typeVarAssigns.keySet().contains(resolved) && !((Type)typeVarAssigns.get(resolved)).equals(resolved)) {
                    resolved = (Type)typeVarAssigns.get(resolved);
                }
                return resolved;
            }).toArray(Type[]::new);
            ParameterizedType toTypeArg = TypeUtils.parameterize(Types.raw(type), toParamsResolved);
            return toTypeArg;
        }

        private static Type unrollVariableAssignments(TypeVariable<?> var, Map<TypeVariable<?>, Type> typeVarAssigns) {
            return TypeUtils.unrollVariableAssignments(var, typeVarAssigns, false);
        }

        private static Type unrollVariableAssignments(TypeVariable<?> var, Map<TypeVariable<?>, Type> typeVarAssigns, boolean acceptBounds) {
            Type result;
            block1: {
                while ((result = typeVarAssigns.get(var)) instanceof TypeVariable && !result.equals(var)) {
                    var = (TypeVariable)result;
                }
                if (result != null || !acceptBounds || var.getBounds().length <= 0) break block1;
                result = var;
            }
            return result;
        }

        private static boolean isAssignable(Type type, GenericArrayType toGenericArrayType, Map<TypeVariable<?>, Type> typeVarAssigns) {
            if (type == null || Any.is(type)) {
                return true;
            }
            if (toGenericArrayType == null) {
                return false;
            }
            if (toGenericArrayType.equals(type)) {
                return true;
            }
            Type toComponentType = toGenericArrayType.getGenericComponentType();
            if (type instanceof Class) {
                Class cls = (Class)type;
                return cls.isArray() && TypeUtils.isAssignable(cls.getComponentType(), toComponentType, typeVarAssigns);
            }
            if (type instanceof GenericArrayType) {
                return TypeUtils.isAssignable(((GenericArrayType)type).getGenericComponentType(), toComponentType, typeVarAssigns);
            }
            if (type instanceof WildcardType) {
                for (Type bound : TypeUtils.getImplicitUpperBounds((WildcardType)type)) {
                    if (!TypeUtils.isAssignable(bound, toGenericArrayType)) continue;
                    return true;
                }
                return false;
            }
            if (type instanceof TypeVariable) {
                for (Type bound : TypeUtils.getImplicitBounds((TypeVariable)type)) {
                    if (!TypeUtils.isAssignable(bound, toGenericArrayType)) continue;
                    return true;
                }
                return false;
            }
            if (type instanceof ParameterizedType) {
                return false;
            }
            throw new IllegalStateException("found an unhandled type: " + type);
        }

        private static boolean isAssignable(Type type, WildcardType toWildcardType, Map<TypeVariable<?>, Type> typeVarAssigns) {
            if (type == null || Any.is(type)) {
                return true;
            }
            if (toWildcardType == null) {
                return false;
            }
            if (toWildcardType.equals(type)) {
                return true;
            }
            Type[] toUpperBounds = TypeUtils.getImplicitUpperBounds(toWildcardType);
            Type[] toLowerBounds = TypeUtils.getImplicitLowerBounds(toWildcardType);
            if (type instanceof WildcardType) {
                WildcardType wildcardType = (WildcardType)type;
                Type[] upperBounds = TypeUtils.getImplicitUpperBounds(wildcardType);
                Type[] lowerBounds = TypeUtils.getImplicitLowerBounds(wildcardType);
                for (Type toBound : toUpperBounds) {
                    toBound = TypeUtils.substituteTypeVariables(toBound, typeVarAssigns);
                    for (Type bound : upperBounds) {
                        if (TypeUtils.isAssignable(bound, toBound, typeVarAssigns)) continue;
                        return false;
                    }
                }
                for (Type toBound : toLowerBounds) {
                    toBound = TypeUtils.substituteTypeVariables(toBound, typeVarAssigns);
                    for (Type bound : lowerBounds) {
                        if (TypeUtils.isAssignable(toBound, bound, typeVarAssigns)) continue;
                        return false;
                    }
                }
                return true;
            }
            for (Type toBound : toUpperBounds) {
                if (TypeUtils.isAssignable(type, TypeUtils.substituteTypeVariables(toBound, typeVarAssigns), typeVarAssigns)) continue;
                return false;
            }
            for (Type toBound : toLowerBounds) {
                if (TypeUtils.isAssignable(TypeUtils.substituteTypeVariables(toBound, typeVarAssigns), type, typeVarAssigns)) continue;
                return false;
            }
            return true;
        }

        private static boolean isAssignable(Type type, TypeVariable<?> toTypeVariable, Map<TypeVariable<?>, Type> typeVarAssigns) {
            if (type == null) {
                return true;
            }
            if (toTypeVariable == null) {
                return false;
            }
            if (toTypeVariable.equals(type)) {
                return true;
            }
            if (typeVarAssigns.get(toTypeVariable) == type) {
                return true;
            }
            if (type instanceof TypeVariable) {
                Type[] bounds;
                for (Type bound : bounds = TypeUtils.getImplicitBounds((TypeVariable)type)) {
                    if (!TypeUtils.isAssignable(bound, toTypeVariable, typeVarAssigns)) continue;
                    return true;
                }
                return false;
            }
            if (type instanceof Class || type instanceof ParameterizedType || type instanceof GenericArrayType || type instanceof WildcardType) {
                Type[] toTypeVarBounds;
                for (Type bound : toTypeVarBounds = TypeUtils.getImplicitBounds(toTypeVariable)) {
                    if (TypeUtils.isAssignable(type, bound, typeVarAssigns)) continue;
                    return false;
                }
                if (!Any.is(type)) {
                    typeVarAssigns.put(toTypeVariable, type);
                }
                return true;
            }
            if (Any.is(type)) {
                typeVarAssigns.put(toTypeVariable, new Any(toTypeVariable.getBounds()));
                return true;
            }
            throw new IllegalStateException("found an unhandled type: " + type);
        }

        private static Type substituteTypeVariables(Type type, Map<TypeVariable<?>, Type> typeVarAssigns) {
            if (type instanceof ParameterizedType) {
                return Types.unroll(type, typeVarAssigns);
            }
            if (type instanceof TypeVariable && typeVarAssigns != null) {
                Type replacementType = typeVarAssigns.get(type);
                if (replacementType == null) {
                    throw new IllegalArgumentException("missing assignment type for type variable " + type);
                }
                return replacementType;
            }
            if (type instanceof GenericArrayType && typeVarAssigns != null) {
                GenericArrayType genArrType = (GenericArrayType)type;
                Type replacementType = Types.unroll(genArrType.getGenericComponentType(), typeVarAssigns);
                return new GenericArrayTypeImpl(replacementType);
            }
            return type;
        }

        public static Map<TypeVariable<?>, Type> getTypeArguments(ParameterizedType type) {
            return TypeUtils.getTypeArguments(type, TypeUtils.getRawType(type), null);
        }

        public static Map<TypeVariable<?>, Type> getTypeArguments(Type type, Class<?> toClass) {
            return TypeUtils.getTypeArguments(type, toClass, null);
        }

        private static Map<TypeVariable<?>, Type> getTypeArguments(Type type, Class<?> toClass, Map<TypeVariable<?>, Type> subtypeVarAssigns) {
            if (type instanceof Class) {
                return TypeUtils.getTypeArguments((Class)type, toClass, subtypeVarAssigns);
            }
            if (type instanceof ParameterizedType) {
                return TypeUtils.getTypeArguments((ParameterizedType)type, toClass, subtypeVarAssigns);
            }
            if (type instanceof GenericArrayType) {
                return TypeUtils.getTypeArguments(((GenericArrayType)type).getGenericComponentType(), toClass.isArray() ? toClass.getComponentType() : toClass, subtypeVarAssigns);
            }
            if (type instanceof WildcardType) {
                for (Type bound : TypeUtils.getImplicitUpperBounds((WildcardType)type)) {
                    if (!TypeUtils.isAssignable(bound, toClass)) continue;
                    return TypeUtils.getTypeArguments(bound, toClass, subtypeVarAssigns);
                }
                return null;
            }
            if (type instanceof TypeVariable) {
                for (Type bound : TypeUtils.getImplicitBounds((TypeVariable)type)) {
                    if (!TypeUtils.isAssignable(bound, toClass)) continue;
                    return TypeUtils.getTypeArguments(bound, toClass, subtypeVarAssigns);
                }
                return null;
            }
            throw new IllegalStateException("found an unhandled type: " + type);
        }

        private static Map<TypeVariable<?>, Type> getTypeArguments(ParameterizedType parameterizedType, Class<?> toClass, Map<TypeVariable<?>, Type> subtypeVarAssigns) {
            HashMap<TypeVariable<?>, Type> typeVarAssigns;
            Class<?> cls = TypeUtils.getRawType(parameterizedType);
            if (!TypeUtils.isAssignable(cls, toClass)) {
                return null;
            }
            Type ownerType = parameterizedType.getOwnerType();
            if (ownerType instanceof ParameterizedType) {
                ParameterizedType parameterizedOwnerType = (ParameterizedType)ownerType;
                typeVarAssigns = TypeUtils.getTypeArguments(parameterizedOwnerType, TypeUtils.getRawType(parameterizedOwnerType), subtypeVarAssigns);
            } else {
                typeVarAssigns = subtypeVarAssigns == null ? new HashMap() : new HashMap(subtypeVarAssigns);
            }
            Type[] typeArgs = parameterizedType.getActualTypeArguments();
            TypeVariable<Class<?>>[] typeParams = cls.getTypeParameters();
            for (int i = 0; i < typeParams.length; ++i) {
                Type typeArg = typeArgs[i];
                typeVarAssigns.put(typeParams[i], typeVarAssigns.containsKey(typeArg) ? (Type)typeVarAssigns.get(typeArg) : typeArg);
            }
            if (toClass.equals(cls)) {
                return typeVarAssigns;
            }
            return TypeUtils.getTypeArguments(TypeUtils.getClosestParentType(cls, toClass), toClass, typeVarAssigns);
        }

        private static Map<TypeVariable<?>, Type> getTypeArguments(Class<?> cls, Class<?> toClass, Map<TypeVariable<?>, Type> subtypeVarAssigns) {
            HashMap typeVarAssigns;
            if (!TypeUtils.isAssignable(cls, toClass)) {
                return null;
            }
            if (cls.isPrimitive()) {
                if (toClass.isPrimitive()) {
                    return new HashMap();
                }
                cls = Classes.box(cls);
            }
            HashMap hashMap = typeVarAssigns = subtypeVarAssigns == null ? new HashMap() : new HashMap(subtypeVarAssigns);
            if (toClass.equals(cls)) {
                return typeVarAssigns;
            }
            return TypeUtils.getTypeArguments(TypeUtils.getClosestParentType(cls, toClass), toClass, typeVarAssigns);
        }

        public static Map<TypeVariable<?>, Type> determineTypeArguments(Class<?> cls, ParameterizedType superType) {
            TypeUtils.validateNotNull(cls, "cls is null", new Object[0]);
            TypeUtils.validateNotNull(superType, "superType is null", new Object[0]);
            Class<?> superClass = TypeUtils.getRawType(superType);
            if (!TypeUtils.isAssignable(cls, superClass)) {
                return null;
            }
            if (cls.equals(superClass)) {
                return TypeUtils.getTypeArguments(superType, superClass, null);
            }
            Type midType = TypeUtils.getClosestParentType(cls, superClass);
            if (midType instanceof Class) {
                return TypeUtils.determineTypeArguments((Class)midType, superType);
            }
            ParameterizedType midParameterizedType = (ParameterizedType)midType;
            Class<?> midClass = TypeUtils.getRawType(midParameterizedType);
            Map<TypeVariable<?>, Type> typeVarAssigns = TypeUtils.determineTypeArguments(midClass, superType);
            TypeUtils.mapTypeVariablesToArguments(cls, midParameterizedType, typeVarAssigns);
            return typeVarAssigns;
        }

        private static <T> void mapTypeVariablesToArguments(Class<T> cls, ParameterizedType parameterizedType, Map<TypeVariable<?>, Type> typeVarAssigns) {
            Type ownerType = parameterizedType.getOwnerType();
            if (ownerType instanceof ParameterizedType) {
                TypeUtils.mapTypeVariablesToArguments(cls, (ParameterizedType)ownerType, typeVarAssigns);
            }
            Type[] typeArgs = parameterizedType.getActualTypeArguments();
            TypeVariable<Class<?>>[] typeVars = TypeUtils.getRawType(parameterizedType).getTypeParameters();
            List<TypeVariable<Class<T>>> typeVarList = Arrays.asList(cls.getTypeParameters());
            for (int i = 0; i < typeArgs.length; ++i) {
                TypeVariable<Class<?>> typeVar = typeVars[i];
                Type typeArg = typeArgs[i];
                if (!typeVarList.contains(typeArg) || !typeVarAssigns.containsKey(typeVar)) continue;
                typeVarAssigns.put((TypeVariable)typeArg, typeVarAssigns.get(typeVar));
            }
        }

        private static Type getClosestParentType(Class<?> cls, Class<?> superClass) {
            if (superClass.isInterface()) {
                Type[] interfaceTypes = cls.getGenericInterfaces();
                Type genericInterface = null;
                for (Type midType : interfaceTypes) {
                    Class midClass = null;
                    if (midType instanceof ParameterizedType) {
                        midClass = TypeUtils.getRawType((ParameterizedType)midType);
                    } else if (midType instanceof Class) {
                        midClass = (Class)midType;
                    } else {
                        throw new IllegalStateException("Unexpected generic interface type found: " + midType);
                    }
                    if (!TypeUtils.isAssignable((Type)midClass, superClass) || !TypeUtils.isAssignable(genericInterface, (Type)midClass)) continue;
                    genericInterface = midType;
                }
                if (genericInterface != null) {
                    return genericInterface;
                }
            }
            return cls.getGenericSuperclass();
        }

        public static boolean isInstance(Object value, Type type) {
            if (type == null) {
                return false;
            }
            return value == null ? !(type instanceof Class) || !((Class)type).isPrimitive() : TypeUtils.isAssignable(value.getClass(), type, null);
        }

        public static Type[] normalizeUpperBounds(Type[] bounds) {
            TypeUtils.validateNotNull(bounds, "null value specified for bounds array", new Object[0]);
            if (bounds.length < 2) {
                return bounds;
            }
            HashSet<Type> types = new HashSet<Type>(bounds.length);
            for (Type type1 : bounds) {
                boolean subtypeFound = false;
                for (Type type2 : bounds) {
                    if (type1 == type2 || !TypeUtils.isAssignable(type2, type1, null)) continue;
                    subtypeFound = true;
                    break;
                }
                if (subtypeFound) continue;
                types.add(type1);
            }
            return types.toArray(new Type[types.size()]);
        }

        public static Type[] getImplicitBounds(TypeVariable<?> typeVariable) {
            Type[] typeArray;
            TypeUtils.validateNotNull(typeVariable, "typeVariable is null", new Object[0]);
            Type[] bounds = typeVariable.getBounds();
            if (bounds.length == 0) {
                Type[] typeArray2 = new Type[1];
                typeArray = typeArray2;
                typeArray2[0] = Object.class;
            } else {
                typeArray = TypeUtils.normalizeUpperBounds(bounds);
            }
            return typeArray;
        }

        public static Type[] getImplicitUpperBounds(WildcardType wildcardType) {
            Type[] typeArray;
            TypeUtils.validateNotNull(wildcardType, "wildcardType is null", new Object[0]);
            Type[] bounds = wildcardType.getUpperBounds();
            if (bounds.length == 0) {
                Type[] typeArray2 = new Type[1];
                typeArray = typeArray2;
                typeArray2[0] = Object.class;
            } else {
                typeArray = TypeUtils.normalizeUpperBounds(bounds);
            }
            return typeArray;
        }

        public static Type[] getImplicitLowerBounds(WildcardType wildcardType) {
            Type[] typeArray;
            TypeUtils.validateNotNull(wildcardType, "wildcardType is null", new Object[0]);
            Type[] bounds = wildcardType.getLowerBounds();
            if (bounds.length == 0) {
                Type[] typeArray2 = new Type[1];
                typeArray = typeArray2;
                typeArray2[0] = null;
            } else {
                typeArray = bounds;
            }
            return typeArray;
        }

        public static boolean typesSatisfyVariables(Map<TypeVariable<?>, Type> typeVarAssigns) {
            TypeUtils.validateNotNull(typeVarAssigns, "typeVarAssigns is null", new Object[0]);
            for (Map.Entry<TypeVariable<?>, Type> entry : typeVarAssigns.entrySet()) {
                TypeVariable<?> typeVar = entry.getKey();
                Type type = entry.getValue();
                for (Type bound : TypeUtils.getImplicitBounds(typeVar)) {
                    if (TypeUtils.isAssignable(type, TypeUtils.substituteTypeVariables(bound, typeVarAssigns), typeVarAssigns)) continue;
                    return false;
                }
            }
            return true;
        }

        private static Class<?> getRawType(ParameterizedType parameterizedType) {
            Type rawType = parameterizedType.getRawType();
            if (!(rawType instanceof Class)) {
                throw new IllegalStateException("Wait... What!? Type of rawType: " + rawType);
            }
            return (Class)rawType;
        }

        public static Class<?> getRawType(Type type, Type assigningType) {
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                return TypeUtils.getRawType((ParameterizedType)type);
            }
            if (type instanceof TypeVariable) {
                if (assigningType == null) {
                    return null;
                }
                Object genericDeclaration = ((TypeVariable)type).getGenericDeclaration();
                if (!(genericDeclaration instanceof Class)) {
                    return null;
                }
                Map<TypeVariable<?>, Type> typeVarAssigns = TypeUtils.getTypeArguments(assigningType, (Class)genericDeclaration);
                if (typeVarAssigns == null) {
                    return null;
                }
                Type typeArgument = typeVarAssigns.get(type);
                if (typeArgument == null) {
                    return null;
                }
                return TypeUtils.getRawType(typeArgument, assigningType);
            }
            if (type instanceof GenericArrayType) {
                Class<?> rawComponentType = TypeUtils.getRawType(((GenericArrayType)type).getGenericComponentType(), assigningType);
                return Classes.array(rawComponentType);
            }
            if (type instanceof WildcardType) {
                return null;
            }
            throw new IllegalArgumentException("unknown type: " + type);
        }

        public static boolean isArrayType(Type type) {
            return type instanceof GenericArrayType || type instanceof Class && ((Class)type).isArray();
        }

        public static Type getArrayComponentType(Type type) {
            if (type instanceof Class) {
                Class clazz = (Class)type;
                return clazz.isArray() ? clazz.getComponentType() : null;
            }
            if (type instanceof GenericArrayType) {
                return ((GenericArrayType)type).getGenericComponentType();
            }
            return null;
        }

        public static Type unrollVariables(Map<TypeVariable<?>, Type> typeArguments, Type type) {
            return TypeUtils.unrollVariables(typeArguments, type, true);
        }

        public static Type unrollVariables(Map<TypeVariable<?>, Type> typeArguments, Type type, boolean followTypeVars) {
            if (typeArguments == null) {
                typeArguments = Collections.emptyMap();
            }
            if (TypeUtils.containsTypeVariables(type)) {
                if (type instanceof TypeVariable) {
                    if (followTypeVars) {
                        return TypeUtils.unrollVariables(typeArguments, typeArguments.get(type), followTypeVars);
                    }
                    return typeArguments.getOrDefault(type, type);
                }
                if (type instanceof ParameterizedType) {
                    ParameterizedType p = (ParameterizedType)type;
                    Map<TypeVariable<?>, Type> parameterizedTypeArguments = p.getOwnerType() == null ? typeArguments : new HashMap(typeArguments);
                    Type[] args = p.getActualTypeArguments();
                    Type[] resolved = new Type[args.length];
                    for (int i = 0; i < args.length; ++i) {
                        Type unrolled = TypeUtils.unrollVariables(parameterizedTypeArguments, args[i], followTypeVars);
                        resolved[i] = unrolled != null ? unrolled : args[i];
                    }
                    return TypeUtils.parameterizeWithOwner(p.getOwnerType(), (Class)p.getRawType(), resolved);
                }
                if (type instanceof WildcardType) {
                    WildcardType wild = (WildcardType)type;
                    return TypeUtils.wildcardType().withUpperBounds(TypeUtils.unrollBounds(typeArguments, wild.getUpperBounds())).withLowerBounds(TypeUtils.unrollBounds(typeArguments, wild.getLowerBounds())).build();
                }
                if (type instanceof GenericArrayType) {
                    GenericArrayType genArrType = (GenericArrayType)type;
                    Type componentType = genArrType.getGenericComponentType();
                    Type unrolledComponent = TypeUtils.unrollVariables(typeArguments, componentType, followTypeVars);
                    return Types.array(unrolledComponent);
                }
            }
            return type;
        }

        private static Type[] unrollBounds(Map<TypeVariable<?>, Type> typeArguments, Type[] bounds) {
            ArrayList<Type> result = new ArrayList<Type>();
            for (Type bound : bounds) {
                Type unrolled = TypeUtils.unrollVariables(typeArguments, bound);
                if (unrolled == null) continue;
                result.add(unrolled);
            }
            return result.toArray(new Type[result.size()]);
        }

        public static boolean containsTypeVariables(Type type) {
            if (type instanceof TypeVariable) {
                return true;
            }
            if (type instanceof Class) {
                return ((Class)type).getTypeParameters().length > 0;
            }
            if (type instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)type;
                for (Type arg : pType.getActualTypeArguments()) {
                    if (!TypeUtils.containsTypeVariables(arg)) continue;
                    return true;
                }
                return false;
            }
            if (type instanceof WildcardType) {
                WildcardType wild = (WildcardType)type;
                return TypeUtils.containsTypeVariables(TypeUtils.getImplicitLowerBounds(wild)[0]) || TypeUtils.containsTypeVariables(TypeUtils.getImplicitUpperBounds(wild)[0]);
            }
            if (type instanceof GenericArrayType) {
                GenericArrayType genArrType = (GenericArrayType)type;
                return TypeUtils.containsTypeVariables(genArrType.getGenericComponentType());
            }
            return false;
        }

        public static final ParameterizedType parameterize(Class<?> raw, Type ... typeArguments) {
            return TypeUtils.parameterizeWithOwner(null, raw, typeArguments);
        }

        public static final ParameterizedType parameterize(Class<?> raw, Map<TypeVariable<?>, Type> typeArgMappings) {
            TypeUtils.validateNotNull(raw, "raw class is null", new Object[0]);
            TypeUtils.validateNotNull(typeArgMappings, "typeArgMappings is null", new Object[0]);
            return TypeUtils.parameterizeWithOwner(null, raw, TypeUtils.extractTypeArgumentsFrom(typeArgMappings, raw.getTypeParameters()));
        }

        public static final ParameterizedType parameterizeWithOwner(Type owner, Class<?> raw, Type ... typeArguments) {
            Type useOwner;
            TypeUtils.validateNotNull(raw, "raw class is null", new Object[0]);
            if (raw.getEnclosingClass() == null) {
                TypeUtils.validateIsTrue(owner == null, "no owner allowed for top-level %s", raw);
                useOwner = null;
            } else if (owner == null) {
                useOwner = raw.getEnclosingClass();
            } else {
                TypeUtils.validateIsTrue(TypeUtils.isAssignable(owner, raw.getEnclosingClass()), "%s is invalid owner type for parameterized %s", owner, raw);
                useOwner = owner;
            }
            TypeUtils.validateNoNullElements(typeArguments, "null type argument at index %s", new Object[0]);
            TypeUtils.validateIsTrue(raw.getTypeParameters().length == typeArguments.length, "invalid number of type parameters specified: expected %s, got %s", raw.getTypeParameters().length, typeArguments.length);
            return new ParameterizedTypeImpl(raw, useOwner, typeArguments);
        }

        public static final ParameterizedType parameterizeWithOwner(Type owner, Class<?> raw, Map<TypeVariable<?>, Type> typeArgMappings) {
            TypeUtils.validateNotNull(raw, "raw class is null", new Object[0]);
            TypeUtils.validateNotNull(typeArgMappings, "typeArgMappings is null", new Object[0]);
            return TypeUtils.parameterizeWithOwner(owner, raw, TypeUtils.extractTypeArgumentsFrom(typeArgMappings, raw.getTypeParameters()));
        }

        private static Type[] extractTypeArgumentsFrom(Map<TypeVariable<?>, Type> mappings, TypeVariable<?>[] variables) {
            Type[] result = new Type[variables.length];
            int index = 0;
            for (TypeVariable<?> var : variables) {
                TypeUtils.validateIsTrue(mappings.containsKey(var), "missing argument mapping for %s", TypeUtils.toString(var));
                result[index++] = mappings.get(var);
            }
            return result;
        }

        public static WildcardTypeBuilder wildcardType() {
            return new WildcardTypeBuilder();
        }

        public static GenericArrayType genericArrayType(Type componentType) {
            return new GenericArrayTypeImpl(TypeUtils.validateNotNull(componentType, "componentType is null", new Object[0]));
        }

        public static boolean equals(Type t1, Type t2) {
            if (Objects.equals(t1, t2)) {
                return true;
            }
            if (t1 instanceof ParameterizedType) {
                return TypeUtils.equals((ParameterizedType)t1, t2);
            }
            if (t1 instanceof GenericArrayType) {
                return TypeUtils.equals((GenericArrayType)t1, t2);
            }
            if (t1 instanceof WildcardType) {
                return TypeUtils.equals((WildcardType)t1, t2);
            }
            return false;
        }

        private static boolean equals(ParameterizedType p, Type t) {
            if (t instanceof ParameterizedType) {
                ParameterizedType other = (ParameterizedType)t;
                if (TypeUtils.equals(p.getRawType(), other.getRawType()) && TypeUtils.equals(p.getOwnerType(), other.getOwnerType())) {
                    return TypeUtils.equals(p.getActualTypeArguments(), other.getActualTypeArguments());
                }
            }
            return false;
        }

        private static boolean equals(GenericArrayType a, Type t) {
            return t instanceof GenericArrayType && TypeUtils.equals(a.getGenericComponentType(), ((GenericArrayType)t).getGenericComponentType());
        }

        private static boolean equals(WildcardType w, Type t) {
            if (t instanceof WildcardType) {
                WildcardType other = (WildcardType)t;
                return TypeUtils.equals(TypeUtils.getImplicitLowerBounds(w), TypeUtils.getImplicitLowerBounds(other)) && TypeUtils.equals(TypeUtils.getImplicitUpperBounds(w), TypeUtils.getImplicitUpperBounds(other));
            }
            return false;
        }

        private static boolean equals(Type[] t1, Type[] t2) {
            if (t1.length == t2.length) {
                for (int i = 0; i < t1.length; ++i) {
                    if (TypeUtils.equals(t1[i], t2[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public static String toString(Type type) {
            return TypeUtils.toString(type, new HashSet<Type>());
        }

        private static String toString(Type type, Set<Type> done) {
            TypeUtils.validateNotNull(type);
            if (type instanceof Class) {
                return TypeUtils.classToString((Class)type, done);
            }
            if (Any.is(type)) {
                return type.toString();
            }
            if (type instanceof ParameterizedType) {
                return TypeUtils.parameterizedTypeToString((ParameterizedType)type, done);
            }
            if (type instanceof WildcardType) {
                return TypeUtils.wildcardTypeToString((WildcardType)type, done);
            }
            if (type instanceof TypeVariable) {
                return TypeUtils.typeVariableToString((TypeVariable)type, done);
            }
            if (type instanceof GenericArrayType) {
                return TypeUtils.genericArrayTypeToString((GenericArrayType)type);
            }
            if (type instanceof CaptureType) {
                return type.toString();
            }
            throw new IllegalArgumentException("Unknown generic type: " + type.getClass().getName());
        }

        public static String toLongString(TypeVariable<?> var) {
            StringBuilder buf;
            block5: {
                TypeUtils.validateNotNull(var, "var is null", new Object[0]);
                buf = new StringBuilder();
                Object d = var.getGenericDeclaration();
                if (d instanceof Class) {
                    Class<?> c = (Class<?>)d;
                    while (true) {
                        if (c.getEnclosingClass() == null) {
                            buf.insert(0, c.getName());
                            break block5;
                        }
                        buf.insert(0, c.getSimpleName()).insert(0, '.');
                        c = c.getEnclosingClass();
                    }
                }
                if (d instanceof Type) {
                    buf.append(TypeUtils.toString((Type)d));
                } else {
                    buf.append(d);
                }
            }
            return buf.append(':').append(TypeUtils.typeVariableToString(var, new HashSet<Type>())).toString();
        }

        private static String classToString(Class<?> c, Set<Type> done) {
            StringBuilder buf = new StringBuilder();
            if (c.getEnclosingClass() != null) {
                buf.append(TypeUtils.classToString(c.getEnclosingClass(), done)).append('.').append(c.getSimpleName());
            } else {
                buf.append(c.getName());
            }
            if (c.getTypeParameters().length > 0) {
                buf.append('<');
                TypeUtils.appendAllTo(buf, ", ", done, c.getTypeParameters());
                buf.append('>');
            }
            return buf.toString();
        }

        private static String typeVariableToString(TypeVariable<?> v, Set<Type> done) {
            StringBuilder buf = new StringBuilder(v.getName());
            if (done.contains(v)) {
                return buf.toString();
            }
            done.add(v);
            Type[] bounds = v.getBounds();
            if (!(bounds.length <= 0 || bounds.length == 1 && Object.class.equals((Object)bounds[0]))) {
                buf.append(" extends ");
                TypeUtils.appendAllTo(buf, " & ", done, v.getBounds());
            }
            return buf.toString();
        }

        private static String parameterizedTypeToString(ParameterizedType p, Set<Type> done) {
            StringBuilder buf = new StringBuilder();
            Type useOwner = p.getOwnerType();
            Class raw = (Class)p.getRawType();
            Type[] typeArguments = p.getActualTypeArguments();
            if (useOwner == null) {
                buf.append(raw.getName());
            } else {
                if (useOwner instanceof Class) {
                    buf.append(((Class)useOwner).getName());
                } else {
                    buf.append(useOwner.toString());
                }
                buf.append('.').append(raw.getSimpleName());
            }
            TypeUtils.appendAllTo(buf.append('<'), ", ", done, typeArguments).append('>');
            return buf.toString();
        }

        private static String wildcardTypeToString(WildcardType w, Set<Type> done) {
            StringBuilder buf = new StringBuilder().append('?');
            if (done.contains(w)) {
                return buf.toString();
            }
            done.add(w);
            Type[] lowerBounds = w.getLowerBounds();
            Type[] upperBounds = w.getUpperBounds();
            if (lowerBounds.length > 1 || lowerBounds.length == 1 && lowerBounds[0] != null) {
                TypeUtils.appendAllTo(buf.append(" super "), " & ", done, lowerBounds);
            } else if (upperBounds.length > 1 || upperBounds.length == 1 && !Object.class.equals((Object)upperBounds[0])) {
                TypeUtils.appendAllTo(buf.append(" extends "), " & ", done, upperBounds);
            }
            return buf.toString();
        }

        private static String genericArrayTypeToString(GenericArrayType g) {
            return String.format("%s[]", TypeUtils.toString(g.getGenericComponentType()));
        }

        private static StringBuilder appendAllTo(StringBuilder buf, String sep, Set<Type> done, Type ... types) {
            TypeUtils.validateNotEmpty(TypeUtils.validateNoNullElements(types));
            if (types.length > 0) {
                buf.append(TypeUtils.toString(types[0], done));
                for (int i = 1; i < types.length; ++i) {
                    buf.append(sep).append(TypeUtils.toString(types[i], done));
                }
            }
            return buf;
        }

        private static <T> T validateNotNull(T object) {
            return TypeUtils.validateNotNull(object, DEFAULT_IS_NULL_EX_MESSAGE, new Object[0]);
        }

        private static <T> T validateNotNull(T object, String message, Object ... values) {
            if (object == null) {
                throw new NullPointerException(String.format(message, values));
            }
            return object;
        }

        private static void validateIsTrue(boolean expression, String message, Object ... values) {
            if (!expression) {
                throw new IllegalArgumentException(String.format(message, values));
            }
        }

        private static <T> T[] validateNoNullElements(T[] array) {
            return TypeUtils.validateNoNullElements(array, DEFAULT_NO_NULL_ELEMENTS_ARRAY_EX_MESSAGE, new Object[0]);
        }

        private static <T> T[] validateNoNullElements(T[] array, String message, Object ... values) {
            TypeUtils.validateNotNull(array);
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != null) continue;
                Object[] values2 = new Object[values.length + 1];
                System.arraycopy(values, 0, values2, 0, values.length);
                values2[values.length] = i;
                throw new IllegalArgumentException(String.format(message, values2));
            }
            return array;
        }

        private static <T> T[] validateNotEmpty(T[] array) {
            return TypeUtils.validateNotEmpty(array, DEFAULT_NOT_EMPTY_ARRAY_EX_MESSAGE, new Object[0]);
        }

        private static <T> T[] validateNotEmpty(T[] array, String message, Object ... values) {
            if (array == null) {
                throw new NullPointerException(String.format(message, values));
            }
            if (array.length == 0) {
                throw new IllegalArgumentException(String.format(message, values));
            }
            return array;
        }

        private static final class WildcardTypeImpl
        implements WildcardType {
            private static final Type[] EMPTY_BOUNDS = new Type[0];
            private final Type[] upperBounds;
            private final Type[] lowerBounds;

            private WildcardTypeImpl(Type upperBound, Type lowerBound) {
                Type[] typeArray;
                Type[] typeArray2;
                if (upperBound == null) {
                    typeArray2 = null;
                } else {
                    Type[] typeArray3 = new Type[1];
                    typeArray2 = typeArray3;
                    typeArray3[0] = upperBound;
                }
                if (lowerBound == null) {
                    typeArray = null;
                } else {
                    Type[] typeArray4 = new Type[1];
                    typeArray = typeArray4;
                    typeArray4[0] = lowerBound;
                }
                this(typeArray2, typeArray);
            }

            private WildcardTypeImpl(Type[] upperBounds, Type[] lowerBounds) {
                this.upperBounds = upperBounds == null ? EMPTY_BOUNDS : upperBounds;
                this.lowerBounds = lowerBounds == null ? EMPTY_BOUNDS : lowerBounds;
            }

            @Override
            public Type[] getUpperBounds() {
                return (Type[])this.upperBounds.clone();
            }

            @Override
            public Type[] getLowerBounds() {
                return (Type[])this.lowerBounds.clone();
            }

            public String toString() {
                return TypeUtils.toString(this);
            }

            public boolean equals(Object obj) {
                return obj == this || obj instanceof WildcardType && TypeUtils.equals(this, (Type)((WildcardType)obj));
            }

            public int hashCode() {
                int result = 18688;
                result |= Arrays.hashCode(this.upperBounds);
                result <<= 8;
                return result |= Arrays.hashCode(this.lowerBounds);
            }
        }

        private static final class ParameterizedTypeImpl
        implements ParameterizedType {
            private final Class<?> raw;
            private final Type useOwner;
            private final Type[] typeArguments;

            private ParameterizedTypeImpl(Class<?> raw, Type useOwner, Type[] typeArguments) {
                this.raw = raw;
                this.useOwner = useOwner;
                this.typeArguments = typeArguments;
            }

            @Override
            public Type getRawType() {
                return this.raw;
            }

            @Override
            public Type getOwnerType() {
                return this.useOwner;
            }

            @Override
            public Type[] getActualTypeArguments() {
                return (Type[])this.typeArguments.clone();
            }

            public String toString() {
                return TypeUtils.toString(this);
            }

            public boolean equals(Object obj) {
                return obj == this || obj instanceof ParameterizedType && TypeUtils.equals(this, (Type)((ParameterizedType)obj));
            }

            public int hashCode() {
                return (this.useOwner == null ? 0 : this.useOwner.hashCode()) ^ Arrays.asList(this.typeArguments).hashCode() ^ this.raw.hashCode();
            }
        }

        private static final class GenericArrayTypeImpl
        implements GenericArrayType {
            private final Type componentType;

            private GenericArrayTypeImpl(Type componentType) {
                this.componentType = componentType;
            }

            @Override
            public Type getGenericComponentType() {
                return this.componentType;
            }

            public String toString() {
                return TypeUtils.toString(this);
            }

            public boolean equals(Object obj) {
                return obj == this || obj instanceof GenericArrayType && TypeUtils.equals(this, (Type)((GenericArrayType)obj));
            }

            public int hashCode() {
                int result = 1072;
                return result |= this.componentType.hashCode();
            }
        }

        private static class WildcardTypeBuilder {
            private Type[] upperBounds;
            private Type[] lowerBounds;

            private WildcardTypeBuilder() {
            }

            public WildcardTypeBuilder withUpperBounds(Type ... bounds) {
                this.upperBounds = bounds;
                return this;
            }

            public WildcardTypeBuilder withLowerBounds(Type ... bounds) {
                this.lowerBounds = bounds;
                return this;
            }

            public WildcardType build() {
                return new WildcardTypeImpl(this.upperBounds, this.lowerBounds);
            }
        }
    }
}

