/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.concurrent;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.scijava.concurrent.Parallelization;

@Fork(value=1)
@Warmup(iterations=5, time=200, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=5, time=200, timeUnit=TimeUnit.MILLISECONDS)
@State(value=Scope.Benchmark)
@BenchmarkMode(value={Mode.AverageTime})
public class ParallelizationBenchmark {
    private final int[][][] image = ParallelizationBenchmark.generateRandomImage(42L, 100, 500, 500);

    private static long calculateSum(int[][][] image) {
        List slices = Arrays.asList(image);
        AtomicLong result = new AtomicLong();
        Parallelization.getTaskExecutor().forEach(slices, slice -> result.addAndGet(ParallelizationBenchmark.calculateSum(slice)));
        return result.get();
    }

    private static long calculateSum(int[][] slice) {
        List rows = Arrays.asList(slice);
        AtomicLong result = new AtomicLong();
        Parallelization.getTaskExecutor().forEach(rows, row -> result.addAndGet(ParallelizationBenchmark.simpleCalculateSum(row)));
        return result.get();
    }

    private static int[][][] generateRandomImage(long seed, int x, int y, int z) {
        Random r = new Random(seed);
        int[][][] arr = new int[x][y][z];
        for (int i = 0; i < arr.length; ++i) {
            int j = 0;
            while (i < arr[i].length) {
                for (int k = 0; k < arr[i][j].length; ++k) {
                    arr[i][j][k] = r.nextInt();
                }
                ++j;
            }
        }
        return arr;
    }

    private static long simpleCalculateSum(int[][][] image) {
        long result = 0L;
        for (int[][] slice : image) {
            result += ParallelizationBenchmark.simpleCalculateSum(slice);
        }
        return result;
    }

    private static long simpleCalculateSum(int[][] slice) {
        long result = 0L;
        for (int[] row : slice) {
            result += ParallelizationBenchmark.simpleCalculateSum(row);
        }
        return result;
    }

    private static long simpleCalculateSum(int[] row) {
        long result = 0L;
        for (int pixel : row) {
            result += (long)pixel;
        }
        return result;
    }

    @Benchmark
    public Long fixedThreadPool() {
        ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        Long sum = (Long)Parallelization.runWithExecutor((ExecutorService)executor, () -> ParallelizationBenchmark.calculateSum(this.image));
        executor.shutdown();
        return sum;
    }

    @Benchmark
    public Long twoThreadsForkJoinPool() {
        ForkJoinPool executor = new ForkJoinPool(2);
        Long sum = (Long)Parallelization.runWithExecutor((ExecutorService)executor, () -> ParallelizationBenchmark.calculateSum(this.image));
        executor.shutdown();
        return sum;
    }

    @Benchmark
    public Long multiThreaded() {
        return (Long)Parallelization.runMultiThreaded(() -> ParallelizationBenchmark.calculateSum(this.image));
    }

    @Benchmark
    public Long singleThreaded() {
        return (Long)Parallelization.runSingleThreaded(() -> ParallelizationBenchmark.calculateSum(this.image));
    }

    @Benchmark
    public Long defaultBehavior() {
        return ParallelizationBenchmark.calculateSum(this.image);
    }

    @Benchmark
    public Long singleThreadedBaseline() {
        return ParallelizationBenchmark.calculateSum(this.image);
    }

    public static void main(String ... args) throws RunnerException {
        Options options = new OptionsBuilder().include(ParallelizationBenchmark.class.getName()).build();
        new Runner(options).run();
    }
}

