/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.concurrent;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.scijava.concurrent.Parallelization;
import org.scijava.concurrent.TaskExecutor;
import org.scijava.concurrent.TaskExecutors;

public class ParallelizationTest {
    @Test
    public void testSingleThreaded() {
        int parallelism = (Integer)Parallelization.runSingleThreaded(() -> Parallelization.getTaskExecutor().getParallelism());
        Assertions.assertEquals((int)1, (int)parallelism);
    }

    @Test
    public void testSingleThreadedWithRunnable() {
        AtomicInteger parallelism = new AtomicInteger();
        Parallelization.runSingleThreaded(() -> parallelism.set(Parallelization.getTaskExecutor().getParallelism()));
        Assertions.assertEquals((int)1, (int)parallelism.get());
    }

    @Test
    public void testMultiThreaded() {
        Assumptions.assumeTrue((ForkJoinPool.commonPool().getParallelism() > 1 ? 1 : 0) != 0);
        int parallelism = (Integer)Parallelization.runMultiThreaded(() -> Parallelization.getTaskExecutor().getParallelism());
        Assertions.assertTrue((parallelism > 1 ? 1 : 0) != 0);
    }

    @Test
    public void testWithExecutor() {
        ExecutorService executor = Executors.newFixedThreadPool(2);
        ExecutorService result = (ExecutorService)Parallelization.runWithExecutor((ExecutorService)executor, () -> Parallelization.getTaskExecutor().getExecutorService());
        Assertions.assertEquals((Object)executor, (Object)result);
    }

    @Test
    public void testSetExecutorService() {
        TaskExecutor outside = Parallelization.getTaskExecutor();
        TaskExecutor inside = TaskExecutors.forExecutorService((ExecutorService)new TaskExecutors.SequentialExecutorService());
        try (Parallelization.Frame frame = Parallelization.setExecutorRequiresReset((TaskExecutor)inside);){
            Assertions.assertSame((Object)inside, (Object)Parallelization.getTaskExecutor());
        }
        Assertions.assertSame((Object)outside, (Object)Parallelization.getTaskExecutor());
    }
}

