/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.concurrent;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.scijava.concurrent.Parallelization;
import org.scijava.concurrent.TaskExecutor;

public final class TaskExecutors {
    private static final TaskExecutor FORK_JOIN_TASK_EXECUTOR = new DefaultTaskExecutor(new ForkJoinExecutorService());

    private TaskExecutors() {
    }

    public static TaskExecutor singleThreaded() {
        return SequentialTaskExecutor.getInstance();
    }

    public static TaskExecutor multiThreaded() {
        return FORK_JOIN_TASK_EXECUTOR;
    }

    public static TaskExecutor numThreads(int numThreads) {
        numThreads = Math.max(1, numThreads);
        return TaskExecutors.forExecutorService(new ForkJoinPool(numThreads));
    }

    public static TaskExecutor forExecutorService(ExecutorService executorService) {
        return new DefaultTaskExecutor(executorService);
    }

    public static TaskExecutor forExecutorServiceAndNumThreads(ExecutorService executorService, final int numThreads) {
        return new DefaultTaskExecutor(executorService){

            @Override
            public int getParallelism() {
                return numThreads;
            }
        };
    }

    public static TaskExecutor forExecutorServiceAndNumTasks(ExecutorService executorService, final int numTasks) {
        return new DefaultTaskExecutor(executorService){

            @Override
            public int suggestNumberOfTasks() {
                return numTasks;
            }
        };
    }

    public static TaskExecutor fixedThreadPool(int numThreads) {
        ThreadFactory threadFactory = TaskExecutors.threadFactory(() -> TaskExecutors.singleThreaded());
        return TaskExecutors.forExecutorService(Executors.newFixedThreadPool(numThreads, threadFactory));
    }

    public static TaskExecutor nestedFixedThreadPool(int numThreads, int numSubThreads) {
        ThreadFactory threadFactory = TaskExecutors.threadFactory(() -> TaskExecutors.fixedThreadPool(numSubThreads));
        return TaskExecutors.forExecutorService(Executors.newFixedThreadPool(numThreads, threadFactory));
    }

    public static ThreadFactory threadFactory(Supplier<TaskExecutor> taskExecutorFactory) {
        return TaskExecutors.applyTaskExecutorToThreadFactory(taskExecutorFactory, Executors.defaultThreadFactory());
    }

    public static ThreadFactory applyTaskExecutorToThreadFactory(Supplier<TaskExecutor> taskExecutorFactory, ThreadFactory threadFactory) {
        return runnable -> threadFactory.newThread(() -> TaskExecutors.lambda$applyTaskExecutorToThreadFactory$2((Supplier)taskExecutorFactory, runnable));
    }

    private static /* synthetic */ void lambda$applyTaskExecutorToThreadFactory$2(Supplier taskExecutorFactory, Runnable runnable) {
        try (TaskExecutor taskExecutor = (TaskExecutor)taskExecutorFactory.get();){
            Parallelization.runWithExecutor(taskExecutor, runnable);
        }
    }

    static class SequentialTaskExecutor
    implements TaskExecutor {
        private static final SequentialTaskExecutor INSTANCE = new SequentialTaskExecutor();
        private final ExecutorService executorService = new SequentialExecutorService();

        private SequentialTaskExecutor() {
        }

        public static TaskExecutor getInstance() {
            return INSTANCE;
        }

        @Override
        public ExecutorService getExecutorService() {
            return this.executorService;
        }

        @Override
        public int suggestNumberOfTasks() {
            return 1;
        }

        @Override
        public int getParallelism() {
            return 1;
        }

        @Override
        public void runAll(List<Runnable> tasks) {
            for (Runnable task : tasks) {
                task.run();
            }
        }

        @Override
        public <T> void forEach(List<? extends T> parameters, Consumer<? super T> task) {
            for (T value : parameters) {
                task.accept(value);
            }
        }

        @Override
        public <T, R> List<R> forEachApply(List<? extends T> parameters, Function<? super T, ? extends R> task) {
            ArrayList<R> results = new ArrayList<R>(parameters.size());
            for (T value : parameters) {
                R result = task.apply(value);
                results.add(result);
            }
            return results;
        }

        @Override
        public void close() {
        }
    }

    static class SequentialExecutorService
    extends AbstractExecutorService {
        SequentialExecutorService() {
        }

        public int getParallelism() {
            return 1;
        }

        @Override
        public void shutdown() {
        }

        @Override
        public List<Runnable> shutdownNow() {
            return Collections.emptyList();
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public boolean isTerminated() {
            return true;
        }

        @Override
        public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
            return true;
        }

        @Override
        public void execute(Runnable runnable) {
            runnable.run();
        }
    }

    static class ForkJoinExecutorService
    extends AbstractExecutorService {
        ForkJoinExecutorService() {
        }

        public int getParallelism() {
            return this.getPool().getParallelism();
        }

        @Override
        public void shutdown() {
        }

        @Override
        public List<Runnable> shutdownNow() {
            throw new UnsupportedOperationException("ForkJoinExecutorService, shutdownNow is not implemented.");
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public boolean isTerminated() {
            return false;
        }

        @Override
        public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
            throw new UnsupportedOperationException("ForkJoinExecutorService, awaitTermination is not implemented.");
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection) throws InterruptedException {
            ArrayList<ForkJoinTask<T>> futures = new ArrayList<ForkJoinTask<T>>(collection.size());
            for (Callable<T> callable : collection) {
                futures.add(ForkJoinTask.adapt(callable));
            }
            ForkJoinTask.invokeAll(futures);
            return Collections.unmodifiableList(futures);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) throws InterruptedException {
            throw new UnsupportedOperationException("ForkJoinExecutorService, invokeAll with timeout is not implemented.");
        }

        @Override
        public Future<?> submit(Runnable runnable) {
            return ForkJoinTask.adapt(runnable).fork();
        }

        @Override
        public <T> Future<T> submit(Runnable runnable, T t) {
            return ForkJoinTask.adapt(runnable, t).fork();
        }

        @Override
        public <T> Future<T> submit(Callable<T> callable) {
            return ForkJoinTask.adapt(callable).fork();
        }

        @Override
        public void execute(Runnable runnable) {
            ForkJoinTask.adapt(runnable).fork();
        }

        private ForkJoinPool getPool() {
            ForkJoinPool pool = ForkJoinTask.getPool();
            return pool != null ? pool : ForkJoinPool.commonPool();
        }
    }

    static class DefaultTaskExecutor
    implements TaskExecutor {
        private final ExecutorService executorService;

        public DefaultTaskExecutor(ExecutorService executorService) {
            this.executorService = executorService;
        }

        @Override
        public ExecutorService getExecutorService() {
            return this.executorService;
        }

        @Override
        public int getParallelism() {
            if (this.executorService instanceof ForkJoinPool) {
                return ((ForkJoinPool)this.executorService).getParallelism();
            }
            if (this.executorService instanceof ThreadPoolExecutor) {
                return Math.max(1, ((ThreadPoolExecutor)this.executorService).getCorePoolSize());
            }
            if (this.executorService instanceof ForkJoinExecutorService) {
                return ((ForkJoinExecutorService)this.executorService).getParallelism();
            }
            if (this.executorService instanceof SequentialExecutorService) {
                return ((SequentialExecutorService)this.executorService).getParallelism();
            }
            return Runtime.getRuntime().availableProcessors();
        }

        @Override
        public void runAll(List<Runnable> tasks) {
            ArrayList<Callable<Object>> callables = new ArrayList<Callable<Object>>(tasks.size());
            for (Runnable task : tasks) {
                callables.add(Executors.callable(task));
            }
            this.invokeAllIgnoreResults(callables);
        }

        @Override
        public int suggestNumberOfTasks() {
            int parallelism = this.getParallelism();
            return parallelism == 1 ? 1 : (int)Math.min((long)parallelism * 4L, Integer.MAX_VALUE);
        }

        @Override
        public <T> void forEach(List<? extends T> parameters, Consumer<? super T> task) {
            ArrayList<Callable<Object>> callables = new ArrayList<Callable<Object>>(parameters.size());
            for (Object parameter : parameters) {
                callables.add(() -> {
                    task.accept((Object)parameter);
                    return null;
                });
            }
            this.invokeAllIgnoreResults(callables);
        }

        @Override
        public <T, R> List<R> forEachApply(List<? extends T> parameters, Function<? super T, ? extends R> task) {
            ArrayList<Callable<Object>> callables = new ArrayList<Callable<Object>>(parameters.size());
            for (Object parameter : parameters) {
                callables.add(() -> task.apply((Object)parameter));
            }
            try {
                List futures = this.executorService.invokeAll(callables);
                ArrayList results = new ArrayList(futures.size());
                for (Future future : futures) {
                    results.add(future.get());
                }
                return results;
            }
            catch (InterruptedException | ExecutionException e) {
                throw this.unwrapExecutionException(e);
            }
        }

        private void invokeAllIgnoreResults(List<Callable<Object>> callables) {
            try {
                List<Future<Object>> futures = this.executorService.invokeAll(callables);
                for (Future<Object> future : futures) {
                    future.get();
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw this.unwrapExecutionException(e);
            }
        }

        private RuntimeException unwrapExecutionException(Throwable e) {
            if (e instanceof ExecutionException) {
                Throwable cause = e.getCause();
                cause.setStackTrace(this.concatenate(cause.getStackTrace(), e.getStackTrace()));
                e = cause;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            return new RuntimeException(e);
        }

        private <T> T[] concatenate(T[] a, T[] b) {
            int aLen = a.length;
            int bLen = b.length;
            Object[] c = (Object[])Array.newInstance(a.getClass().getComponentType(), aLen + bLen);
            System.arraycopy(a, 0, c, 0, aLen);
            System.arraycopy(b, 0, c, aLen, bLen);
            return c;
        }

        @Override
        public void close() {
            this.executorService.shutdown();
        }
    }
}

