/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.config.logback;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.config.AbstractLoggingTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogbackTest
extends AbstractLoggingTest {
    private Logger log;

    @Before
    public void setUp() {
        this.log = LoggerFactory.getLogger(LogbackTest.class);
    }

    @Test
    public void testError() {
        String error = "Guru Meditation";
        this.log.error("Guru Meditation");
        Assert.assertEquals((Object)"", (Object)LogbackTest.stdout());
        Assert.assertEquals((Object)"[ERROR] Guru Meditation\n", (Object)LogbackTest.stderr());
    }

    @Test
    public void testWarn() {
        String warning = "Watch out for snakes!";
        this.log.warn("Watch out for snakes!");
        Assert.assertEquals((Object)"", (Object)LogbackTest.stdout());
        Assert.assertEquals((Object)"[WARN] Watch out for snakes!\n", (Object)LogbackTest.stderr());
    }

    @Test
    public void testInfo() {
        String info = "Dogs are bigger than cats. But not all the time.";
        this.log.info("Dogs are bigger than cats. But not all the time.");
        Assert.assertEquals((Object)"Dogs are bigger than cats. But not all the time.\n", (Object)LogbackTest.stdout());
        Assert.assertEquals((Object)"", (Object)LogbackTest.stderr());
    }

    @Test
    public void testDebug() {
        String debug = "I like turtles.";
        this.log.debug("I like turtles.");
        Assert.assertEquals((Object)"", (Object)LogbackTest.stdout());
        Assert.assertEquals((Object)"", (Object)LogbackTest.stderr());
    }

    @Test
    public void testTrace() {
        String trace = "https://youtu.be/Vxq9yj2pVWk";
        this.log.trace("https://youtu.be/Vxq9yj2pVWk");
        Assert.assertEquals((Object)"", (Object)LogbackTest.stdout());
        Assert.assertEquals((Object)"", (Object)LogbackTest.stderr());
    }
}

