/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.function;

import java.util.HashMap;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.scijava.function.Producer;

public final class Functions {
    public static final HashMap<Integer, Class<?>> ALL_FUNCTIONS = new HashMap(10);
    public static final HashMap<Class<?>, Integer> ALL_ARITIES = new HashMap(10);

    private Functions() {
    }

    public static boolean isFunction(Class<?> c) {
        try {
            Class<?> superType = Functions.superType(c);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static Class<?> superType(Class<?> c) {
        if (ALL_FUNCTIONS.containsValue(c)) {
            return c;
        }
        for (Class<?> func : ALL_ARITIES.keySet()) {
            if (!func.isAssignableFrom(c)) continue;
            return func;
        }
        throw new IllegalArgumentException(c + " is not a subclass of any known Functions!");
    }

    public static Class<?> functionOfArity(int arity) {
        if (ALL_FUNCTIONS.containsKey(arity)) {
            return ALL_FUNCTIONS.get(arity);
        }
        throw new IllegalArgumentException("No Function of arity " + arity);
    }

    public static int arityOf(Class<?> c) {
        return ALL_ARITIES.getOrDefault(c, -1);
    }

    public static <O> ArityN<O> nary(final Producer<O> f) {
        return new ArityN<O>(){

            @Override
            public O apply(Object ... ins) {
                return f.create();
            }

            @Override
            public Producer<O> op() {
                return f;
            }
        };
    }

    public static <O> ArityN<O> nary(final Function<?, O> f) {
        final Function<?, O> func = f;
        return new ArityN<O>(){

            @Override
            public O apply(Object ... ins) {
                return func.apply(ins[0]);
            }

            @Override
            public Function<?, O> op() {
                return f;
            }
        };
    }

    public static <O> ArityN<O> nary(final BiFunction<?, ?, O> f) {
        final BiFunction<?, ?, O> func = f;
        return new ArityN<O>(){

            @Override
            public O apply(Object ... ins) {
                return func.apply(ins[0], ins[1]);
            }

            @Override
            public BiFunction<?, ?, O> op() {
                return f;
            }
        };
    }

    public static <O> ArityN<O> nary(final Arity3<?, ?, ?, O> f) {
        final Arity3<?, ?, ?, O> func = f;
        return new ArityN<O>(){

            @Override
            public O apply(Object ... ins) {
                return func.apply(ins[0], ins[1], ins[2]);
            }

            @Override
            public Arity3<?, ?, ?, O> op() {
                return f;
            }
        };
    }

    public static <O> ArityN<O> nary(final Arity4<?, ?, ?, ?, O> f) {
        final Arity4<?, ?, ?, ?, O> func = f;
        return new ArityN<O>(){

            @Override
            public O apply(Object ... ins) {
                return func.apply(ins[0], ins[1], ins[2], ins[3]);
            }

            @Override
            public Arity4<?, ?, ?, ?, O> op() {
                return f;
            }
        };
    }

    public static <O> ArityN<O> nary(final Arity5<?, ?, ?, ?, ?, O> f) {
        final Arity5<?, ?, ?, ?, ?, O> func = f;
        return new ArityN<O>(){

            @Override
            public O apply(Object ... ins) {
                return func.apply(ins[0], ins[1], ins[2], ins[3], ins[4]);
            }

            @Override
            public Arity5<?, ?, ?, ?, ?, O> op() {
                return f;
            }
        };
    }

    public static <O> ArityN<O> nary(final Arity6<?, ?, ?, ?, ?, ?, O> f) {
        final Arity6<?, ?, ?, ?, ?, ?, O> func = f;
        return new ArityN<O>(){

            @Override
            public O apply(Object ... ins) {
                return func.apply(ins[0], ins[1], ins[2], ins[3], ins[4], ins[5]);
            }

            @Override
            public Arity6<?, ?, ?, ?, ?, ?, O> op() {
                return f;
            }
        };
    }

    public static <O> ArityN<O> nary(final Arity7<?, ?, ?, ?, ?, ?, ?, O> f) {
        final Arity7<?, ?, ?, ?, ?, ?, ?, O> func = f;
        return new ArityN<O>(){

            @Override
            public O apply(Object ... ins) {
                return func.apply(ins[0], ins[1], ins[2], ins[3], ins[4], ins[5], ins[6]);
            }

            @Override
            public Arity7<?, ?, ?, ?, ?, ?, ?, O> op() {
                return f;
            }
        };
    }

    public static <O> ArityN<O> nary(final Arity8<?, ?, ?, ?, ?, ?, ?, ?, O> f) {
        final Arity8<?, ?, ?, ?, ?, ?, ?, ?, O> func = f;
        return new ArityN<O>(){

            @Override
            public O apply(Object ... ins) {
                return func.apply(ins[0], ins[1], ins[2], ins[3], ins[4], ins[5], ins[6], ins[7]);
            }

            @Override
            public Arity8<?, ?, ?, ?, ?, ?, ?, ?, O> op() {
                return f;
            }
        };
    }

    public static <O> ArityN<O> nary(final Arity9<?, ?, ?, ?, ?, ?, ?, ?, ?, O> f) {
        final Arity9<?, ?, ?, ?, ?, ?, ?, ?, ?, O> func = f;
        return new ArityN<O>(){

            @Override
            public O apply(Object ... ins) {
                return func.apply(ins[0], ins[1], ins[2], ins[3], ins[4], ins[5], ins[6], ins[7], ins[8]);
            }

            @Override
            public Arity9<?, ?, ?, ?, ?, ?, ?, ?, ?, O> op() {
                return f;
            }
        };
    }

    public static <O> ArityN<O> nary(final Arity10<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, O> f) {
        final Arity10<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, O> func = f;
        return new ArityN<O>(){

            @Override
            public O apply(Object ... ins) {
                return func.apply(ins[0], ins[1], ins[2], ins[3], ins[4], ins[5], ins[6], ins[7], ins[8], ins[9]);
            }

            @Override
            public Arity10<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, O> op() {
                return f;
            }
        };
    }

    public static <O> ArityN<O> nary(final Arity11<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, O> f) {
        final Arity11<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, O> func = f;
        return new ArityN<O>(){

            @Override
            public O apply(Object ... ins) {
                return func.apply(ins[0], ins[1], ins[2], ins[3], ins[4], ins[5], ins[6], ins[7], ins[8], ins[9], ins[10]);
            }

            @Override
            public Arity11<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, O> op() {
                return f;
            }
        };
    }

    public static <O> ArityN<O> nary(final Arity12<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, O> f) {
        final Arity12<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, O> func = f;
        return new ArityN<O>(){

            @Override
            public O apply(Object ... ins) {
                return func.apply(ins[0], ins[1], ins[2], ins[3], ins[4], ins[5], ins[6], ins[7], ins[8], ins[9], ins[10], ins[11]);
            }

            @Override
            public Arity12<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, O> op() {
                return f;
            }
        };
    }

    public static <O> ArityN<O> nary(final Arity13<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, O> f) {
        final Arity13<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, O> func = f;
        return new ArityN<O>(){

            @Override
            public O apply(Object ... ins) {
                return func.apply(ins[0], ins[1], ins[2], ins[3], ins[4], ins[5], ins[6], ins[7], ins[8], ins[9], ins[10], ins[11], ins[12]);
            }

            @Override
            public Arity13<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, O> op() {
                return f;
            }
        };
    }

    public static <O> ArityN<O> nary(final Arity14<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, O> f) {
        final Arity14<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, O> func = f;
        return new ArityN<O>(){

            @Override
            public O apply(Object ... ins) {
                return func.apply(ins[0], ins[1], ins[2], ins[3], ins[4], ins[5], ins[6], ins[7], ins[8], ins[9], ins[10], ins[11], ins[12], ins[13]);
            }

            @Override
            public Arity14<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, O> op() {
                return f;
            }
        };
    }

    public static <O> ArityN<O> nary(final Arity15<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, O> f) {
        final Arity15<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, O> func = f;
        return new ArityN<O>(){

            @Override
            public O apply(Object ... ins) {
                return func.apply(ins[0], ins[1], ins[2], ins[3], ins[4], ins[5], ins[6], ins[7], ins[8], ins[9], ins[10], ins[11], ins[12], ins[13], ins[14]);
            }

            @Override
            public Arity15<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, O> op() {
                return f;
            }
        };
    }

    public static <O> ArityN<O> nary(final Arity16<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, O> f) {
        final Arity16<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, O> func = f;
        return new ArityN<O>(){

            @Override
            public O apply(Object ... ins) {
                return func.apply(ins[0], ins[1], ins[2], ins[3], ins[4], ins[5], ins[6], ins[7], ins[8], ins[9], ins[10], ins[11], ins[12], ins[13], ins[14], ins[15]);
            }

            @Override
            public Arity16<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, O> op() {
                return f;
            }
        };
    }

    static {
        ALL_FUNCTIONS.put(0, Producer.class);
        ALL_ARITIES.put(Producer.class, 0);
        ALL_FUNCTIONS.put(1, Function.class);
        ALL_ARITIES.put(Function.class, 1);
        ALL_FUNCTIONS.put(2, BiFunction.class);
        ALL_ARITIES.put(BiFunction.class, 2);
        ALL_FUNCTIONS.put(3, Arity3.class);
        ALL_ARITIES.put(Arity3.class, 3);
        ALL_FUNCTIONS.put(4, Arity4.class);
        ALL_ARITIES.put(Arity4.class, 4);
        ALL_FUNCTIONS.put(5, Arity5.class);
        ALL_ARITIES.put(Arity5.class, 5);
        ALL_FUNCTIONS.put(6, Arity6.class);
        ALL_ARITIES.put(Arity6.class, 6);
        ALL_FUNCTIONS.put(7, Arity7.class);
        ALL_ARITIES.put(Arity7.class, 7);
        ALL_FUNCTIONS.put(8, Arity8.class);
        ALL_ARITIES.put(Arity8.class, 8);
        ALL_FUNCTIONS.put(9, Arity9.class);
        ALL_ARITIES.put(Arity9.class, 9);
        ALL_FUNCTIONS.put(10, Arity10.class);
        ALL_ARITIES.put(Arity10.class, 10);
        ALL_FUNCTIONS.put(11, Arity11.class);
        ALL_ARITIES.put(Arity11.class, 11);
        ALL_FUNCTIONS.put(12, Arity12.class);
        ALL_ARITIES.put(Arity12.class, 12);
        ALL_FUNCTIONS.put(13, Arity13.class);
        ALL_ARITIES.put(Arity13.class, 13);
        ALL_FUNCTIONS.put(14, Arity14.class);
        ALL_ARITIES.put(Arity14.class, 14);
        ALL_FUNCTIONS.put(15, Arity15.class);
        ALL_ARITIES.put(Arity15.class, 15);
        ALL_FUNCTIONS.put(16, Arity16.class);
        ALL_ARITIES.put(Arity16.class, 16);
    }

    public static interface ArityN<O> {
        public O apply(Object ... var1);

        public Object op();
    }

    @FunctionalInterface
    public static interface Arity16<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, O> {
        public O apply(I1 var1, I2 var2, I3 var3, I4 var4, I5 var5, I6 var6, I7 var7, I8 var8, I9 var9, I10 var10, I11 var11, I12 var12, I13 var13, I14 var14, I15 var15, I16 var16);

        default public <O2> Arity16<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, I16, O2> andThen(Function<? super O, ? extends O2> after) {
            Objects.requireNonNull(after);
            return (in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16) -> after.apply((O)this.apply(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15, in16));
        }
    }

    @FunctionalInterface
    public static interface Arity15<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, O> {
        public O apply(I1 var1, I2 var2, I3 var3, I4 var4, I5 var5, I6 var6, I7 var7, I8 var8, I9 var9, I10 var10, I11 var11, I12 var12, I13 var13, I14 var14, I15 var15);

        default public <O2> Arity15<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, I15, O2> andThen(Function<? super O, ? extends O2> after) {
            Objects.requireNonNull(after);
            return (in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15) -> after.apply((O)this.apply(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14, in15));
        }
    }

    @FunctionalInterface
    public static interface Arity14<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, O> {
        public O apply(I1 var1, I2 var2, I3 var3, I4 var4, I5 var5, I6 var6, I7 var7, I8 var8, I9 var9, I10 var10, I11 var11, I12 var12, I13 var13, I14 var14);

        default public <O2> Arity14<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, I14, O2> andThen(Function<? super O, ? extends O2> after) {
            Objects.requireNonNull(after);
            return (in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14) -> after.apply((O)this.apply(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13, in14));
        }
    }

    @FunctionalInterface
    public static interface Arity13<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, O> {
        public O apply(I1 var1, I2 var2, I3 var3, I4 var4, I5 var5, I6 var6, I7 var7, I8 var8, I9 var9, I10 var10, I11 var11, I12 var12, I13 var13);

        default public <O2> Arity13<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, I13, O2> andThen(Function<? super O, ? extends O2> after) {
            Objects.requireNonNull(after);
            return (in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13) -> after.apply((O)this.apply(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12, in13));
        }
    }

    @FunctionalInterface
    public static interface Arity12<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, O> {
        public O apply(I1 var1, I2 var2, I3 var3, I4 var4, I5 var5, I6 var6, I7 var7, I8 var8, I9 var9, I10 var10, I11 var11, I12 var12);

        default public <O2> Arity12<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, I12, O2> andThen(Function<? super O, ? extends O2> after) {
            Objects.requireNonNull(after);
            return (in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12) -> after.apply((O)this.apply(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11, in12));
        }
    }

    @FunctionalInterface
    public static interface Arity11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, O> {
        public O apply(I1 var1, I2 var2, I3 var3, I4 var4, I5 var5, I6 var6, I7 var7, I8 var8, I9 var9, I10 var10, I11 var11);

        default public <O2> Arity11<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, I11, O2> andThen(Function<? super O, ? extends O2> after) {
            Objects.requireNonNull(after);
            return (in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11) -> after.apply((O)this.apply(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10, in11));
        }
    }

    @FunctionalInterface
    public static interface Arity10<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, O> {
        public O apply(I1 var1, I2 var2, I3 var3, I4 var4, I5 var5, I6 var6, I7 var7, I8 var8, I9 var9, I10 var10);

        default public <O2> Arity10<I1, I2, I3, I4, I5, I6, I7, I8, I9, I10, O2> andThen(Function<? super O, ? extends O2> after) {
            Objects.requireNonNull(after);
            return (in1, in2, in3, in4, in5, in6, in7, in8, in9, in10) -> after.apply((O)this.apply(in1, in2, in3, in4, in5, in6, in7, in8, in9, in10));
        }
    }

    @FunctionalInterface
    public static interface Arity9<I1, I2, I3, I4, I5, I6, I7, I8, I9, O> {
        public O apply(I1 var1, I2 var2, I3 var3, I4 var4, I5 var5, I6 var6, I7 var7, I8 var8, I9 var9);

        default public <O2> Arity9<I1, I2, I3, I4, I5, I6, I7, I8, I9, O2> andThen(Function<? super O, ? extends O2> after) {
            Objects.requireNonNull(after);
            return (in1, in2, in3, in4, in5, in6, in7, in8, in9) -> after.apply((O)this.apply(in1, in2, in3, in4, in5, in6, in7, in8, in9));
        }
    }

    @FunctionalInterface
    public static interface Arity8<I1, I2, I3, I4, I5, I6, I7, I8, O> {
        public O apply(I1 var1, I2 var2, I3 var3, I4 var4, I5 var5, I6 var6, I7 var7, I8 var8);

        default public <O2> Arity8<I1, I2, I3, I4, I5, I6, I7, I8, O2> andThen(Function<? super O, ? extends O2> after) {
            Objects.requireNonNull(after);
            return (in1, in2, in3, in4, in5, in6, in7, in8) -> after.apply((O)this.apply(in1, in2, in3, in4, in5, in6, in7, in8));
        }
    }

    @FunctionalInterface
    public static interface Arity7<I1, I2, I3, I4, I5, I6, I7, O> {
        public O apply(I1 var1, I2 var2, I3 var3, I4 var4, I5 var5, I6 var6, I7 var7);

        default public <O2> Arity7<I1, I2, I3, I4, I5, I6, I7, O2> andThen(Function<? super O, ? extends O2> after) {
            Objects.requireNonNull(after);
            return (in1, in2, in3, in4, in5, in6, in7) -> after.apply((O)this.apply(in1, in2, in3, in4, in5, in6, in7));
        }
    }

    @FunctionalInterface
    public static interface Arity6<I1, I2, I3, I4, I5, I6, O> {
        public O apply(I1 var1, I2 var2, I3 var3, I4 var4, I5 var5, I6 var6);

        default public <O2> Arity6<I1, I2, I3, I4, I5, I6, O2> andThen(Function<? super O, ? extends O2> after) {
            Objects.requireNonNull(after);
            return (in1, in2, in3, in4, in5, in6) -> after.apply((O)this.apply(in1, in2, in3, in4, in5, in6));
        }
    }

    @FunctionalInterface
    public static interface Arity5<I1, I2, I3, I4, I5, O> {
        public O apply(I1 var1, I2 var2, I3 var3, I4 var4, I5 var5);

        default public <O2> Arity5<I1, I2, I3, I4, I5, O2> andThen(Function<? super O, ? extends O2> after) {
            Objects.requireNonNull(after);
            return (in1, in2, in3, in4, in5) -> after.apply((O)this.apply(in1, in2, in3, in4, in5));
        }
    }

    @FunctionalInterface
    public static interface Arity4<I1, I2, I3, I4, O> {
        public O apply(I1 var1, I2 var2, I3 var3, I4 var4);

        default public <O2> Arity4<I1, I2, I3, I4, O2> andThen(Function<? super O, ? extends O2> after) {
            Objects.requireNonNull(after);
            return (in1, in2, in3, in4) -> after.apply((O)this.apply(in1, in2, in3, in4));
        }
    }

    @FunctionalInterface
    public static interface Arity3<I1, I2, I3, O> {
        public O apply(I1 var1, I2 var2, I3 var3);

        default public <O2> Arity3<I1, I2, I3, O2> andThen(Function<? super O, ? extends O2> after) {
            Objects.requireNonNull(after);
            return (in1, in2, in3) -> after.apply((O)this.apply(in1, in2, in3));
        }
    }
}

