/*
 * Decompiled with CFR 0.152.
 */
package eg.bowling;

import eg.bowling.Bowling;
import eg.bowling.BowlingGame;
import junit.framework.TestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class BowlingGameTest
extends TestCase {
    private Bowling g;

    protected void setUp() throws Exception {
        this.g = new BowlingGame();
    }

    public void testGutterGame() throws Exception {
        this.rollMany(20, 0);
        BowlingGameTest.assertEquals((int)0, (int)this.g.score(10));
    }

    public void testAllOnes() throws Exception {
        this.rollMany(20, 1);
        BowlingGameTest.assertEquals((int)20, (int)this.g.score(10));
    }

    public void testSpare() throws Exception {
        this.g.roll(5);
        this.g.roll(5);
        this.g.roll(3);
        this.rollMany(17, 0);
        BowlingGameTest.assertEquals((int)16, (int)this.g.score(10));
    }

    public void testStrike() throws Exception {
        this.g.roll(10);
        this.g.roll(3);
        this.g.roll(5);
        this.rollMany(16, 0);
        BowlingGameTest.assertEquals((int)26, (int)this.g.score(10));
    }

    public void testPerfectGame() throws Exception {
        this.rollMany(12, 10);
        BowlingGameTest.assertEquals((int)300, (int)this.g.score(10));
    }

    private void rollMany(int n, int pins) {
        for (int i = 0; i < n; ++i) {
            this.g.roll(pins);
        }
    }

    public void testCurrentFrameStartsAtOne() throws Exception {
        BowlingGameTest.assertEquals((int)1, (int)this.g.currentFrame());
    }

    public void testCurrentFrameNoStrike() throws Exception {
        this.g.roll(1);
        BowlingGameTest.assertEquals((int)1, (int)this.g.currentFrame());
        this.g.roll(2);
        BowlingGameTest.assertEquals((int)2, (int)this.g.currentFrame());
    }

    public void testCurrentFrameNeverExceedsTen() throws Exception {
        this.rollMany(20, 0);
        BowlingGameTest.assertEquals((int)10, (int)this.g.currentFrame());
    }

    public void testCurrentBallStartsAtOne() throws Exception {
        BowlingGameTest.assertEquals((int)1, (int)this.g.currentBall());
    }

    public void testCurrentBallNoStrike() throws Exception {
        this.g.roll(1);
        BowlingGameTest.assertEquals((int)2, (int)this.g.currentBall());
        this.g.roll(1);
        BowlingGameTest.assertEquals((int)1, (int)this.g.currentBall());
    }

    public void testCurrentBallZeroWhenGameOver() throws Exception {
        this.rollMany(20, 0);
        BowlingGameTest.assertEquals((int)0, (int)this.g.currentBall());
    }

    public void testScoreableFrameStartsAtZero() throws Exception {
        BowlingGameTest.assertEquals((int)0, (int)this.g.scoreableFrame());
    }

    public void testScoreableFrameNoMarks() throws Exception {
        this.g.roll(1);
        BowlingGameTest.assertEquals((int)0, (int)this.g.scoreableFrame());
        this.g.roll(1);
        BowlingGameTest.assertEquals((int)1, (int)this.g.scoreableFrame());
        this.rollMany(18, 1);
        BowlingGameTest.assertEquals((int)10, (int)this.g.scoreableFrame());
    }

    public void testScoreableFrameForSpare() throws Exception {
        this.g.roll(5);
        this.g.roll(5);
        BowlingGameTest.assertEquals((int)0, (int)this.g.scoreableFrame());
        this.g.roll(3);
        BowlingGameTest.assertEquals((int)1, (int)this.g.scoreableFrame());
        this.g.roll(4);
        BowlingGameTest.assertEquals((int)2, (int)this.g.scoreableFrame());
    }

    public void testScoreableFrameForTenthFrameSpare() throws Exception {
        this.rollMany(18, 0);
        this.g.roll(5);
        this.g.roll(5);
        BowlingGameTest.assertEquals((int)10, (int)this.g.currentFrame());
        BowlingGameTest.assertEquals((int)3, (int)this.g.currentBall());
        BowlingGameTest.assertEquals((int)9, (int)this.g.scoreableFrame());
        BowlingGameTest.assertEquals((boolean)false, (boolean)this.g.gameOver());
        this.g.roll(5);
        BowlingGameTest.assertEquals((int)10, (int)this.g.currentFrame());
        BowlingGameTest.assertEquals((int)0, (int)this.g.currentBall());
        BowlingGameTest.assertEquals((int)10, (int)this.g.scoreableFrame());
        BowlingGameTest.assertTrue((boolean)this.g.gameOver());
    }

    public void testGameNotOver() throws Exception {
        BowlingGameTest.assertEquals((boolean)false, (boolean)this.g.gameOver());
    }

    public void testGameOverNoMarks() throws Exception {
        for (int i = 0; i < 20; ++i) {
            BowlingGameTest.assertEquals((boolean)false, (boolean)this.g.gameOver());
            this.g.roll(0);
        }
        BowlingGameTest.assertEquals((boolean)true, (boolean)this.g.gameOver());
    }

    public void testCurrentFrameForStrike() throws Exception {
        this.g.roll(10);
        BowlingGameTest.assertEquals((int)2, (int)this.g.currentFrame());
        BowlingGameTest.assertEquals((int)1, (int)this.g.currentBall());
        BowlingGameTest.assertEquals((int)0, (int)this.g.scoreableFrame());
        this.g.roll(3);
        BowlingGameTest.assertEquals((int)2, (int)this.g.currentFrame());
        BowlingGameTest.assertEquals((int)2, (int)this.g.currentBall());
        BowlingGameTest.assertEquals((int)0, (int)this.g.scoreableFrame());
        this.g.roll(3);
        BowlingGameTest.assertEquals((int)3, (int)this.g.currentFrame());
        BowlingGameTest.assertEquals((int)1, (int)this.g.currentBall());
        BowlingGameTest.assertEquals((int)2, (int)this.g.scoreableFrame());
    }

    public void testStrikeAfterSpare() throws Exception {
        this.g.roll(5);
        this.g.roll(5);
        this.g.roll(10);
        BowlingGameTest.assertEquals((int)3, (int)this.g.currentFrame());
        BowlingGameTest.assertEquals((int)1, (int)this.g.currentBall());
        BowlingGameTest.assertEquals((int)1, (int)this.g.scoreableFrame());
    }

    public void testManyStrikes() throws Exception {
        this.g.roll(10);
        this.g.roll(10);
        BowlingGameTest.assertEquals((int)3, (int)this.g.currentFrame());
        BowlingGameTest.assertEquals((int)1, (int)this.g.currentBall());
        BowlingGameTest.assertEquals((int)0, (int)this.g.scoreableFrame());
        this.rollMany(7, 10);
        BowlingGameTest.assertEquals((int)10, (int)this.g.currentFrame());
        BowlingGameTest.assertEquals((int)1, (int)this.g.currentBall());
        BowlingGameTest.assertEquals((int)7, (int)this.g.scoreableFrame());
        this.g.roll(10);
        BowlingGameTest.assertEquals((String)"", (int)10, (int)this.g.currentFrame());
        BowlingGameTest.assertEquals((String)"", (int)2, (int)this.g.currentBall());
        BowlingGameTest.assertEquals((String)"", (int)8, (int)this.g.scoreableFrame());
        this.g.roll(10);
        BowlingGameTest.assertEquals((String)"", (int)3, (int)this.g.currentBall());
        BowlingGameTest.assertEquals((String)"", (int)9, (int)this.g.scoreableFrame());
        this.g.roll(10);
        BowlingGameTest.assertEquals((String)"", (int)0, (int)this.g.currentBall());
        BowlingGameTest.assertEquals((String)"", (int)10, (int)this.g.scoreableFrame());
        BowlingGameTest.assertTrue((boolean)this.g.gameOver());
    }

    public void testFinalStrike() throws Exception {
        this.rollMany(18, 0);
        this.g.roll(5);
        this.g.roll(5);
        this.g.roll(10);
        BowlingGameTest.assertEquals((String)"", (boolean)true, (boolean)this.g.gameOver());
        BowlingGameTest.assertEquals((String)"", (int)0, (int)this.g.currentBall());
        BowlingGameTest.assertEquals((String)"", (int)10, (int)this.g.scoreableFrame());
    }

    public void testFourFinalStrikes() throws Exception {
        this.rollMany(16, 0);
        this.g.roll(10);
        BowlingGameTest.assertEquals((String)"", (int)10, (int)this.g.currentFrame());
        BowlingGameTest.assertEquals((String)"", (int)1, (int)this.g.currentBall());
        BowlingGameTest.assertEquals((String)"", (int)8, (int)this.g.scoreableFrame());
        this.g.roll(10);
        BowlingGameTest.assertEquals((String)"", (int)10, (int)this.g.currentFrame());
        BowlingGameTest.assertEquals((String)"", (int)2, (int)this.g.currentBall());
        BowlingGameTest.assertEquals((String)"", (int)8, (int)this.g.scoreableFrame());
        this.g.roll(10);
        BowlingGameTest.assertEquals((String)"", (int)10, (int)this.g.currentFrame());
        BowlingGameTest.assertEquals((String)"", (int)3, (int)this.g.currentBall());
        BowlingGameTest.assertEquals((String)"", (int)9, (int)this.g.scoreableFrame());
        this.g.roll(10);
        BowlingGameTest.assertEquals((String)"", (int)10, (int)this.g.currentFrame());
        BowlingGameTest.assertEquals((String)"", (int)0, (int)this.g.currentBall());
        BowlingGameTest.assertEquals((String)"", (int)10, (int)this.g.scoreableFrame());
        BowlingGameTest.assertEquals((String)"", (boolean)true, (boolean)this.g.gameOver());
    }

    public void testThreeFinalStrikes() throws Exception {
        this.rollMany(18, 0);
        this.g.roll(10);
        BowlingGameTest.assertEquals((String)"", (int)10, (int)this.g.currentFrame());
        BowlingGameTest.assertEquals((String)"", (int)2, (int)this.g.currentBall());
        BowlingGameTest.assertEquals((String)"", (int)9, (int)this.g.scoreableFrame());
        this.g.roll(10);
        BowlingGameTest.assertEquals((String)"", (int)10, (int)this.g.currentFrame());
        BowlingGameTest.assertEquals((String)"", (int)3, (int)this.g.currentBall());
        BowlingGameTest.assertEquals((String)"", (int)9, (int)this.g.scoreableFrame());
        this.g.roll(10);
        BowlingGameTest.assertEquals((String)"", (int)10, (int)this.g.currentFrame());
        BowlingGameTest.assertEquals((String)"", (int)0, (int)this.g.currentBall());
        BowlingGameTest.assertEquals((String)"", (int)10, (int)this.g.scoreableFrame());
        BowlingGameTest.assertEquals((String)"", (boolean)true, (boolean)this.g.gameOver());
    }
}

