/*
 * Decompiled with CFR 0.152.
 */
package eg.bowling.fixtures;

import eg.bowling.Bowling;
import eg.bowling.BowlingGame;
import fitnesse.fixtures.TableFixture;

public class ScoreGame
extends TableFixture {
    private Bowling game;
    public static final int STRIKE = -1;
    public static final int SPARE = -2;
    public static final int BLANK = -3;
    public static final int ERROR = -4;

    protected void doStaticTable(int rows) {
        this.game = new BowlingGame();
        this.doRolls();
        this.doScores();
    }

    private void doRolls() {
        for (int roll = 0; roll < 21; ++roll) {
            this.doRoll(roll);
        }
    }

    private void doRoll(int roll) {
        int pins = this.parseRoll(roll);
        if (pins == -2) {
            this.spare(roll);
        } else if (pins == -1) {
            this.strike(roll);
        } else if (pins == -3) {
            this.blank(roll);
        } else if (pins == -4) {
            this.wrongRoll(roll);
        } else {
            this.roll(pins);
        }
    }

    private int parseRoll(int roll) {
        String rollText = this.getText(1, roll);
        if (rollText.equals("/")) {
            return -2;
        }
        if (rollText.equals("X")) {
            return -1;
        }
        if (rollText.equals("")) {
            return -3;
        }
        try {
            int pins = Integer.parseInt(rollText);
            return pins;
        }
        catch (NumberFormatException e) {
            return -4;
        }
    }

    private void spare(int rollNumber) {
        if (this.odd(rollNumber)) {
            this.wrongRoll(rollNumber);
        } else {
            int previousRoll = this.parseRoll(rollNumber - 1);
            if (previousRoll < 0) {
                this.wrongRoll(rollNumber);
            } else {
                this.roll(10 - previousRoll);
            }
        }
    }

    private void wrongRoll(int rollNumber) {
        this.wrong(1, rollNumber);
    }

    private void strike(int rollNumber) {
        if (this.tenthFrameStrike(rollNumber)) {
            this.roll(10);
            return;
        }
        if (this.odd(rollNumber)) {
            this.wrongRoll(rollNumber);
            return;
        }
        int previousRoll = this.parseRoll(rollNumber - 1);
        if (previousRoll != -3) {
            this.wrongRoll(rollNumber);
        } else {
            this.roll(10);
        }
    }

    private boolean tenthFrameStrike(int rollNumber) {
        return rollNumber == 18 || rollNumber == 19 && this.parseRoll(18) == -1 || rollNumber == 20 && (this.parseRoll(19) == -1 || this.parseRoll(19) == -2);
    }

    private boolean odd(int rollNumber) {
        return rollNumber % 2 != 1;
    }

    private void blank(int roll) {
        if (roll == 20 && this.parseRoll(19) != -2 && this.parseRoll(18) != -1) {
            return;
        }
        if (this.parseRoll(roll + 1) == -1) {
            return;
        }
        this.wrongRoll(roll);
    }

    private void roll(int pins) {
        this.game.roll(pins);
    }

    private void doScores() {
        for (int frame = 0; frame < 10; ++frame) {
            this.scoreFrame(frame);
        }
    }

    private void scoreFrame(int frame) {
        int actualScore;
        int expectedScore = this.getScore(frame);
        if (expectedScore == (actualScore = this.game.score(frame + 1))) {
            this.rightScore(frame);
        } else {
            this.wrongScore(frame, "" + actualScore);
        }
    }

    private void rightScore(int frame) {
        this.right(2, this.scoreIndex(frame));
    }

    private void wrongScore(int frame, String actual) {
        this.wrong(2, this.scoreIndex(frame), actual);
    }

    private int getScore(int frame) {
        return Integer.parseInt(this.getText(2, this.scoreIndex(frame)));
    }

    private int scoreIndex(int frame) {
        return frame * 2 + 1;
    }
}

