/*
 * Decompiled with CFR 0.152.
 */
package fit.decorator.util;

import fit.decorator.exceptions.InvalidInputException;
import fit.decorator.util.Delta;
import fit.decorator.util.DeltaTest;
import junit.framework.TestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class DeltaTest
extends TestCase {
    private static final String INT_DATA_TYPE = "int";
    private static final String DOUBLE_DATA_TYPE = "double";
    private static final String STRING_DATA_TYPE = "string";

    public void testConstructorDoesNotLeaveTheObjectInAnUnstableState() throws Exception {
        this.assertInvalidInputException("int", "xyz");
        this.assertInvalidInputException("int", "1.2");
        this.assertInvalidInputException("double", "1.2E");
    }

    private void assertInvalidInputException(String dataType, String value) {
        try {
            new Delta(dataType, value);
        }
        catch (InvalidInputException e) {
            DeltaTest.assertEquals((String)("value '" + value + "' is not a valid DataType = '" + dataType + "'"), (String)e.getMessage());
        }
    }

    public void testDeltaShouldEncapsulateTheValueAndDataType() throws Exception {
        Delta expectedDelta = new Delta("int", "5");
        DeltaTest.assertEquals((Object)expectedDelta, (Object)expectedDelta);
        DeltaTest.assertFalse((boolean)expectedDelta.equals(null));
        DeltaTest.assertEquals((Object)expectedDelta, (Object)new Delta("int", "5"));
        DeltaTest.assertEquals((Object)expectedDelta, (Object)new Delta("Int", "5"));
        DeltaTest.assertEquals((Object)expectedDelta, (Object)new Delta("integer", "5"));
        DeltaTest.assertEquals((Object)expectedDelta, (Object)new Delta("IntegeR", "5"));
        expectedDelta = new Delta("double", "1.2");
        DeltaTest.assertEquals((Object)expectedDelta, (Object)new Delta("double", "1.20"));
        DeltaTest.assertEquals((Object)expectedDelta, (Object)new Delta("Double", "1.200"));
        expectedDelta = new Delta("string", "value");
        DeltaTest.assertEquals((Object)expectedDelta, (Object)new Delta("String", "value"));
        DeltaTest.assertEquals((Object)new Delta("string", "1.200"), (Object)new Delta("anyValueOtherThanIntAndDouble", "1.200"));
        1 delta = new /* Unavailable Anonymous Inner Class!! */;
        DeltaTest.assertFalse((boolean)expectedDelta.equals((Object)delta));
    }

    public void testAdd() throws Exception {
        Delta int5 = new Delta("int", "5");
        DeltaTest.assertEquals((String)"10", (String)int5.addTo("5", 1));
        DeltaTest.assertEquals((String)"20", (String)int5.addTo("10", 2));
        DeltaTest.assertEquals((String)"0", (String)int5.addTo("-5", 1));
        Delta double5Point2 = new Delta("double", "5.2");
        DeltaTest.assertEquals((String)"10.2", (String)double5Point2.addTo("5", 1));
        DeltaTest.assertEquals((String)"10.402", (String)double5Point2.addTo("0.002", 2));
        DeltaTest.assertEquals((String)"0.2", (String)double5Point2.addTo("-5", 1));
        Delta stringABC = new Delta("string", "ABC");
        DeltaTest.assertEquals((String)"5ABC", (String)stringABC.addTo("5", 1));
        DeltaTest.assertEquals((String)"0.002ABC", (String)stringABC.addTo("0.002", 1));
        DeltaTest.assertEquals((String)"-5ABCABCABC", (String)stringABC.addTo("-5", 3));
        DeltaTest.assertEquals((String)"XYZABC", (String)stringABC.addTo("XYZ", 1));
    }

    public void testToString() throws Exception {
        this.aasertToString("5.3", "double");
        this.aasertToString("5.3", "string");
        this.aasertToString("5", "int");
    }

    private void aasertToString(String value, String dataType) throws InvalidInputException {
        String expectedToStringValue = "DataType = '" + dataType + "' and value = " + value;
        DeltaTest.assertEquals((String)expectedToStringValue, (String)new Delta(dataType, value).toString());
    }
}

