/*
 * Decompiled with CFR 0.152.
 */
package fitnesse;

import fitnesse.FitNesseContext;
import fitnesse.FitNesseExpediter;
import fitnesse.FitNesseServer;
import fitnesse.components.LogData;
import fitnesse.http.MockRequest;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.testutil.SampleFileUtility;
import fitnesse.util.MockSocket;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageDummy;
import fitnesse.wiki.WikiPagePath;
import java.net.Socket;
import java.util.regex.Pattern;
import util.RegexTestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class FitNesseServerTest
extends RegexTestCase {
    private PageCrawler crawler;
    private WikiPage root;
    private WikiPagePath pageOnePath;
    private WikiPagePath pageOneTwoPath;
    private FitNesseContext context;

    public void setUp() throws Exception {
        SampleFileUtility.makeSampleFiles();
        this.root = InMemoryPage.makeRoot((String)"RootPage");
        this.crawler = this.root.getPageCrawler();
        this.pageOnePath = PathParser.parse((String)"PageOne");
        this.pageOneTwoPath = PathParser.parse((String)"PageOne.PageTwo");
        this.context = FitNesseUtil.makeTestContext((WikiPage)this.root);
    }

    public void tearDown() throws Exception {
        SampleFileUtility.deleteSampleFiles();
    }

    public void testSimple() throws Exception {
        this.crawler.addPage(this.root, PathParser.parse((String)"SomePage"), "some string");
        String output = this.getSocketOutput("GET /SomePage HTTP/1.1\r\n\r\n", this.root);
        String statusLine = "HTTP/1.1 200 OK\r\n";
        FitNesseServerTest.assertTrue((String)"Should have statusLine", (boolean)Pattern.compile(statusLine, 8).matcher(output).find());
        FitNesseServerTest.assertTrue((String)"Should have canned Content", (boolean)FitNesseServerTest.hasSubString((String)"some string", (String)output));
    }

    public void testNotFound() throws Exception {
        String output = this.getSocketOutput("GET /WikiWord HTTP/1.1\r\n\r\n", (WikiPage)new WikiPageDummy());
        FitNesseServerTest.assertSubString((String)"Page doesn't exist.", (String)output);
    }

    public void testBadRequest() throws Exception {
        String output = this.getSocketOutput("Bad Request \r\n\r\n", (WikiPage)new WikiPageDummy());
        FitNesseServerTest.assertSubString((String)"400 Bad Request", (String)output);
        FitNesseServerTest.assertSubString((String)"The request string is malformed and can not be parsed", (String)output);
    }

    public void testSomeOtherPage() throws Exception {
        this.crawler.addPage(this.root, this.pageOnePath, "Page One Content");
        String output = this.getSocketOutput("GET /PageOne HTTP/1.1\r\n\r\n", this.root);
        String expected = "Page One Content";
        FitNesseServerTest.assertTrue((String)"Should have page one", (boolean)FitNesseServerTest.hasSubString((String)expected, (String)output));
    }

    public void testSecondLevelPage() throws Exception {
        this.crawler.addPage(this.root, this.pageOnePath, "Page One Content");
        this.crawler.addPage(this.root, this.pageOneTwoPath, "Page Two Content");
        String output = this.getSocketOutput("GET /PageOne.PageTwo HTTP/1.1\r\n\r\n", this.root);
        String expected = "Page Two Content";
        FitNesseServerTest.assertTrue((String)"Should have page Two", (boolean)FitNesseServerTest.hasSubString((String)expected, (String)output));
    }

    public void testRelativeAndAbsoluteLinks() throws Exception {
        this.crawler.addPage(this.root, this.pageOnePath, "PageOne");
        this.crawler.addPage(this.root, this.pageOneTwoPath, "PageTwo");
        String output = this.getSocketOutput("GET /PageOne.PageTwo HTTP/1.1\r\n\r\n", this.root);
        String expected = "href=\"PageOne.PageTwo\".*PageTwo";
        FitNesseServerTest.assertTrue((String)"Should have relative link", (boolean)FitNesseServerTest.hasSubString((String)expected, (String)output));
        this.crawler.addPage(this.root, PathParser.parse((String)"PageTwo"), "PageTwo at root");
        this.crawler.addPage(this.root, PathParser.parse((String)"PageOne.PageThree"), "PageThree has link to .PageTwo at the root");
        output = this.getSocketOutput("GET /PageOne.PageThree HTTP/1.1\r\n\r\n", this.root);
        expected = "href=\"PageTwo\".*[.]PageTwo";
        FitNesseServerTest.assertTrue((String)"Should have absolute link", (boolean)FitNesseServerTest.hasSubString((String)expected, (String)output));
    }

    public void testServingRegularFiles() throws Exception {
        String output = this.getSocketOutput("GET /files/testDir/testFile2 HTTP/1.1\r\n\r\n", (WikiPage)new WikiPageDummy());
        FitNesseServerTest.assertHasRegexp((String)"file2 content", (String)output);
    }

    public void testLoggingDataCreation() {
        MockRequest request = new MockRequest();
        SimpleResponse response = new SimpleResponse(200);
        MockSocket socket = new MockSocket("something");
        socket.setHost("1.2.3.4");
        request.setRequestLine("GET / HTTP/1.1");
        response.setContent("abc");
        request.setCredentials("billy", "bob");
        LogData data = FitNesseExpediter.makeLogData((Socket)socket, (Request)request, (Response)response);
        FitNesseServerTest.assertEquals((String)"1.2.3.4", (String)data.host);
        FitNesseServerTest.assertNotNull((Object)data.time);
        FitNesseServerTest.assertEquals((String)"GET / HTTP/1.1", (String)data.requestLine);
        FitNesseServerTest.assertEquals((int)200, (int)data.status);
        FitNesseServerTest.assertEquals((int)3, (int)data.size);
        FitNesseServerTest.assertEquals((String)"billy", (String)data.username);
    }

    private String getSocketOutput(String requestLine, WikiPage page) throws Exception {
        MockSocket s = new MockSocket(requestLine);
        FitNesseServer server = new FitNesseServer(this.context);
        server.serve((Socket)s, 1000L);
        String output = s.getOutput();
        return output;
    }

    private static boolean hasSubString(String expected, String output) {
        return Pattern.compile(expected, 8).matcher(output).find();
    }
}

