/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.components;

import fitnesse.components.AndPageFinder;
import fitnesse.components.CompositePageFinderTestCase;
import fitnesse.components.PageFinder;
import fitnesse.wiki.WikiPage;
import java.util.List;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class AndPageFinderTest
extends CompositePageFinderTestCase {
    @Test
    public void singlePageFinder() throws Exception {
        this.sut = new AndPageFinder();
        this.setupMockWithEmptyReturnValue();
        this.sut.add(this.delegate);
        this.sut.search(this.page);
        ((PageFinder)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.times((int)1))).search(this.page);
    }

    @Test
    public void multiplePageFinder() throws Exception {
        this.sut = new AndPageFinder();
        this.setupMockWithEmptyReturnValue();
        this.sut.add(this.delegate);
        this.sut.add(this.delegate);
        this.sut.add(this.delegate);
        this.sut.search(this.page);
        ((PageFinder)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.times((int)3))).search(this.page);
    }

    @Test
    public void intersectionIsFound() throws Exception {
        this.sut = new AndPageFinder();
        List expected = this.setupWikiPageList(new WikiPage[]{this.pageOne, this.pageTwo});
        Mockito.when((Object)this.delegate.search((WikiPage)Matchers.any(WikiPage.class))).thenReturn((Object)this.setupWikiPageList(new WikiPage[]{this.pageOne, this.pageTwo, this.pageThree}));
        PageFinder delegate2 = (PageFinder)Mockito.mock(PageFinder.class);
        Mockito.when((Object)delegate2.search((WikiPage)Matchers.any(WikiPage.class))).thenReturn((Object)expected);
        this.sut.add(this.delegate);
        this.sut.add(delegate2);
        List results = this.sut.search(this.page);
        this.assertFoundResultsEqualsExpectation(expected, results);
    }

    @Test
    public void multpleIntersections() throws Exception {
        this.sut = new AndPageFinder();
        List expected = this.setupWikiPageList(new WikiPage[]{this.pageOne, this.pageTwo});
        Mockito.when((Object)this.delegate.search((WikiPage)Matchers.any(WikiPage.class))).thenReturn((Object)this.setupWikiPageList(new WikiPage[]{this.pageOne, this.pageTwo, this.pageThree}));
        PageFinder delegate2 = (PageFinder)Mockito.mock(PageFinder.class);
        Mockito.when((Object)delegate2.search((WikiPage)Matchers.any(WikiPage.class))).thenReturn((Object)expected);
        this.sut.add(this.delegate);
        this.sut.add(delegate2);
        this.sut.add(this.delegate);
        List results = this.sut.search(this.page);
        this.assertFoundResultsEqualsExpectation(expected, results);
    }
}

