/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.components;

import fitnesse.wiki.InheritedItemBuilder;
import fitnesse.wiki.WikiPage;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import util.Wildcard;

public class ClassPathBuilder
extends InheritedItemBuilder {
    private List<String> allPaths;
    private StringBuffer pathsString;
    private Set<String> addedPaths;

    public String getClasspath(WikiPage page) {
        List paths = this.getInheritedPathElements(page, new HashSet());
        return this.createClassPathString(paths, this.getPathSeparator(page));
    }

    public List<String> getInheritedPathElements(WikiPage page, Set<WikiPage> visitedPages) {
        return this.getInheritedItems(page, visitedPages);
    }

    public String buildClassPath(List<WikiPage> testPages) {
        ClassPathBuilder classPathBuilder = new ClassPathBuilder();
        String pathSeparator = this.getPathSeparator(testPages.get(0));
        ArrayList classPathElements = new ArrayList();
        HashSet visitedPages = new HashSet();
        for (WikiPage testPage : testPages) {
            this.addClassPathElements(testPage, classPathElements, visitedPages);
        }
        return classPathBuilder.createClassPathString(classPathElements, pathSeparator);
    }

    private void addClassPathElements(WikiPage page, List<String> classPathElements, Set<WikiPage> visitedPages) {
        List pathElements = new ClassPathBuilder().getInheritedPathElements(page, visitedPages);
        classPathElements.addAll(pathElements);
    }

    public String getPathSeparator(WikiPage page) {
        String separator = page.getData().getVariable("PATH_SEPARATOR");
        if (separator == null) {
            separator = (String)System.getProperties().get("path.separator");
        }
        return separator;
    }

    public String createClassPathString(List<String> paths, String separator) {
        if (paths.isEmpty()) {
            return "defaultPath";
        }
        this.pathsString = new StringBuffer();
        paths = this.expandWildcards(paths);
        this.addedPaths = new HashSet();
        for (String path : paths) {
            this.addPathToClassPathString(separator, path);
        }
        return this.pathsString.toString();
    }

    private void addPathToClassPathString(String separator, String path) {
        if (!this.addedPaths.contains(path = this.surroundPathWithQuotesIfItHasSpaces(path))) {
            this.addedPaths.add(path);
            this.addSeparatorIfNecessary(this.pathsString, separator);
            this.pathsString.append(path);
        }
    }

    private String surroundPathWithQuotesIfItHasSpaces(String path) {
        if (path.matches(".*\\s.*") && !path.contains("\"")) {
            path = "\"" + path + "\"";
        }
        return path;
    }

    private List<String> expandWildcards(List<String> paths) {
        this.allPaths = new ArrayList();
        for (String path : paths) {
            this.expandWildcards(path);
        }
        return this.allPaths;
    }

    private void expandWildcards(String path) {
        File file = new File(path);
        File dir = new File(file.getAbsolutePath()).getParentFile();
        if (this.isExpandableDoubleWildcard(path, dir)) {
            this.recursivelyAddMatchingFiles(path, dir);
        } else if (this.isExpandableSingleWildcard(path, dir)) {
            this.addMatchingFiles(path, dir);
        } else {
            this.allPaths.add(path);
        }
    }

    private void recursivelyAddMatchingFiles(String path, File dir) {
        String singleWildcardPath = this.convertDoubleToSingleWildcard(path);
        this.addMatchingSubfiles(singleWildcardPath, dir);
    }

    private boolean isExpandableSingleWildcard(String path, File dir) {
        return this.pathHasSingleWildcard(path) && dir.exists();
    }

    private boolean isExpandableDoubleWildcard(String path, File dir) {
        return this.pathHasDoubleWildCard(path) && dir.exists();
    }

    private boolean pathHasSingleWildcard(String path) {
        return path.indexOf(42) != -1;
    }

    private String convertDoubleToSingleWildcard(String path) {
        path = path.replaceFirst("\\*\\*", "*");
        return path;
    }

    private boolean pathHasDoubleWildCard(String path) {
        return path.contains("**");
    }

    private void addMatchingFiles(String path, File dir) {
        File[] files;
        String fileName = new File(path).getName();
        for (File file : files = dir.listFiles((FilenameFilter)new Wildcard(fileName))) {
            this.allPaths.add(file.getPath());
        }
    }

    private void addMatchingSubfiles(String path, File dir) {
        this.addMatchingFiles(path, dir);
        for (File file : dir.listFiles()) {
            if (!file.isDirectory()) continue;
            this.addMatchingSubfiles(path, file);
        }
    }

    private void addSeparatorIfNecessary(StringBuffer pathsString, String separator) {
        if (pathsString.length() > 0) {
            pathsString.append(separator);
        }
    }

    protected List<String> getItemsFromPage(WikiPage page) {
        return page.readOnlyData().getClasspaths();
    }
}

