/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.components;

import fitnesse.components.CompositePageFinder;
import fitnesse.components.PageFinder;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class CompositePageFinderTestCase {
    protected PageFinder delegate;
    protected CompositePageFinder sut;
    protected WikiPage page;
    PageCrawler crawler;
    protected WikiPage pageOne;
    protected WikiPage pageTwo;
    protected WikiPage pageThree;

    @Before
    public void init() throws Exception {
        this.delegate = (PageFinder)Mockito.mock(PageFinder.class);
        this.page = InMemoryPage.makeRoot((String)"RooT");
        this.crawler = this.page.getPageCrawler();
        this.pageOne = this.crawler.addPage(this.page, PathParser.parse((String)"PageOne"), "this is page one ^ChildPage");
        this.pageTwo = this.crawler.addPage(this.page, PathParser.parse((String)"PageTwo"), "I am Page Two my brother is PageOne . SomeMissingPage");
        this.pageThree = this.crawler.addPage(this.page, PathParser.parse((String)"PageThree"), "This is !-PageThree-!, I Have \n!include PageTwo");
        this.crawler.addPage(this.pageTwo, PathParser.parse((String)"ChildPage"), "I will be a virtual page to .PageOne ");
    }

    protected void setupMockWithEmptyReturnValue() throws Exception {
        Mockito.when((Object)this.delegate.search((WikiPage)Matchers.any(WikiPage.class))).thenReturn(new ArrayList());
    }

    protected List<WikiPage> setupWikiPageList(WikiPage ... pages) {
        ArrayList<WikiPage> returned = new ArrayList<WikiPage>();
        for (WikiPage page : pages) {
            returned.add(page);
        }
        return returned;
    }

    protected void assertFoundResultsEqualsExpectation(List<WikiPage> expected2, List<WikiPage> results) {
        Assert.assertEquals((long)expected2.size(), (long)results.size());
        Assert.assertTrue((boolean)results.containsAll(expected2));
    }
}

