/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.html;

import fitnesse.html.HtmlElement;
import fitnesse.html.HtmlTag;
import fitnesse.html.RawHtml;
import java.util.LinkedList;
import java.util.List;

public class HtmlTag
extends HtmlElement {
    public LinkedList<HtmlElement> childTags = new LinkedList();
    protected List<Attribute> attributes = new LinkedList();
    protected String tagName = "youreIt";
    public String tail;
    public String head;
    public boolean isInline;

    public HtmlTag(String tagName) {
        this.tagName = tagName;
    }

    public HtmlTag(String tagName, String content) {
        this(tagName);
        this.add(content);
    }

    public HtmlTag(String tagName, HtmlElement child) {
        this(tagName);
        this.add(child);
    }

    public String tagName() {
        return this.tagName;
    }

    public String html() {
        return this.html(0);
    }

    public String htmlInline() {
        this.isInline = true;
        return this.html(0);
    }

    public String html(int depth) {
        return new HtmlFormatter(this, depth).format();
    }

    private boolean hasChildren() {
        return this.childTags.size() > 0;
    }

    public void add(String s) {
        this.add((HtmlElement)new RawHtml(s));
    }

    public void add(HtmlElement element) {
        this.childTags.add(element);
    }

    public void addAttribute(String key, String value) {
        this.attributes.add(new Attribute(key, value));
    }

    public void use(String s) {
        this.use((HtmlElement)new RawHtml(s));
    }

    public void use(HtmlElement element) {
        this.childTags.clear();
        this.add(element);
    }

    public String getAttribute(String key) {
        for (Attribute attribute : this.attributes) {
            if (key == null || !key.equals(attribute.name)) continue;
            return attribute.value;
        }
        return null;
    }

    protected String makeIndent(int depth) {
        StringBuilder indent = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            indent.append('\t');
        }
        return indent.toString();
    }

    static /* synthetic */ boolean access$000(HtmlTag x0) {
        return x0.hasChildren();
    }
}

