/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.http;

import fitnesse.http.MockRequestBuilder;
import fitnesse.http.Request;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class MockRequestBuilderTest {
    @Test
    public void aCommandWithASlashShouldGenerateARequestResourceWithoutASlash() {
        Assert.assertThat((Object)this.requestFrom("/myCommand").getResource(), (Matcher)CoreMatchers.is((Object)"myCommand"));
    }

    @Test
    public void aCommandWithoutASlashShouldGenerateARequestResourceWithoutASlash() {
        Assert.assertThat((Object)this.requestFrom("myCommand").getResource(), (Matcher)CoreMatchers.is((Object)"myCommand"));
    }

    @Test
    public void aCommandShouldBeCorrectlyDeducedWhenCredentialsAreSpecified() {
        Request request = this.requestFrom("user:pass:/myCommand");
        Assert.assertThat((Object)request.getResource(), (Matcher)CoreMatchers.is((Object)"myCommand"));
    }

    @Test
    public void requestAuthenticationShouldBeCorrectlySetWhenCredentialsAreSpecified() {
        Request request = this.requestFrom("user:pass:/myCommand");
        Assert.assertThat((Object)request.getAuthorizationUsername(), (Matcher)CoreMatchers.is((Object)"user"));
        Assert.assertThat((Object)request.getAuthorizationPassword(), (Matcher)CoreMatchers.is((Object)"pass"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void aSpecificationShouldBeWellFormed() {
        this.requestFrom("abc:/myCommand");
    }

    protected Request requestFrom(String commandSpecification) {
        return new MockRequestBuilder(commandSpecification).build();
    }
}

