/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.junit;

import fitnesse.responders.run.ResultsListener;
import fitnesse.testsystems.CompositeExecutionLog;
import fitnesse.testsystems.TestPage;
import fitnesse.testsystems.TestSummary;
import fitnesse.testsystems.TestSystem;
import fitnesse.testsystems.slim.results.ExceptionResult;
import fitnesse.testsystems.slim.results.TestResult;
import fitnesse.testsystems.slim.tables.Assertion;
import fitnesse.wiki.WikiPagePath;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import util.TimeMeasurement;

public class JUnitRunNotifierResultsListener
implements ResultsListener {
    private final Class<?> mainClass;
    private final RunNotifier notifier;

    public JUnitRunNotifierResultsListener(RunNotifier notifier, Class<?> mainClass) {
        this.notifier = notifier;
        this.mainClass = mainClass;
    }

    public void allTestingComplete(TimeMeasurement totalTimeMeasurement) {
    }

    public void announceNumberTestsToRun(int testsToRun) {
    }

    public void errorOccured() {
    }

    public void newTestStarted(TestPage test, TimeMeasurement timeMeasurement) {
        if (test.isTestPage()) {
            this.notifier.fireTestStarted(this.descriptionFor(test));
        }
    }

    private Description descriptionFor(TestPage test) {
        return Description.createTestDescription((Class)this.mainClass, (String)new WikiPagePath(test.getSourcePage()).toString());
    }

    public void setExecutionLogAndTrackingId(String stopResponderId, CompositeExecutionLog log) {
    }

    public void testComplete(TestPage test, TestSummary testSummary, TimeMeasurement timeMeasurement) {
        if (testSummary.wrong == 0 && testSummary.exceptions == 0) {
            if (test.isTestPage()) {
                this.notifier.fireTestFinished(this.descriptionFor(test));
            }
        } else {
            this.notifier.fireTestFailure(new Failure(this.descriptionFor(test), (Throwable)((Object)new AssertionError((Object)("wrong: " + testSummary.wrong + " exceptions: " + testSummary.exceptions)))));
        }
    }

    public void testOutputChunk(String output) {
    }

    public void testAssertionVerified(Assertion assertion, TestResult testResult) {
    }

    public void testExceptionOccurred(Assertion assertion, ExceptionResult exceptionResult) {
    }

    public void testSystemStarted(TestSystem testSystem, String testSystemName, String testRunner) {
    }
}

