/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.FitNesseContext;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureReadOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.NotFoundResponder;
import fitnesse.responders.WikiImporter;
import fitnesse.responders.WikiImporterClient;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiImportProperty;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wiki.WikiPageProperty;
import java.net.MalformedURLException;

public class ImportAndViewResponder
implements SecureResponder,
WikiImporterClient {
    private WikiPage page;

    public Response makeResponse(FitNesseContext context, Request request) throws MalformedURLException {
        String resource = request.getResource();
        if ("".equals(resource)) {
            resource = "FrontPage";
        }
        this.loadPage(resource, context);
        if (this.page == null) {
            return new NotFoundResponder().makeResponse(context, request);
        }
        this.loadPageData();
        SimpleResponse response = new SimpleResponse();
        response.redirect(resource);
        return response;
    }

    protected void loadPage(String resource, FitNesseContext context) {
        WikiPagePath path = PathParser.parse((String)resource);
        PageCrawler crawler = context.root.getPageCrawler();
        this.page = crawler.getPage(context.root, path);
    }

    protected void loadPageData() throws MalformedURLException {
        PageData pageData = this.page.getData();
        WikiImportProperty importProperty = WikiImportProperty.createFrom((WikiPageProperty)pageData.getProperties());
        if (importProperty != null) {
            WikiImporter importer = new WikiImporter();
            importer.setWikiImporterClient((WikiImporterClient)this);
            importer.parseUrl(importProperty.getSourceUrl());
            importer.importRemotePageContent(this.page);
        }
    }

    public void pageImported(WikiPage localPage) {
    }

    public void pageImportError(WikiPage localPage, Exception e) {
        e.printStackTrace();
    }

    public SecureOperation getSecureOperation() {
        return new SecureReadOperation();
    }
}

