/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.http.MockRequest;
import fitnesse.http.Request;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.PacketResponder;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PacketResponderTest {
    protected WikiPage root;
    protected MockRequest request;
    protected Responder responder;
    protected PageCrawler crawler;
    protected FitNesseContext context;
    private SimpleResponse response;

    @Before
    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"RooT");
        this.crawler = this.root.getPageCrawler();
        this.request = new MockRequest();
        this.responder = new PacketResponder();
        this.context = FitNesseUtil.makeTestContext((WikiPage)this.root);
    }

    private SimpleResponse makeResponse() throws Exception {
        return (SimpleResponse)this.responder.makeResponse(this.context, (Request)this.request);
    }

    private void assertPageWithTableResponseWith(String table, String expected) throws Exception {
        this.crawler.addPage(this.root, PathParser.parse((String)"TablePage"), table);
        this.request.setResource("TablePage");
        SimpleResponse response = this.makeResponse();
        Assert.assertEquals((Object)expected, (Object)response.getContent());
    }

    @Test
    public void noSuchPage() throws Exception {
        this.request.setResource("NoSuchPage");
        this.response = this.makeResponse();
        Assert.assertEquals((long)404L, (long)this.response.getStatus());
    }

    @Test
    public void pageWithNoTables() throws Exception {
        this.crawler.addPage(this.root, PathParser.parse((String)"SimplePage"), "simple content");
        this.request.setResource("SimplePage");
        SimpleResponse response = this.makeResponse();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"{\"tables\": []}", (Object)response.getContent());
    }

    @Test
    public void pageWithOneSimpleTable() throws Exception {
        this.assertPageWithTableResponseWith("|cell|\n", "{\"tables\": [{\"cell\": {}}]}");
    }

    @Test
    public void pageWithOneSimplePair() throws Exception {
        this.assertPageWithTableResponseWith("|name|value|\n", "{\"tables\": [{\"name\": \"value\"}]}");
    }

    @Test
    public void pageWithTwoPairs() throws Exception {
        this.assertPageWithTableResponseWith("|name1|value1|\n|name2|value2|\n", "{\"tables\": [{\n \"name1\": \"value1\",\n \"name2\": \"value2\"\n}]}");
    }

    @Test
    public void twoTablesWithSimplePairs() throws Exception {
        this.assertPageWithTableResponseWith("|n|v|\n\n|n2|v2|\n", "{\"tables\": [\n {\"n\": \"v\"},\n {\"n2\": \"v2\"}\n]}");
    }

    @Test
    public void oneTableWithNestedPair() throws Exception {
        JSONObject expected = new JSONObject("{\"tables\": [{\"n\": {\"m\": \"v\"}}]}");
        this.assertPageWithTableResponseWith("|n|\n||m|v|\n", expected.toString(1));
    }

    @Test
    public void tableWithBlankLinesIgnored() throws Exception {
        JSONObject expected = new JSONObject("{\"tables\": [{\"n\": {\"m\": \"v\"}}]}");
        this.assertPageWithTableResponseWith("|n|\n||||\n||m|v|\n", expected.toString(1));
    }

    @Test
    public void deeplyNestedTable() throws Exception {
        String table = "|bob|\n||Angela|\n|||Lexy|6|\n|||Sami|4|\n|||Mandy|2|\n||Micah|\n|||Luka|5|\n||Gina|\n||Justin|\n";
        String expectedString = "{\"tables\": [{\"bob\": {\n \"Angela\": {\n  \"Lexy\": \"6\",\n  \"Mandy\": \"2\",\n  \"Sami\": \"4\"\n },\n \"Gina\": {},\n \"Justin\": {},\n \"Micah\": {\"Luka\": \"5\"}\n}}]}";
        JSONObject expected = new JSONObject(expectedString);
        this.assertPageWithTableResponseWith(table, expected.toString(1));
    }

    @Test
    public void jsonpQueryArgument() throws Exception {
        this.request.addInput("jsonp", (Object)"load");
        this.assertPageWithTableResponseWith("|cell|\n", "load({\"tables\": [{\"cell\": {}}]})");
    }
}

