/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.http.MockRequest;
import fitnesse.http.Request;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.SerializedPageResponder;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.FileSystemPage;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.ProxyPage;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageProperties;
import fitnesse.wiki.WikiPageProperty;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import util.FileUtil;
import util.RegexTestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class SerializedPageResponderTest
extends RegexTestCase {
    private final String RootPath = "TestRooT";
    private PageCrawler crawler;
    private WikiPage root;
    private MockRequest request;

    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"RooT");
        this.crawler = this.root.getPageCrawler();
        this.request = new MockRequest();
    }

    public void tearDown() throws Exception {
        FileUtil.deleteFileSystemDirectory((String)"TestRooT");
    }

    public void testWithInMemory() throws Exception {
        Object obj = this.doSetUpWith(this.root, "bones");
        this.doTestWith(obj);
    }

    public void testWithFileSystem() throws Exception {
        this.root = new FileSystemPage(".", "TestRooT");
        Object obj = this.doSetUpWith(this.root, "bones");
        FileUtil.deleteFileSystemDirectory((String)"TestRooT");
        this.doTestWith(obj);
    }

    private void doTestWith(Object obj) throws Exception {
        SerializedPageResponderTest.assertNotNull((Object)obj);
        SerializedPageResponderTest.assertEquals((boolean)true, (boolean)(obj instanceof ProxyPage));
        WikiPage page = (WikiPage)obj;
        SerializedPageResponderTest.assertEquals((String)"PageOne", (String)page.getName());
    }

    private Object doSetUpWith(WikiPage root, String proxyType) throws Exception {
        WikiPage page1 = this.crawler.addPage(root, PathParser.parse((String)"PageOne"), "this is page one");
        PageData data = page1.getData();
        data.setAttribute("Attr1", "true");
        page1.commit(data);
        this.crawler.addPage(page1, PathParser.parse((String)"ChildOne"), "this is child one");
        this.request.addInput("type", (Object)proxyType);
        this.request.setResource("PageOne");
        return this.getObject(root, this.request);
    }

    private Object getObject(WikiPage root, MockRequest request) throws Exception {
        SerializedPageResponder responder = new SerializedPageResponder();
        SimpleResponse response = (SimpleResponse)responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)root), (Request)request);
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(response.getContentBytes()));
        return ois.readObject();
    }

    public void testGetContentAndAttributes() throws Exception {
        Object obj = this.doSetUpWith(this.root, "meat");
        SerializedPageResponderTest.assertNotNull((Object)obj);
        SerializedPageResponderTest.assertTrue((boolean)(obj instanceof PageData));
        PageData data = (PageData)obj;
        SerializedPageResponderTest.assertEquals((String)"this is page one", (String)data.getContent());
        WikiPageProperties props = data.getProperties();
        SerializedPageResponderTest.assertTrue((boolean)props.has("Attr1"));
    }

    public void testGetVersionOfPageData() throws Exception {
        WikiPage page = this.crawler.addPage(this.root, PathParser.parse((String)"PageOne"), "some content");
        VersionInfo commitRecord = page.commit(page.getData());
        this.request.addInput("type", (Object)"meat");
        this.request.addInput("version", (Object)commitRecord.getName());
        this.request.setResource("PageOne");
        Object obj = this.getObject(this.root, this.request);
        SerializedPageResponderTest.assertEquals(PageData.class, obj.getClass());
        PageData data = (PageData)obj;
        SerializedPageResponderTest.assertEquals((String)"some content", (String)data.getContent());
    }

    public void testGetPageHieratchyAsXml() throws Exception {
        this.crawler.addPage(this.root, PathParser.parse((String)"PageOne"));
        this.crawler.addPage(this.root, PathParser.parse((String)"PageOne.ChildOne"));
        this.crawler.addPage(this.root, PathParser.parse((String)"PageTwo"));
        this.request.setResource("root");
        this.request.addInput("type", (Object)"pages");
        SerializedPageResponder responder = new SerializedPageResponder();
        SimpleResponse response = (SimpleResponse)responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.root), (Request)this.request);
        String xml = response.getContent();
        SerializedPageResponderTest.assertEquals((String)"text/xml", (String)response.getContentType());
        SerializedPageResponderTest.assertSubString((String)"<name>PageOne</name>", (String)xml);
        SerializedPageResponderTest.assertSubString((String)"<name>PageTwo</name>", (String)xml);
        SerializedPageResponderTest.assertSubString((String)"<name>ChildOne</name>", (String)xml);
    }

    public void testGetPageHieratchyAsXmlDoesntContainSymbolicLinks() throws Exception {
        WikiPage pageOne = this.crawler.addPage(this.root, PathParser.parse((String)"PageOne"));
        this.crawler.addPage(this.root, PathParser.parse((String)"PageOne.ChildOne"));
        this.crawler.addPage(this.root, PathParser.parse((String)"PageTwo"));
        PageData data = pageOne.getData();
        WikiPageProperties properties = data.getProperties();
        WikiPageProperty symLinks = properties.set("SymbolicLinks");
        symLinks.set("SymPage", "PageTwo");
        pageOne.commit(data);
        this.request.setResource("root");
        this.request.addInput("type", (Object)"pages");
        SerializedPageResponder responder = new SerializedPageResponder();
        SimpleResponse response = (SimpleResponse)responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.root), (Request)this.request);
        String xml = response.getContent();
        SerializedPageResponderTest.assertEquals((String)"text/xml", (String)response.getContentType());
        SerializedPageResponderTest.assertSubString((String)"<name>PageOne</name>", (String)xml);
        SerializedPageResponderTest.assertSubString((String)"<name>PageTwo</name>", (String)xml);
        SerializedPageResponderTest.assertSubString((String)"<name>ChildOne</name>", (String)xml);
        SerializedPageResponderTest.assertNotSubString((String)"SymPage", (String)xml);
    }

    public void testGetDataAsHtml() throws Exception {
        this.crawler.addPage(this.root, PathParser.parse((String)"TestPageOne"), "test page");
        this.request.setResource("TestPageOne");
        this.request.addInput("type", (Object)"data");
        SerializedPageResponder responder = new SerializedPageResponder();
        SimpleResponse response = (SimpleResponse)responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.root), (Request)this.request);
        String xml = response.getContent();
        SerializedPageResponderTest.assertEquals((String)"text/xml", (String)response.getContentType());
        SerializedPageResponderTest.assertSubString((String)"test page", (String)xml);
        SerializedPageResponderTest.assertSubString((String)"<Test", (String)xml);
    }
}

